/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.plugin.gui;

import net.momirealms.craftengine.core.plugin.gui.Gui;
import net.momirealms.craftengine.core.plugin.gui.GuiElement;

public interface Ingredient {
    public static final Ingredient EMPTY = gui -> GuiElement.constant(null, (e, c) -> c.cancel());

    public GuiElement element(Gui var1);

    public static Ingredient simple(GuiElement element) {
        return new SimpleIngredient(element);
    }

    public static Ingredient paged() {
        return new PagedIngredient();
    }

    public static class SimpleIngredient
    implements Ingredient {
        private final GuiElement element;

        public SimpleIngredient(GuiElement element) {
            this.element = element;
        }

        @Override
        public GuiElement element(Gui gui) {
            return this.element;
        }
    }

    public static class PagedIngredient
    implements Ingredient {
        private int order = 0;

        @Override
        public GuiElement element(Gui gui) {
            return GuiElement.ordered(this.order++);
        }
    }
}

