/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.plugin.locale;

import com.google.common.collect.ImmutableList;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.momirealms.craftengine.core.block.CustomBlock;
import net.momirealms.craftengine.core.block.ImmutableBlockState;
import net.momirealms.craftengine.core.block.parser.BlockStateParser;
import net.momirealms.craftengine.core.plugin.CraftEngine;
import net.momirealms.craftengine.core.util.Key;
import org.jetbrains.annotations.Nullable;

public class I18NData {
    private static final Map<String, Function<String, List<String>>> LANG_KEY_PROCESSORS = new HashMap<String, Function<String, List<String>>>();
    public Map<String, String> translations = new HashMap<String, String>();

    public void processTranslations() {
        HashMap<String, String> temp = new HashMap<String, String>(Math.max(10, this.translations.size()));
        for (Map.Entry<String, String> entry : this.translations.entrySet()) {
            String key = entry.getKey();
            String[] split = key.split(":", 2);
            if (split.length == 2) {
                Optional.ofNullable(LANG_KEY_PROCESSORS.get(split[0])).ifPresentOrElse(processor -> {
                    for (String result : (List)processor.apply(split[1])) {
                        temp.put(result, (String)entry.getValue());
                    }
                }, () -> CraftEngine.instance().logger().warn("Unknown lang type: " + key));
                continue;
            }
            temp.put(key, entry.getValue());
        }
        this.translations = temp;
    }

    public void addTranslations(Map<String, String> data) {
        this.translations.putAll(data);
    }

    public void addTranslation(String key, String value) {
        this.translations.put(key, value);
    }

    @Nullable
    public String translate(String key) {
        return this.translations.get(key);
    }

    public String toString() {
        return "I18NData{" + String.valueOf(this.translations) + "}";
    }

    public static void merge(Map<String, I18NData> target, Map<String, I18NData> source) {
        source.forEach((key, value) -> {
            I18NData copy = new I18NData();
            copy.addTranslations(value.translations);
            target.merge((String)key, copy, (existing, newData) -> {
                existing.addTranslations(newData.translations);
                return existing;
            });
        });
    }

    private static String stateToRealBlockId(ImmutableBlockState state) {
        String id = state.customBlockState().literalObject().toString();
        int first = -1;
        int last = -1;
        for (int i = 0; i < id.length(); ++i) {
            char c = id.charAt(i);
            if (c == '{' && first == -1) {
                first = i;
                continue;
            }
            if (c != '}') continue;
            last = i;
        }
        if (first == -1 || last == -1 || last <= first) {
            throw new IllegalArgumentException("Invalid block state: " + id);
        }
        int length = last - first - 1;
        char[] chars = new char[length];
        id.getChars(first + 1, last, chars, 0);
        for (int i = 0; i < length; ++i) {
            if (chars[i] != ':') continue;
            chars[i] = 46;
        }
        return new String(chars);
    }

    static {
        LANG_KEY_PROCESSORS.put("block_name", id -> {
            if (id.contains("[") && id.contains("]")) {
                ImmutableBlockState parsed = BlockStateParser.deserialize(id);
                if (parsed == null) {
                    return List.of(id);
                }
                return List.of("block." + I18NData.stateToRealBlockId(parsed));
            }
            Key blockId = Key.of(id);
            Optional<CustomBlock> blockOptional = CraftEngine.instance().blockManager().blockById(blockId);
            if (blockOptional.isPresent()) {
                ImmutableList<ImmutableBlockState> states = blockOptional.get().variantProvider().states();
                if (states.size() == 1) {
                    return List.of("block." + I18NData.stateToRealBlockId((ImmutableBlockState)states.getFirst()));
                }
                ArrayList<CallSite> processed = new ArrayList<CallSite>();
                for (ImmutableBlockState state : states) {
                    processed.add((CallSite)((Object)("block." + I18NData.stateToRealBlockId(state))));
                }
                return processed;
            }
            return List.of(id);
        });
    }
}

