/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.plugin.locale;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.momirealms.craftengine.core.plugin.Manageable;
import net.momirealms.craftengine.core.plugin.config.ConfigParser;
import net.momirealms.craftengine.core.plugin.locale.I18NData;
import net.momirealms.craftengine.core.plugin.locale.TranslationManagerImpl;
import net.momirealms.craftengine.libraries.adventure.text.Component;
import net.momirealms.craftengine.libraries.adventure.translation.Translator;
import org.jetbrains.annotations.Nullable;

public interface TranslationManager
extends Manageable {
    public static final Set<String> ALL_LANG = Set.of("af_za", "ar_sa", "ast_es", "az_az", "ba_ru", "bar", "be_by", "be_latn", "bg_bg", "br_fr", "brb", "bs_ba", "ca_es", "cs_cz", "cy_gb", "da_dk", "de_at", "de_ch", "de_de", "el_gr", "en_au", "en_ca", "en_gb", "en_nz", "en_pt", "en_ud", "en_us", "enp", "enws", "eo_uy", "es_ar", "es_cl", "es_ec", "es_es", "es_mx", "es_uy", "es_ve", "esan", "et_ee", "eu_es", "fa_ir", "fi_fi", "fil_ph", "fo_fo", "fr_ca", "fr_fr", "fra_de", "fur_it", "fy_nl", "ga_ie", "gd_gb", "gl_es", "haw_us", "he_il", "hi_in", "hn_no", "hr_hr", "hu_hu", "hy_am", "id_id", "ig_ng", "io_en", "is_is", "isv", "it_it", "ja_jp", "jbo_en", "ka_ge", "kk_kz", "kn_in", "ko_kr", "ksh", "kw_gb", "ky_kg", "la_la", "lb_lu", "li_li", "lmo", "lo_la", "lol_us", "lt_lt", "lv_lv", "lzh", "mk_mk", "mn_mn", "ms_my", "mt_mt", "nah", "nds_de", "nl_be", "nl_nl", "nn_no", "no_no", "oc_fr", "ovd", "pl_pl", "pls", "pt_br", "pt_pt", "qya_aa", "ro_ro", "rpr", "ru_ru", "ry_ua", "sah_sah", "se_no", "sk_sk", "sl_si", "so_so", "sq_al", "sr_cs", "sr_sp", "sv_se", "sxu", "szl", "ta_in", "th_th", "tl_ph", "tlh_aa", "tok", "tr_tr", "tt_ru", "tzo_mx", "uk_ua", "val_es", "vec_it", "vi_vn", "vp_vl", "yi_de", "yo_ng", "zh_cn", "zh_hk", "zh_tw", "zlm_arab");
    public static final Map<String, List<String>> LOCALE_2_COUNTRIES = ALL_LANG.stream().map(lang -> lang.split("_")).filter(split -> ((String[])split).length >= 2).collect(Collectors.groupingBy(split -> split[0], Collectors.mapping(split -> split[1], Collectors.toUnmodifiableList())));

    public static TranslationManager instance() {
        return TranslationManagerImpl.instance;
    }

    public ConfigParser[] parsers();

    default public String miniMessageTranslation(String key) {
        return this.miniMessageTranslation(key, null);
    }

    public String miniMessageTranslation(String var1, @Nullable Locale var2);

    default public Component render(Component component) {
        return this.render(component, null);
    }

    public Component render(Component var1, @Nullable Locale var2);

    @Nullable
    public static Locale parseLocale(@Nullable String locale) {
        return locale == null || locale.isEmpty() ? null : Translator.parseLocale((String)locale);
    }

    public void log(String var1, String ... var2);

    public Map<String, I18NData> clientLangData();

    public void addClientTranslation(String var1, Map<String, String> var2);
}

