/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.plugin.text.minimessage;

import net.momirealms.craftengine.core.plugin.CraftEngine;
import net.momirealms.craftengine.core.plugin.context.PlayerContext;
import net.momirealms.craftengine.core.util.AdventureHelper;
import net.momirealms.craftengine.libraries.adventure.text.Component;
import net.momirealms.craftengine.libraries.adventure.text.minimessage.Context;
import net.momirealms.craftengine.libraries.adventure.text.minimessage.ParsingException;
import net.momirealms.craftengine.libraries.adventure.text.minimessage.tag.Tag;
import net.momirealms.craftengine.libraries.adventure.text.minimessage.tag.resolver.ArgumentQueue;
import net.momirealms.craftengine.libraries.adventure.text.minimessage.tag.resolver.TagResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlaceholderTag
implements TagResolver {
    private final net.momirealms.craftengine.core.plugin.context.Context context;

    public PlaceholderTag(@NotNull net.momirealms.craftengine.core.plugin.context.Context context) {
        this.context = context;
    }

    @Nullable
    public Tag resolve(@NotNull String name, @NotNull ArgumentQueue arguments, @NotNull Context ctx) throws ParsingException {
        String parsed;
        if (!this.has(name) || !CraftEngine.instance().compatibilityManager().hasPlaceholderAPI()) {
            return null;
        }
        String rawArgument = arguments.popOr("No argument relational placeholder provided").toString();
        if (rawArgument.contains("<")) {
            rawArgument = AdventureHelper.resolvePlainStringTags(rawArgument, this.context.tagResolvers());
        }
        String placeholder = "%" + rawArgument + "%";
        net.momirealms.craftengine.core.plugin.context.Context context = this.context;
        if (context instanceof PlayerContext) {
            PlayerContext playerContext = (PlayerContext)((Object)context);
            v0 = CraftEngine.instance().compatibilityManager().parse(playerContext.player(), placeholder);
        } else {
            v0 = parsed = CraftEngine.instance().compatibilityManager().parse(null, placeholder);
        }
        if (parsed.equals(placeholder)) {
            parsed = arguments.popOr("No default papi value provided").toString();
        }
        return Tag.selfClosingInserting((Component)AdventureHelper.miniMessage().deserialize((Object)parsed));
    }

    public boolean has(@NotNull String name) {
        return "papi".equals(name);
    }
}

