/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.util;

import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.momirealms.craftengine.core.plugin.context.Context;
import net.momirealms.craftengine.core.plugin.text.component.ComponentProvider;
import net.momirealms.craftengine.core.util.VersionHelper;
import net.momirealms.craftengine.libraries.adventure.text.Component;
import net.momirealms.craftengine.libraries.adventure.text.ComponentIteratorFlag;
import net.momirealms.craftengine.libraries.adventure.text.ComponentIteratorType;
import net.momirealms.craftengine.libraries.adventure.text.ComponentLike;
import net.momirealms.craftengine.libraries.adventure.text.TextComponent;
import net.momirealms.craftengine.libraries.adventure.text.TextReplacementConfig;
import net.momirealms.craftengine.libraries.adventure.text.event.HoverEvent;
import net.momirealms.craftengine.libraries.adventure.text.event.HoverEventSource;
import net.momirealms.craftengine.libraries.adventure.text.minimessage.MiniMessage;
import net.momirealms.craftengine.libraries.adventure.text.minimessage.tag.resolver.TagResolver;
import net.momirealms.craftengine.libraries.adventure.text.serializer.gson.GsonComponentSerializer;
import net.momirealms.craftengine.libraries.adventure.text.serializer.json.JSONOptions;
import net.momirealms.craftengine.libraries.adventure.text.serializer.json.legacyimpl.NBTLegacyHoverEventSerializer;
import net.momirealms.craftengine.libraries.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.momirealms.craftengine.libraries.nbt.Tag;
import net.momirealms.craftengine.libraries.nbt.adventure.NBTComponentSerializer;
import net.momirealms.craftengine.libraries.nbt.adventure.NBTSerializerOptions;

public class AdventureHelper {
    public static final String EMPTY_COMPONENT = AdventureHelper.componentToJson((Component)Component.empty());
    private final MiniMessage miniMessage = MiniMessage.builder().build();
    private final MiniMessage miniMessageStrict = MiniMessage.builder().strict(true).build();
    private final MiniMessage miniMessageCustom = MiniMessage.builder().tags(TagResolver.empty()).build();
    private final GsonComponentSerializer gsonComponentSerializer;
    private final NBTComponentSerializer nbtComponentSerializer;
    private final LegacyComponentSerializer legacyComponentSerializer;
    private static final TextReplacementConfig REPLACE_LF = (TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("\n").replacement((ComponentLike)Component.newline()).build();
    private static final ComponentIteratorType SLICER = (component, deque, flags) -> {
        List children = component.children();
        for (int i = children.size() - 1; i >= 0; --i) {
            deque.addFirst(((Component)children.get(i)).applyFallbackStyle(component.style()));
        }
    };

    private AdventureHelper() {
        GsonComponentSerializer.Builder gsonBuilder = GsonComponentSerializer.builder();
        if (!VersionHelper.isOrAbove1_20_5()) {
            gsonBuilder.legacyHoverEventSerializer(NBTLegacyHoverEventSerializer.get());
            gsonBuilder.editOptions(b -> b.value(JSONOptions.EMIT_HOVER_SHOW_ENTITY_ID_AS_INT_ARRAY, (Object)false));
        }
        if (!VersionHelper.isOrAbove1_21_5()) {
            gsonBuilder.editOptions(b -> {
                b.value(JSONOptions.EMIT_CLICK_EVENT_TYPE, (Object)JSONOptions.ClickEventValueMode.CAMEL_CASE);
                b.value(JSONOptions.EMIT_HOVER_EVENT_TYPE, (Object)JSONOptions.HoverEventValueMode.CAMEL_CASE);
                b.value(JSONOptions.EMIT_HOVER_SHOW_ENTITY_KEY_AS_TYPE_AND_UUID_AS_ID, (Object)true);
            });
        }
        this.legacyComponentSerializer = LegacyComponentSerializer.builder().build();
        this.gsonComponentSerializer = gsonBuilder.build();
        this.nbtComponentSerializer = NBTComponentSerializer.builder().editOptions(b -> {
            if (!VersionHelper.isOrAbove1_21_5()) {
                b.value(NBTSerializerOptions.EMIT_CLICK_EVENT_TYPE, (Object)false);
                b.value(NBTSerializerOptions.EMIT_HOVER_EVENT_TYPE, (Object)false);
            }
            if (!VersionHelper.isOrAbove1_20_5()) {
                b.value(NBTSerializerOptions.DATA_COMPONENT_RELEASE, (Object)false);
            }
        }).build();
    }

    public static AdventureHelper getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public static MiniMessage miniMessage() {
        return AdventureHelper.getInstance().miniMessage;
    }

    public static MiniMessage customMiniMessage() {
        return AdventureHelper.getInstance().miniMessageCustom;
    }

    public static LegacyComponentSerializer getLegacy() {
        return AdventureHelper.getInstance().legacyComponentSerializer;
    }

    public static MiniMessage strictMiniMessage() {
        return AdventureHelper.getInstance().miniMessageStrict;
    }

    public static GsonComponentSerializer getGson() {
        return AdventureHelper.getInstance().gsonComponentSerializer;
    }

    public static NBTComponentSerializer getNBT() {
        return AdventureHelper.getInstance().nbtComponentSerializer;
    }

    public static String jsonToMiniMessage(String json) {
        return (String)AdventureHelper.getInstance().miniMessageStrict.serialize(AdventureHelper.getInstance().gsonComponentSerializer.deserialize((Object)json));
    }

    public static String componentToMiniMessage(Component component) {
        return (String)AdventureHelper.getInstance().miniMessageStrict.serialize(component);
    }

    public static Component jsonToComponent(String json) {
        return AdventureHelper.getInstance().gsonComponentSerializer.deserialize((Object)json);
    }

    public static Component jsonElementToComponent(JsonElement json) {
        return AdventureHelper.getInstance().gsonComponentSerializer.deserializeFromTree(json);
    }

    public static Component nbtToComponent(Tag tag) {
        return AdventureHelper.getInstance().nbtComponentSerializer.deserialize(tag);
    }

    public static Tag componentToNbt(Component component) {
        return (Tag)AdventureHelper.getInstance().nbtComponentSerializer.serialize(component);
    }

    public static String componentToJson(Component component) {
        return (String)AdventureHelper.getGson().serialize(component);
    }

    public static JsonElement componentToJsonElement(Component component) {
        return AdventureHelper.getGson().serializeToTree(component);
    }

    public static Tag componentToTag(Component component) {
        return (Tag)AdventureHelper.getNBT().serialize(component);
    }

    public static Component tagToComponent(Tag tag) {
        return AdventureHelper.getNBT().deserialize(tag);
    }

    public static Component replaceShowItem(Component component, Function<HoverEvent.ShowItem, HoverEvent.ShowItem> replacer) {
        HoverEvent hoverEvent = component.hoverEvent();
        if (hoverEvent != null && hoverEvent.action() == HoverEvent.Action.SHOW_ITEM) {
            Object showItem = hoverEvent.value();
            component = component.hoverEvent((HoverEventSource)HoverEvent.showItem((HoverEvent.ShowItem)replacer.apply((HoverEvent.ShowItem)showItem)));
        }
        ArrayList<Component> newChildren = new ArrayList<Component>();
        for (Component child : component.children()) {
            newChildren.add(AdventureHelper.replaceShowItem(child, replacer));
        }
        return component.children(newChildren);
    }

    public static List<Component> splitLines(Component component) {
        ArrayList<Component> result = new ArrayList<Component>(1);
        TextComponent line = Component.empty();
        Iterator it = component.replaceText(REPLACE_LF).iterator(SLICER, new ComponentIteratorFlag[0]);
        while (it.hasNext()) {
            TextComponent text;
            Component child = ((Component)it.next()).children(Collections.emptyList());
            if (child instanceof TextComponent && (text = (TextComponent)child).content().equals(Component.newline().content())) {
                result.add(line.compact());
                line = Component.empty();
                continue;
            }
            line = line.append(child);
        }
        if (Component.IS_NOT_EMPTY.test(line)) {
            result.add(line.compact());
        }
        return result;
    }

    public static boolean isLegacyColorCode(char c) {
        return c == '\u00a7' || c == '&';
    }

    public static String legacyToMiniMessage(String legacy) {
        StringBuilder stringBuilder = new StringBuilder();
        char[] chars = legacy.toCharArray();
        block25: for (int i = 0; i < chars.length; ++i) {
            if (!AdventureHelper.isLegacyColorCode(chars[i])) {
                stringBuilder.append(chars[i]);
                continue;
            }
            if (i + 1 >= chars.length) {
                stringBuilder.append(chars[i]);
                continue;
            }
            switch (chars[i + 1]) {
                case '0': {
                    stringBuilder.append("<black>");
                    break;
                }
                case '1': {
                    stringBuilder.append("<dark_blue>");
                    break;
                }
                case '2': {
                    stringBuilder.append("<dark_green>");
                    break;
                }
                case '3': {
                    stringBuilder.append("<dark_aqua>");
                    break;
                }
                case '4': {
                    stringBuilder.append("<dark_red>");
                    break;
                }
                case '5': {
                    stringBuilder.append("<dark_purple>");
                    break;
                }
                case '6': {
                    stringBuilder.append("<gold>");
                    break;
                }
                case '7': {
                    stringBuilder.append("<gray>");
                    break;
                }
                case '8': {
                    stringBuilder.append("<dark_gray>");
                    break;
                }
                case '9': {
                    stringBuilder.append("<blue>");
                    break;
                }
                case 'a': {
                    stringBuilder.append("<green>");
                    break;
                }
                case 'b': {
                    stringBuilder.append("<aqua>");
                    break;
                }
                case 'c': {
                    stringBuilder.append("<red>");
                    break;
                }
                case 'd': {
                    stringBuilder.append("<light_purple>");
                    break;
                }
                case 'e': {
                    stringBuilder.append("<yellow>");
                    break;
                }
                case 'f': {
                    stringBuilder.append("<white>");
                    break;
                }
                case 'r': {
                    stringBuilder.append("<reset><!i>");
                    break;
                }
                case 'l': {
                    stringBuilder.append("<b>");
                    break;
                }
                case 'm': {
                    stringBuilder.append("<st>");
                    break;
                }
                case 'o': {
                    stringBuilder.append("<i>");
                    break;
                }
                case 'n': {
                    stringBuilder.append("<u>");
                    break;
                }
                case 'k': {
                    stringBuilder.append("<obf>");
                    break;
                }
                case 'x': {
                    if (!(i + 13 < chars.length && AdventureHelper.isLegacyColorCode(chars[i + 2]) && AdventureHelper.isLegacyColorCode(chars[i + 4]) && AdventureHelper.isLegacyColorCode(chars[i + 6]) && AdventureHelper.isLegacyColorCode(chars[i + 8]) && AdventureHelper.isLegacyColorCode(chars[i + 10]) && AdventureHelper.isLegacyColorCode(chars[i + 12]))) {
                        stringBuilder.append(chars[i]);
                        continue block25;
                    }
                    stringBuilder.append("<#").append(chars[i + 3]).append(chars[i + 5]).append(chars[i + 7]).append(chars[i + 9]).append(chars[i + 11]).append(chars[i + 13]).append(">");
                    i += 12;
                    break;
                }
                default: {
                    stringBuilder.append(chars[i]);
                    continue block25;
                }
            }
            ++i;
        }
        return stringBuilder.toString();
    }

    public static String plainTextContent(Component component) {
        StringBuilder sb = new StringBuilder();
        if (component instanceof TextComponent) {
            TextComponent textComponent = (TextComponent)component;
            sb.append(textComponent.content());
        }
        for (Component child : component.children()) {
            sb.append(AdventureHelper.plainTextContent(child));
        }
        return sb.toString();
    }

    public static boolean isPureTextComponent(Component component) {
        if (!(component instanceof TextComponent)) {
            return false;
        }
        TextComponent textComponent = (TextComponent)component;
        for (Component child : textComponent.children()) {
            if (AdventureHelper.isPureTextComponent(child)) continue;
            return false;
        }
        return true;
    }

    public static String resolvePlainStringTags(String raw, TagResolver ... resolvers) {
        Component resultComponent = AdventureHelper.customMiniMessage().deserialize(raw, resolvers);
        return AdventureHelper.plainTextContent(resultComponent);
    }

    public static Component replaceText(Component text, Map<String, ComponentProvider> replacements, Context context) {
        if (replacements.isEmpty()) {
            return text;
        }
        String patternString = replacements.keySet().stream().map(Pattern::quote).collect(Collectors.joining("|"));
        return text.replaceText(builder -> builder.match(Pattern.compile(patternString)).replacement((result, b) -> (ComponentLike)Optional.ofNullable((ComponentProvider)replacements.get(result.group())).orElseThrow(() -> new IllegalStateException("Could not find tag '" + result.group() + "'")).apply(context)));
    }

    private static class SingletonHolder {
        private static final AdventureHelper INSTANCE = new AdventureHelper();

        private SingletonHolder() {
        }
    }
}

