/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.util;

import java.util.function.Consumer;
import java.util.function.Supplier;

public interface Cancellable {
    public boolean isCancelled();

    public void setCancelled(boolean var1);

    public static Cancellable dummy() {
        return new Dummy();
    }

    public static Cancellable of(Supplier<Boolean> isCancelled, Consumer<Boolean> setCancelled) {
        return new Simple(isCancelled, setCancelled);
    }

    public static class Dummy
    implements Cancellable {
        private boolean cancelled;

        @Override
        public boolean isCancelled() {
            return this.cancelled;
        }

        @Override
        public void setCancelled(boolean cancel) {
            this.cancelled = cancel;
        }
    }

    public static class Simple
    implements Cancellable {
        private final Supplier<Boolean> isCancelled;
        private final Consumer<Boolean> setCancelled;

        public Simple(Supplier<Boolean> isCancelled, Consumer<Boolean> setCancelled) {
            this.isCancelled = isCancelled;
            this.setCancelled = setCancelled;
        }

        @Override
        public boolean isCancelled() {
            return this.isCancelled.get();
        }

        @Override
        public void setCancelled(boolean cancel) {
            this.setCancelled.accept(cancel);
        }
    }
}

