/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.util;

import java.util.stream.IntStream;
import net.momirealms.craftengine.core.plugin.locale.LocalizedResourceConfigException;

public class CharacterUtils {
    private CharacterUtils() {
    }

    public static char[] decodeUnicodeToChars(String unicodeString) {
        int count = unicodeString.length() / 6;
        if (unicodeString.length() % 6 != 0) {
            throw new LocalizedResourceConfigException("warning.config.image.invalid_unicode_string", unicodeString);
        }
        char[] chars = new char[count];
        int i = 0;
        for (int j = 0; j < count; ++j) {
            String hex = unicodeString.substring(i + 2, i + 6);
            try {
                chars[j] = (char)Integer.parseInt(hex, 16);
            }
            catch (NumberFormatException e) {
                throw new LocalizedResourceConfigException("warning.config.image.invalid_hex_value", e, hex);
            }
            i += 6;
        }
        return chars;
    }

    public static int charsToCodePoint(char[] chars) {
        if (chars.length == 1) {
            return chars[0];
        }
        if (chars.length == 2) {
            if (Character.isHighSurrogate(chars[0]) && Character.isLowSurrogate(chars[1])) {
                return Character.toCodePoint(chars[0], chars[1]);
            }
            throw new IllegalArgumentException("Invalid surrogate pair: not a valid high and low surrogate combination.");
        }
        throw new IllegalArgumentException("The given chars array must contain either 1 or 2 characters.");
    }

    public static int[] charsToCodePoints(char[] chars) {
        return IntStream.range(0, chars.length).filter(i -> !Character.isLowSurrogate(chars[i])).map(i -> {
            char c1 = chars[i];
            if (Character.isHighSurrogate(c1)) {
                if (i + 1 < chars.length && Character.isLowSurrogate(chars[i + 1])) {
                    char c2 = chars[++i];
                    return Character.toCodePoint(c1, c2);
                }
                throw new IllegalArgumentException("Illegal surrogate pair: High surrogate without matching low surrogate at index " + i);
            }
            return c1;
        }).toArray();
    }

    public static String encodeCharToUnicode(char c) {
        return String.format("\\u%04x", c);
    }

    public static String encodeCharsToUnicode(char[] chars) {
        StringBuilder builder = new StringBuilder();
        for (char value : chars) {
            builder.append(CharacterUtils.encodeCharToUnicode(value));
        }
        return builder.toString();
    }

    public static String replaceBackslashWithSlash(String input) {
        if (input == null || input.isEmpty()) {
            return input;
        }
        StringBuilder sb = new StringBuilder(input.length());
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            sb.append(c == '\\' ? (char)'/' : (char)c);
        }
        return sb.toString();
    }

    public static String replaceDoubleBackslashU(String input) {
        if (input == null || input.isEmpty()) {
            return input;
        }
        int length = input.length();
        StringBuilder sb = new StringBuilder(length);
        int i = 0;
        while (i < length) {
            if (i + 2 < length && input.charAt(i) == '\\' && input.charAt(i + 1) == '\\' && input.charAt(i + 2) == 'u') {
                sb.append("\\u");
                i += 3;
                continue;
            }
            sb.append(input.charAt(i));
            ++i;
        }
        return sb.toString();
    }
}

