/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.util;

import java.util.Arrays;
import net.momirealms.craftengine.core.util.MiscUtils;
import org.joml.Vector3f;

public class Color {
    private static final int BIT_MASK = 255;
    private static final byte DEFAULT_ALPHA = -1;
    private final int color;

    public Color(int color) {
        this.color = color;
    }

    public Color(int r, int g, int b) {
        this(-1, r, g, b);
    }

    public Color(int a, int r, int g, int b) {
        this(Color.toDecimal(a, r, g, b));
    }

    public int color() {
        return this.color;
    }

    public static int toDecimal(int a, int r, int g, int b) {
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static int toDecimal(int r, int g, int b) {
        return 0xFF000000 | r << 16 | g << 8 | b;
    }

    public static Color fromDecimal(int decimal) {
        return new Color(decimal);
    }

    public static Color fromVector3f(Vector3f vec) {
        return new Color(0 | MiscUtils.fastFloor(vec.x) << 16 | MiscUtils.fastFloor(vec.y) << 8 | MiscUtils.fastFloor(vec.z));
    }

    public static int opaque(int color) {
        return color | 0xFF000000;
    }

    public static int transparent(int color) {
        return color & 0xFFFFFF;
    }

    public static int alpha(int color) {
        return color >>> 24;
    }

    public static int red(int color) {
        return color >> 16 & 0xFF;
    }

    public static int green(int color) {
        return color >> 8 & 0xFF;
    }

    public static int blue(int color) {
        return color & 0xFF;
    }

    public static Color fromStrings(String[] strings) {
        if (strings.length == 3) {
            return Color.fromDecimal(Color.toDecimal(Integer.parseInt(strings[0]), Integer.parseInt(strings[1]), Integer.parseInt(strings[2])));
        }
        if (strings.length == 4) {
            return Color.fromDecimal(Color.toDecimal(Integer.parseInt(strings[0]), Integer.parseInt(strings[1]), Integer.parseInt(strings[2]), Integer.parseInt(strings[3])));
        }
        throw new IllegalArgumentException("Invalid color format: " + Arrays.toString(strings));
    }

    public int a() {
        return Color.alpha(this.color);
    }

    public int b() {
        return Color.blue(this.color);
    }

    public int g() {
        return Color.green(this.color);
    }

    public int r() {
        return Color.red(this.color);
    }
}

