/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.util;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Random;
import java.util.function.Predicate;
import net.momirealms.craftengine.core.entity.AbstractEntity;
import net.momirealms.craftengine.core.util.HorizontalDirection;
import net.momirealms.craftengine.core.util.MiscUtils;
import net.momirealms.craftengine.core.world.Vec3i;
import org.jetbrains.annotations.Nullable;

public enum Direction {
    DOWN(0, 1, -1, AxisDirection.NEGATIVE, Axis.Y, new Vec3i(0, -1, 0)),
    UP(1, 0, -1, AxisDirection.POSITIVE, Axis.Y, new Vec3i(0, 1, 0)),
    NORTH(2, 3, 2, AxisDirection.NEGATIVE, Axis.Z, new Vec3i(0, 0, -1)),
    SOUTH(3, 2, 0, AxisDirection.POSITIVE, Axis.Z, new Vec3i(0, 0, 1)),
    WEST(4, 5, 1, AxisDirection.NEGATIVE, Axis.X, new Vec3i(-1, 0, 0)),
    EAST(5, 4, 3, AxisDirection.POSITIVE, Axis.X, new Vec3i(1, 0, 0));

    private static final Direction[] VALUES;
    private static final Direction[] BY_3D_DATA;
    private static final Direction[] BY_2D_DATA;
    private final int data3d;
    private final int oppositeIndex;
    private final int data2d;
    private final Axis axis;
    private final AxisDirection axisDirection;
    private final Vec3i vec;
    private final int adjX;
    private final int adjY;
    private final int adjZ;

    private Direction(int id, int idOpposite, int idHorizontal, AxisDirection direction, Axis axis, Vec3i vector) {
        this.data3d = id;
        this.data2d = idHorizontal;
        this.oppositeIndex = idOpposite;
        this.axis = axis;
        this.axisDirection = direction;
        this.vec = vector;
        this.adjX = vector.x();
        this.adjY = vector.y();
        this.adjZ = vector.z();
    }

    public static Direction fromYaw(float yaw) {
        if ((yaw = Direction.normalizeAngle(yaw)) < 45.0f) {
            if (yaw > -45.0f) {
                return NORTH;
            }
            if (yaw > -135.0f) {
                return EAST;
            }
            return SOUTH;
        }
        if (yaw < 135.0f) {
            return WEST;
        }
        return SOUTH;
    }

    private static float normalizeAngle(float angle) {
        angle %= 360.0f;
        if ((angle = (angle + 360.0f) % 360.0f) > 180.0f) {
            angle -= 360.0f;
        }
        return angle;
    }

    public HorizontalDirection toHorizontalDirection() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0, 1 -> null;
            case 2 -> HorizontalDirection.NORTH;
            case 3 -> HorizontalDirection.SOUTH;
            case 4 -> HorizontalDirection.WEST;
            case 5 -> HorizontalDirection.EAST;
        };
    }

    public static Direction[] orderedByNearest(AbstractEntity entity) {
        Direction direction2;
        float f = entity.xRot() * ((float)Math.PI / 180);
        float f1 = -entity.yRot() * ((float)Math.PI / 180);
        float sin = MiscUtils.sin(f);
        float cos = MiscUtils.cos(f);
        float sin1 = MiscUtils.sin(f1);
        float cos1 = MiscUtils.cos(f1);
        boolean flag = sin1 > 0.0f;
        boolean flag1 = sin < 0.0f;
        boolean flag2 = cos1 > 0.0f;
        float f2 = flag ? sin1 : -sin1;
        float f3 = flag1 ? -sin : sin;
        float f4 = flag2 ? cos1 : -cos1;
        float f5 = f2 * cos;
        float f6 = f4 * cos;
        Direction direction = flag ? EAST : WEST;
        Direction direction1 = flag1 ? UP : DOWN;
        Direction direction3 = direction2 = flag2 ? SOUTH : NORTH;
        if (f2 > f4) {
            if (f3 > f5) {
                return Direction.createDirectionArray(direction1, direction, direction2);
            }
            return f6 > f3 ? Direction.createDirectionArray(direction, direction2, direction1) : Direction.createDirectionArray(direction, direction1, direction2);
        }
        if (f3 > f6) {
            return Direction.createDirectionArray(direction1, direction2, direction);
        }
        return f5 > f3 ? Direction.createDirectionArray(direction2, direction, direction1) : Direction.createDirectionArray(direction2, direction1, direction);
    }

    private static Direction[] createDirectionArray(Direction first, Direction second, Direction third) {
        return new Direction[]{first, second, third, third.opposite(), second.opposite(), first.opposite()};
    }

    public static float getYaw(Direction direction) {
        switch (direction.ordinal()) {
            case 2: {
                return 180.0f;
            }
            case 3: {
                return 0.0f;
            }
            case 4: {
                return 90.0f;
            }
            case 5: {
                return -90.0f;
            }
        }
        throw new IllegalArgumentException();
    }

    public int stepX() {
        return this.adjX;
    }

    public int stepY() {
        return this.adjY;
    }

    public int stepZ() {
        return this.adjZ;
    }

    public Vec3i vector() {
        return this.vec;
    }

    public Axis axis() {
        return this.axis;
    }

    public AxisDirection axisDirection() {
        return this.axisDirection;
    }

    public int data2d() {
        return this.data2d;
    }

    public int data3d() {
        return this.data3d;
    }

    public int oppositeIndex() {
        return this.oppositeIndex;
    }

    public Direction opposite() {
        return VALUES[this.oppositeIndex];
    }

    public Direction clockWise() {
        return switch (this.ordinal()) {
            case 2 -> EAST;
            case 3 -> WEST;
            case 4 -> NORTH;
            case 5 -> SOUTH;
            default -> throw new IllegalStateException();
        };
    }

    public Direction counterClockWise() {
        return switch (this.ordinal()) {
            case 2 -> WEST;
            case 3 -> EAST;
            case 4 -> SOUTH;
            case 5 -> NORTH;
            default -> throw new IllegalStateException();
        };
    }

    public static Direction getApproximateNearest(double x, double y, double z) {
        Direction nearestDirection = null;
        double maxDotProduct = -1.7976931348623157E308;
        for (Direction direction : Direction.values()) {
            double dotProduct = x * (double)direction.vec.x() + y * (double)direction.vec.y() + z * (double)direction.vec.z();
            if (!(dotProduct > maxDotProduct)) continue;
            maxDotProduct = dotProduct;
            nearestDirection = direction;
        }
        return nearestDirection;
    }

    public static Direction from3DDataValue(int id) {
        return BY_3D_DATA[Math.abs(id % BY_3D_DATA.length)];
    }

    public static Direction from2DDataValue(int value) {
        return BY_2D_DATA[Math.abs(value % BY_2D_DATA.length)];
    }

    public static Direction fromAxisAndDirection(Axis axis, AxisDirection direction) {
        return switch (axis.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                if (direction == AxisDirection.POSITIVE) {
                    yield EAST;
                }
                yield WEST;
            }
            case 1 -> {
                if (direction == AxisDirection.POSITIVE) {
                    yield UP;
                }
                yield DOWN;
            }
            case 2 -> direction == AxisDirection.POSITIVE ? SOUTH : NORTH;
        };
    }

    static {
        VALUES = Direction.values();
        BY_3D_DATA = (Direction[])Arrays.stream(VALUES).sorted(Comparator.comparingInt(direction -> direction.data3d)).toArray(Direction[]::new);
        BY_2D_DATA = (Direction[])Arrays.stream(VALUES).filter(direction -> direction.axis().isHorizontal()).sorted(Comparator.comparingInt(direction -> direction.data2d)).toArray(Direction[]::new);
    }

    public static enum Axis implements Predicate<Direction>
    {
        X{

            @Override
            public int choose(int x, int y, int z) {
                return x;
            }

            @Override
            public double choose(double x, double y, double z) {
                return x;
            }

            @Override
            public Direction getPositive() {
                return EAST;
            }

            @Override
            public Direction getNegative() {
                return WEST;
            }
        }
        ,
        Y{

            @Override
            public int choose(int x, int y, int z) {
                return y;
            }

            @Override
            public double choose(double x, double y, double z) {
                return y;
            }

            @Override
            public Direction getPositive() {
                return UP;
            }

            @Override
            public Direction getNegative() {
                return DOWN;
            }
        }
        ,
        Z{

            @Override
            public int choose(int x, int y, int z) {
                return z;
            }

            @Override
            public double choose(double x, double y, double z) {
                return z;
            }

            @Override
            public Direction getPositive() {
                return SOUTH;
            }

            @Override
            public Direction getNegative() {
                return NORTH;
            }
        };

        public static final Axis[] VALUES;

        public boolean isVertical() {
            return this == Y;
        }

        public boolean isHorizontal() {
            return this == X || this == Z;
        }

        public abstract Direction getPositive();

        public abstract Direction getNegative();

        public Direction[] getDirections() {
            return new Direction[]{this.getPositive(), this.getNegative()};
        }

        public static Axis random(Random random) {
            return Axis.values()[random.nextInt(VALUES.length)];
        }

        @Override
        public boolean test(@Nullable Direction direction) {
            return direction != null && direction.axis() == this;
        }

        public abstract int choose(int var1, int var2, int var3);

        public abstract double choose(double var1, double var3, double var5);

        static {
            VALUES = Axis.values();
        }
    }

    public static enum AxisDirection {
        POSITIVE(1),
        NEGATIVE(-1);

        private final int step;

        private AxisDirection(int offset) {
            this.step = offset;
        }

        public int step() {
            return this.step;
        }

        public AxisDirection opposite() {
            return this == POSITIVE ? NEGATIVE : POSITIVE;
        }
    }
}

