/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import net.momirealms.craftengine.core.util.IndexedIterable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntIdentityList
implements IndexedIterable<Integer> {
    private final int size;

    public IntIdentityList(int size) {
        this.size = size;
    }

    @Override
    public int getRawId(Integer value) {
        return value;
    }

    @Override
    @Nullable
    public Integer get(int index) {
        return index;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    @NotNull
    public Iterator<Integer> iterator() {
        return new IntIterator(this.size);
    }

    private static class IntIterator
    implements Iterator<Integer> {
        private final int size;
        private int current;

        public IntIterator(int size) {
            this.size = size;
            this.current = 0;
        }

        @Override
        public boolean hasNext() {
            return this.current < this.size;
        }

        @Override
        public Integer next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.current++;
        }
    }
}

