/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.util;

import java.util.concurrent.ThreadLocalRandom;

public final class RandomUtils {
    private RandomUtils() {
    }

    public static double generateRandomDouble(double min, double max) {
        return min + (max - min) * ThreadLocalRandom.current().nextDouble();
    }

    public static float generateRandomFloat(float min, float max) {
        return min + (max - min) * ThreadLocalRandom.current().nextFloat();
    }

    public static int generateRandomInt(int min, int max) {
        return min >= max ? min : ThreadLocalRandom.current().nextInt(max - min) + min;
    }

    public static boolean generateRandomBoolean() {
        return ThreadLocalRandom.current().nextBoolean();
    }

    public static long generateRandomLong() {
        return ThreadLocalRandom.current().nextLong();
    }

    public static double triangle(double mode, double deviation) {
        return mode + deviation * (RandomUtils.generateRandomDouble(0.0, 1.0) - RandomUtils.generateRandomDouble(0.0, 1.0));
    }

    public static <T> T getRandomElementFromArray(T[] array) {
        int index = ThreadLocalRandom.current().nextInt(array.length);
        return array[index];
    }

    public static <T> T[] getRandomElementsFromArray(T[] array, int count) {
        if (count > array.length) {
            throw new IllegalArgumentException("Count cannot be greater than array length");
        }
        Object[] result = new Object[count];
        for (int i = 0; i < count; ++i) {
            int index = ThreadLocalRandom.current().nextInt(array.length - i);
            result[i] = array[index];
            array[index] = array[array.length - i - 1];
        }
        return result;
    }
}

