/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.util;

import java.util.Random;
import net.momirealms.craftengine.core.util.Direction;

public enum Rotation {
    NONE,
    CLOCKWISE_90,
    CLOCKWISE_180,
    COUNTERCLOCKWISE_90;

    private static final Rotation[][] rotationMap;

    public Rotation getRotated(Rotation rotation) {
        int thisIndex = this.ordinal();
        int rotationIndex = rotation.ordinal();
        return rotationMap[thisIndex][rotationIndex];
    }

    public Direction rotate(Direction direction) {
        if (direction.axis() == Direction.Axis.Y) {
            return direction;
        }
        return switch (this.ordinal()) {
            case 1 -> direction.clockWise();
            case 2 -> direction.opposite();
            case 3 -> direction.counterClockWise();
            default -> direction;
        };
    }

    public int rotate(int rotation, int fullTurn) {
        return switch (this.ordinal()) {
            case 1 -> (rotation + fullTurn / 4) % fullTurn;
            case 2 -> (rotation + fullTurn / 2) % fullTurn;
            case 3 -> (rotation + fullTurn * 3 / 4) % fullTurn;
            default -> rotation;
        };
    }

    public static Rotation random(Random random) {
        return Rotation.values()[random.nextInt(Rotation.values().length)];
    }

    static {
        rotationMap = new Rotation[][]{{NONE, CLOCKWISE_90, CLOCKWISE_180, COUNTERCLOCKWISE_90}, {CLOCKWISE_90, CLOCKWISE_180, COUNTERCLOCKWISE_90, NONE}, {CLOCKWISE_180, COUNTERCLOCKWISE_90, NONE, CLOCKWISE_90}, {COUNTERCLOCKWISE_90, NONE, CLOCKWISE_90, CLOCKWISE_180}};
    }
}

