/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.util;

import java.util.HashMap;
import java.util.Map;
import net.momirealms.craftengine.core.item.ItemKeys;
import net.momirealms.craftengine.core.util.Key;
import org.jetbrains.annotations.Nullable;

public final class UniqueKey {
    private static final Map<Key, UniqueKey> CACHE = new HashMap<Key, UniqueKey>(4096, 0.5f);
    public static final UniqueKey AIR = UniqueKey.create(ItemKeys.AIR);
    private final Key key;

    private UniqueKey(Key key) {
        this.key = key;
    }

    public static UniqueKey create(Key key) {
        return CACHE.computeIfAbsent(key, UniqueKey::new);
    }

    @Nullable
    public static UniqueKey getCached(Key key) {
        return CACHE.get(key);
    }

    public Key key() {
        return this.key;
    }

    public String toString() {
        return this.key.toString();
    }
}

