/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.world;

import net.momirealms.craftengine.core.world.BlockPos;
import net.momirealms.craftengine.core.world.SectionPos;

public class ChunkPos {
    public static final long INVALID_CHUNK_POS = ChunkPos.asLong(1875066, 1875066);
    public final int x;
    public final int z;
    public final long longKey;

    public ChunkPos(int x, int z) {
        this.x = x;
        this.z = z;
        this.longKey = ChunkPos.asLong(this.x, this.z);
    }

    public static ChunkPos of(int x, int z) {
        return new ChunkPos(x, z);
    }

    public ChunkPos(BlockPos pos) {
        this.x = SectionPos.blockToSectionCoord(pos.x());
        this.z = SectionPos.blockToSectionCoord(pos.z());
        this.longKey = ChunkPos.asLong(this.x, this.z);
    }

    public ChunkPos(long pos) {
        this.x = (int)pos;
        this.z = (int)(pos >> 32);
        this.longKey = ChunkPos.asLong(this.x, this.z);
    }

    public String toString() {
        return "ChunkPos{x=" + this.x + ", z=" + this.z + ", longKey=" + this.longKey + "}";
    }

    public int x() {
        return this.x;
    }

    public int z() {
        return this.z;
    }

    public int regionX() {
        return this.x >> 5;
    }

    public int regionLocalX() {
        return this.x & 0x1F;
    }

    public int regionZ() {
        return this.z >> 5;
    }

    public int regionLocalZ() {
        return this.z & 0x1F;
    }

    public long longKey() {
        return this.longKey;
    }

    public ChunkPos[] adjacentChunkPos() {
        return ChunkPos.adjacentChunkPos(this);
    }

    public static long asLong(int chunkX, int chunkZ) {
        return (long)chunkX & 0xFFFFFFFFL | ((long)chunkZ & 0xFFFFFFFFL) << 32;
    }

    public static ChunkPos[] adjacentChunkPos(ChunkPos chunkPos) {
        return new ChunkPos[]{new ChunkPos(chunkPos.x, chunkPos.z - 1), new ChunkPos(chunkPos.x, chunkPos.z + 1), new ChunkPos(chunkPos.x + 1, chunkPos.z), new ChunkPos(chunkPos.x - 1, chunkPos.z)};
    }

    public final boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChunkPos)) {
            return false;
        }
        ChunkPos chunkPos = (ChunkPos)o;
        return this.longKey == chunkPos.longKey;
    }

    public int hashCode() {
        return Long.hashCode(this.longKey);
    }
}

