/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.world.chunk.storage;

import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.BitSet;

public class RegionBitmap {
    private final BitSet used = new BitSet();

    public void copyFrom(RegionBitmap other) {
        BitSet thisBitset = this.used;
        BitSet otherBitset = other.used;
        for (int i = 0; i < Math.max(thisBitset.size(), otherBitset.size()); ++i) {
            thisBitset.set(i, otherBitset.get(i));
        }
    }

    public boolean tryAllocate(int from, int length) {
        BitSet bitset = this.used;
        int firstSet = bitset.nextSetBit(from);
        if (firstSet > 0 && firstSet < from + length) {
            return false;
        }
        bitset.set(from, from + length);
        return true;
    }

    public void allocate(int start, int size) {
        this.used.set(start, start + size);
    }

    public void free(int start, int size) {
        this.used.clear(start, start + size);
    }

    public int allocate(int size) {
        int i = 0;
        while (true) {
            int start;
            int end;
            if ((end = this.used.nextSetBit(start = this.used.nextClearBit(i))) == -1 || end - start >= size) {
                this.allocate(start, size);
                return start;
            }
            i = end;
        }
    }

    public IntSet getUsed() {
        return (IntSet)this.used.stream().collect(IntArraySet::new, IntCollection::add, IntCollection::addAll);
    }
}

