/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.core.world.particle;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.momirealms.craftengine.core.block.BlockStateWrapper;
import net.momirealms.craftengine.core.item.Item;
import net.momirealms.craftengine.core.plugin.CraftEngine;
import net.momirealms.craftengine.core.plugin.context.number.NumberProviders;
import net.momirealms.craftengine.core.util.Color;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.LazyReference;
import net.momirealms.craftengine.core.util.ResourceConfigUtils;
import net.momirealms.craftengine.core.world.particle.BlockStateData;
import net.momirealms.craftengine.core.world.particle.ColorData;
import net.momirealms.craftengine.core.world.particle.DustData;
import net.momirealms.craftengine.core.world.particle.DustTransitionData;
import net.momirealms.craftengine.core.world.particle.ItemStackData;
import net.momirealms.craftengine.core.world.particle.JavaTypeData;
import net.momirealms.craftengine.core.world.particle.ParticleData;
import net.momirealms.craftengine.core.world.particle.ParticleTypes;
import net.momirealms.craftengine.core.world.particle.TrailData;
import net.momirealms.craftengine.core.world.particle.VibrationData;

public final class ParticleDataTypes {
    public static final Map<Key, Function<Map<String, Object>, ParticleData>> TYPES = new HashMap<Key, Function<Map<String, Object>, ParticleData>>();

    public static void registerParticleData(Function<Map<String, Object>, ParticleData> function, Key ... types) {
        for (Key type : types) {
            TYPES.put(type, function);
        }
    }

    static {
        ParticleDataTypes.registerParticleData(map -> new BlockStateData(LazyReference.lazyReference(new Supplier<BlockStateWrapper>(){
            final String blockState;
            {
                this.blockState = ResourceConfigUtils.requireNonEmptyStringOrThrow(map.get("block-state"), "warning.config.function.particle.missing_block_state");
            }

            @Override
            public BlockStateWrapper get() {
                return CraftEngine.instance().blockManager().createBlockState(this.blockState);
            }
        })), ParticleTypes.BLOCK, ParticleTypes.FALLING_DUST, ParticleTypes.DUST_PILLAR, ParticleTypes.BLOCK_CRUMBLE, ParticleTypes.BLOCK_MARKER);
        ParticleDataTypes.registerParticleData(map -> new ColorData(Color.fromStrings(ResourceConfigUtils.requireNonEmptyStringOrThrow(map.get("color"), "warning.config.function.particle.missing_color").split(","))), ParticleTypes.ENTITY_EFFECT, ParticleTypes.TINTED_LEAVES);
        ParticleDataTypes.registerParticleData(map -> new JavaTypeData(Float.valueOf(ResourceConfigUtils.getAsFloat(map.get("charge"), "charge"))), ParticleTypes.SCULK_CHARGE);
        ParticleDataTypes.registerParticleData(map -> new JavaTypeData(ResourceConfigUtils.getAsInt(map.get("shriek"), "shriek")), ParticleTypes.SHRIEK);
        ParticleDataTypes.registerParticleData(map -> new DustData(Color.fromStrings(ResourceConfigUtils.requireNonEmptyStringOrThrow(map.get("color"), "warning.config.function.particle.missing_color").split(",")), ResourceConfigUtils.getAsFloat(map.getOrDefault("scale", 1), "scale")), ParticleTypes.DUST);
        ParticleDataTypes.registerParticleData(map -> new DustTransitionData(Color.fromStrings(ResourceConfigUtils.requireNonEmptyStringOrThrow(map.get("from"), "warning.config.function.particle.missing_from").split(",")), Color.fromStrings(ResourceConfigUtils.requireNonEmptyStringOrThrow(map.get("to"), "warning.config.function.particle.missing_to").split(",")), ResourceConfigUtils.getAsFloat(map.getOrDefault("scale", 1), "scale")), ParticleTypes.DUST_COLOR_TRANSITION);
        ParticleDataTypes.registerParticleData(map -> new ItemStackData(LazyReference.lazyReference(new Supplier<Item<?>>((Map)map){
            final Key itemId;
            final /* synthetic */ Map val$map;
            {
                this.val$map = map;
                this.itemId = Key.of(ResourceConfigUtils.requireNonEmptyStringOrThrow(this.val$map.get("item"), "warning.config.function.particle.missing_item"));
            }

            @Override
            public Item<?> get() {
                return CraftEngine.instance().itemManager().createWrappedItem(this.itemId, null);
            }
        })), ParticleTypes.ITEM);
        ParticleDataTypes.registerParticleData(map -> new VibrationData(NumberProviders.fromObject(map.getOrDefault("target-x", 0)), NumberProviders.fromObject(map.getOrDefault("target-y", 0)), NumberProviders.fromObject(map.getOrDefault("target-z", 0)), NumberProviders.fromObject(map.getOrDefault("arrival-time", 10))), ParticleTypes.VIBRATION);
        ParticleDataTypes.registerParticleData(map -> new TrailData(NumberProviders.fromObject(map.getOrDefault("target-x", 0)), NumberProviders.fromObject(map.getOrDefault("target-y", 0)), NumberProviders.fromObject(map.getOrDefault("target-z", 0)), Color.fromStrings(ResourceConfigUtils.requireNonEmptyStringOrThrow(map.get("color"), "warning.config.function.particle.missing_color").split(",")), NumberProviders.fromObject(map.getOrDefault("duration", 10))), ParticleTypes.TRAIL);
    }
}

