/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.libraries.antigrieflib;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Level;
import net.momirealms.craftengine.libraries.antigrieflib.AntiGriefCompatibility;
import net.momirealms.craftengine.libraries.antigrieflib.AntiGriefException;
import net.momirealms.craftengine.libraries.antigrieflib.comp.BentoBoxCompatibility;
import net.momirealms.craftengine.libraries.antigrieflib.comp.CrashClaimCompatibility;
import net.momirealms.craftengine.libraries.antigrieflib.comp.DominionCompatibility;
import net.momirealms.craftengine.libraries.antigrieflib.comp.FabledSkyBlockCompatibility;
import net.momirealms.craftengine.libraries.antigrieflib.comp.FactionsUUIDCompatibility;
import net.momirealms.craftengine.libraries.antigrieflib.comp.GriefDefenderCompatibility;
import net.momirealms.craftengine.libraries.antigrieflib.comp.GriefPreventionCompatibility;
import net.momirealms.craftengine.libraries.antigrieflib.comp.HClaimsCompatibility;
import net.momirealms.craftengine.libraries.antigrieflib.comp.HuskClaimsCompatibility;
import net.momirealms.craftengine.libraries.antigrieflib.comp.HuskTownsCompatibility;
import net.momirealms.craftengine.libraries.antigrieflib.comp.IridiumSkyblockCompatibility;
import net.momirealms.craftengine.libraries.antigrieflib.comp.KingdomsCompatibility;
import net.momirealms.craftengine.libraries.antigrieflib.comp.LandlordCompatibility;
import net.momirealms.craftengine.libraries.antigrieflib.comp.LandsCompatibility;
import net.momirealms.craftengine.libraries.antigrieflib.comp.NoBuildPlusCompatibility;
import net.momirealms.craftengine.libraries.antigrieflib.comp.PlotSquaredV5Compatibility;
import net.momirealms.craftengine.libraries.antigrieflib.comp.PlotSquaredV6V7Compatibility;
import net.momirealms.craftengine.libraries.antigrieflib.comp.PreciousStonesCompatibility;
import net.momirealms.craftengine.libraries.antigrieflib.comp.RedProtectCompatibility;
import net.momirealms.craftengine.libraries.antigrieflib.comp.ResidenceCompatibility;
import net.momirealms.craftengine.libraries.antigrieflib.comp.SaberFactionsCompatibility;
import net.momirealms.craftengine.libraries.antigrieflib.comp.SuperiorSkyblockCompatibility;
import net.momirealms.craftengine.libraries.antigrieflib.comp.TownyCompatibility;
import net.momirealms.craftengine.libraries.antigrieflib.comp.USkyBlockCompatibility;
import net.momirealms.craftengine.libraries.antigrieflib.comp.UltimateClaimsCompatibility;
import net.momirealms.craftengine.libraries.antigrieflib.comp.UltimateClansCompatibility;
import net.momirealms.craftengine.libraries.antigrieflib.comp.WorldGuardCompatibility;
import net.momirealms.craftengine.libraries.antigrieflib.comp.XClaimCompatibility;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AntiGriefLib {
    private final JavaPlugin plugin;
    private final AntiGriefCompatibility[] providers;
    private final boolean ignoreOP;
    private final boolean silentLogs;
    private final boolean suppressErrors;
    private final String bypassPermission;

    private AntiGriefLib(JavaPlugin plugin, AntiGriefCompatibility[] providers, boolean ignoreOP, boolean silentLogs, boolean logErrors, String bypassPermission) {
        this.plugin = plugin;
        this.providers = providers;
        this.ignoreOP = ignoreOP;
        this.silentLogs = silentLogs;
        this.suppressErrors = logErrors;
        this.bypassPermission = bypassPermission;
    }

    @NotNull
    public AntiGriefCompatibility[] providers() {
        return this.providers;
    }

    @Nullable
    public String bypassPermission() {
        return this.bypassPermission;
    }

    @NotNull
    public JavaPlugin plugin() {
        return this.plugin;
    }

    public static Builder builder(JavaPlugin plugin) {
        return new Builder(plugin);
    }

    public boolean canPlace(Player player, Location location) {
        if (this.ignoreOP && player.isOp()) {
            return true;
        }
        if (this.bypassPermission != null && player.hasPermission(this.bypassPermission)) {
            return true;
        }
        try {
            for (AntiGriefCompatibility antiGrief : this.providers) {
                if (antiGrief.canPlace(player, location)) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            if (!this.suppressErrors) {
                throw new AntiGriefException(e);
            }
            return false;
        }
    }

    public boolean canBreak(Player player, Location location) {
        block5: {
            if (this.ignoreOP && player.isOp()) {
                return true;
            }
            if (this.bypassPermission != null && player.hasPermission(this.bypassPermission)) {
                return true;
            }
            try {
                for (AntiGriefCompatibility antiGrief : this.providers) {
                    if (antiGrief.canBreak(player, location)) continue;
                    return false;
                }
            }
            catch (Exception e) {
                if (this.suppressErrors) break block5;
                throw new AntiGriefException(e);
            }
        }
        return true;
    }

    public boolean canInteract(Player player, Location location) {
        if (this.ignoreOP && player.isOp()) {
            return true;
        }
        if (this.bypassPermission != null && player.hasPermission(this.bypassPermission)) {
            return true;
        }
        try {
            for (AntiGriefCompatibility antiGrief : this.providers) {
                if (antiGrief.canInteract(player, location)) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            if (!this.suppressErrors) {
                throw new AntiGriefException(e);
            }
            return false;
        }
    }

    public boolean canInteractEntity(Player player, Entity entity) {
        if (this.ignoreOP && player.isOp()) {
            return true;
        }
        if (this.bypassPermission != null && player.hasPermission(this.bypassPermission)) {
            return true;
        }
        try {
            for (AntiGriefCompatibility antiGrief : this.providers) {
                if (antiGrief.canInteractEntity(player, entity)) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            if (!this.suppressErrors) {
                throw new AntiGriefException(e);
            }
            return false;
        }
    }

    public boolean canDamage(Player player, Entity entity) {
        AntiGriefCompatibility[] another;
        if (entity instanceof Player && !(another = (AntiGriefCompatibility[])entity).getWorld().getPVP()) {
            return false;
        }
        if (this.ignoreOP && player.isOp()) {
            return true;
        }
        if (this.bypassPermission != null && player.hasPermission(this.bypassPermission)) {
            return true;
        }
        try {
            for (AntiGriefCompatibility antiGrief : this.providers) {
                if (antiGrief.canDamage(player, entity)) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            if (!this.suppressErrors) {
                throw new AntiGriefException(e);
            }
            return false;
        }
    }

    public static class Builder {
        private final Map<String, AntiGriefCompatibility> byId = new HashMap<String, AntiGriefCompatibility>();
        private final JavaPlugin plugin;
        private boolean ignoreOP = false;
        private boolean silentLogs = false;
        private boolean suppressErrors = false;
        private String bypassPermission = null;
        private Predicate<Plugin> exclude = p -> false;

        public Builder(JavaPlugin plugin) {
            this.plugin = plugin;
        }

        public Builder ignoreOP(boolean ignoreOP) {
            this.ignoreOP = ignoreOP;
            return this;
        }

        public Builder bypassPermission(String bypassPermission) {
            this.bypassPermission = bypassPermission;
            return this;
        }

        public Builder silentLogs(boolean silent) {
            this.silentLogs = silent;
            return this;
        }

        public Builder suppressErrors(boolean suppress) {
            this.suppressErrors = suppress;
            return this;
        }

        public Builder exclude(@NotNull Predicate<Plugin> exclude) {
            this.exclude = exclude;
            return this;
        }

        public Builder register(@NotNull AntiGriefCompatibility antiGrief) {
            AntiGriefCompatibility previous = this.byId.get(antiGrief.id());
            if (previous != null && previous != antiGrief) {
                throw new IllegalStateException("AntiGriefCompatibility '" + antiGrief.id() + "' has already been registered");
            }
            antiGrief.init();
            this.byId.put(antiGrief.id(), antiGrief);
            this.logHookInternal(antiGrief);
            return this;
        }

        @Nullable
        public AntiGriefCompatibility removeById(String id) {
            return this.byId.remove(id);
        }

        public AntiGriefLib build() {
            this.detectSupportedPlugins(s -> {
                block2: {
                    try {
                        AntiGriefCompatibility compatibility = (AntiGriefCompatibility)s.get();
                        this.register(compatibility);
                    }
                    catch (Throwable t) {
                        if (this.suppressErrors) break block2;
                        this.plugin.getLogger().log(Level.SEVERE, "Please report this error on https://github.com/Xiao-MoMi/AntiGriefLib/issues", t);
                    }
                }
            });
            return new AntiGriefLib(this.plugin, this.byId.values().toArray(new AntiGriefCompatibility[0]), this.ignoreOP, this.silentLogs, this.suppressErrors, this.bypassPermission);
        }

        private boolean isIncluded(Plugin plugin) {
            return !this.exclude.test(plugin);
        }

        private void logHookInternal(AntiGriefCompatibility plugin) {
            if (this.silentLogs) {
                return;
            }
            this.plugin.getLogger().info("[AntiGriefLib] Enabled " + plugin.plugin().getName() + " compatibility.");
        }

        private Optional<Plugin> getOptionalPlugin(String name) {
            return Optional.ofNullable(Bukkit.getPluginManager().getPlugin(name)).filter(this::isIncluded);
        }

        private boolean classExists(@NotNull String clazz) {
            try {
                Class.forName(clazz.replace("{}", "."));
                return true;
            }
            catch (Throwable e) {
                return false;
            }
        }

        private void detectSupportedPlugins(Consumer<Supplier<AntiGriefCompatibility>> consumer) {
            this.getOptionalPlugin("WorldGuard").ifPresent(plugin -> {
                if (this.classExists("com{}sk89q{}worldguard{}WorldGuard")) {
                    consumer.accept(() -> new WorldGuardCompatibility((Plugin)plugin));
                }
            });
            this.getOptionalPlugin("Kingdoms").ifPresent(plugin -> {
                if (this.classExists("org{}kingdoms{}constants{}land{}Land")) {
                    consumer.accept(() -> new KingdomsCompatibility((Plugin)plugin));
                }
            });
            this.getOptionalPlugin("Lands").ifPresent(plugin -> {
                if (this.classExists("me{}angeschossen{}lands{}api{}LandsIntegration")) {
                    consumer.accept(() -> new LandsCompatibility((Plugin)plugin, this.plugin));
                }
            });
            this.getOptionalPlugin("IridiumSkyblock").ifPresent(plugin -> {
                if (this.classExists("com{}iridium{}iridiumskyblock{}api{}IridiumSkyblockAPI") && plugin.getDescription().getVersion().startsWith("4")) {
                    consumer.accept(() -> new IridiumSkyblockCompatibility((Plugin)plugin));
                }
            });
            this.getOptionalPlugin("CrashClaim").ifPresent(plugin -> {
                if (this.classExists("net{}crashcraft{}crashclaim{}CrashClaim")) {
                    consumer.accept(() -> new CrashClaimCompatibility((Plugin)plugin));
                }
            });
            this.getOptionalPlugin("GriefDefender").ifPresent(plugin -> {
                if (this.classExists("com{}griefdefender{}api{}GriefDefender")) {
                    consumer.accept(() -> new GriefDefenderCompatibility((Plugin)plugin));
                }
            });
            this.getOptionalPlugin("HuskClaims").ifPresent(plugin -> {
                if (this.classExists("net{}william278{}huskclaims{}api{}BukkitHuskClaimsAPI")) {
                    consumer.accept(() -> new HuskClaimsCompatibility((Plugin)plugin));
                }
            });
            this.getOptionalPlugin("BentoBox").ifPresent(plugin -> {
                if (this.classExists("world{}bentobox{}bentobox{}BentoBox")) {
                    consumer.accept(() -> new BentoBoxCompatibility((Plugin)plugin));
                }
            });
            this.getOptionalPlugin("HuskTowns").ifPresent(plugin -> {
                if (this.classExists("net{}william278{}husktowns{}api{}BukkitHuskTownsAPI")) {
                    consumer.accept(() -> new HuskTownsCompatibility((Plugin)plugin));
                }
            });
            this.getOptionalPlugin("PlotSquared").ifPresent(plugin -> {
                if (this.classExists("com{}plotsquared{}bukkit{}util{}BukkitUtil")) {
                    switch (plugin.getDescription().getVersion().charAt(0)) {
                        case '5': {
                            consumer.accept(() -> new PlotSquaredV5Compatibility((Plugin)plugin));
                            break;
                        }
                        case '6': 
                        case '7': {
                            consumer.accept(() -> new PlotSquaredV6V7Compatibility((Plugin)plugin));
                        }
                    }
                }
            });
            this.getOptionalPlugin("Residence").ifPresent(plugin -> {
                if (this.classExists("com{}bekvon{}bukkit{}residence{}Residence")) {
                    consumer.accept(() -> new ResidenceCompatibility((Plugin)plugin));
                }
            });
            this.getOptionalPlugin("SuperiorSkyblock2").ifPresent(plugin -> {
                if (this.classExists("com{}bgsoftware{}superiorskyblock{}SuperiorSkyblockPlugin")) {
                    consumer.accept(() -> new SuperiorSkyblockCompatibility((Plugin)plugin));
                }
            });
            this.getOptionalPlugin("Towny").ifPresent(plugin -> {
                if (this.classExists("com{}palmergames{}bukkit{}towny{}TownyAPI")) {
                    consumer.accept(() -> new TownyCompatibility((Plugin)plugin));
                }
            });
            this.getOptionalPlugin("FabledSkyBlock").ifPresent(plugin -> {
                if (this.classExists("com{}craftaro{}skyblock{}api{}SkyBlockAPI")) {
                    consumer.accept(() -> new FabledSkyBlockCompatibility((Plugin)plugin));
                }
            });
            this.getOptionalPlugin("GriefPrevention").ifPresent(plugin -> {
                if (this.classExists("me{}ryanhamshire{}GriefPrevention{}Claim")) {
                    consumer.accept(() -> new GriefPreventionCompatibility((Plugin)plugin));
                }
            });
            this.getOptionalPlugin("RedProtect").ifPresent(plugin -> {
                if (this.classExists("br{}net{}fabiozumbi12{}RedProtect{}Bukkit{}API{}RedProtectAPI")) {
                    consumer.accept(() -> new RedProtectCompatibility((Plugin)plugin));
                }
            });
            this.getOptionalPlugin("Landlord").ifPresent(plugin -> {
                if (this.classExists("biz{}princeps{}landlord{}api{}ILandLord")) {
                    consumer.accept(() -> new LandlordCompatibility((Plugin)plugin));
                }
            });
            this.getOptionalPlugin("uSkyBlock").ifPresent(plugin -> {
                if (this.classExists("us{}talabrek{}ultimateskyblock{}api{}uSkyBlockAPI")) {
                    consumer.accept(() -> new USkyBlockCompatibility((Plugin)plugin));
                }
            });
            this.getOptionalPlugin("XClaim").ifPresent(plugin -> {
                if (this.classExists("codes{}wasabi{}xclaim{}api{}Claim")) {
                    consumer.accept(() -> new XClaimCompatibility((Plugin)plugin));
                }
            });
            this.getOptionalPlugin("UltimateClaims").ifPresent(plugin -> {
                if (this.classExists("com{}craftaro{}ultimateclaims{}UltimateClaims")) {
                    consumer.accept(() -> new UltimateClaimsCompatibility((Plugin)plugin));
                }
            });
            this.getOptionalPlugin("UltimateClans").ifPresent(plugin -> {
                if (this.classExists("me{}ulrich{}clans{}Clans")) {
                    consumer.accept(() -> new UltimateClansCompatibility((Plugin)plugin));
                }
            });
            this.getOptionalPlugin("PreciousStones").ifPresent(plugin -> {
                if (this.classExists("net{}sacredlabyrinth{}Phaed{}PreciousStones{}api{}Api")) {
                    consumer.accept(() -> new PreciousStonesCompatibility((Plugin)plugin));
                }
            });
            this.getOptionalPlugin("hClaims").ifPresent(plugin -> {
                if (this.classExists("com{}hakan{}claim{}shadow{}com{}hakan{}spinjection{}SpigotBootstrap")) {
                    consumer.accept(() -> new HClaimsCompatibility((Plugin)plugin));
                }
            });
            this.getOptionalPlugin("Dominion").ifPresent(plugin -> {
                if (this.classExists("cn{}lunadeer{}dominion{}api{}DominionAPI")) {
                    consumer.accept(() -> new DominionCompatibility((Plugin)plugin));
                }
            });
            this.getOptionalPlugin("Factions").ifPresent(plugin -> {
                if (this.classExists("com{}massivecraft{}factions{}zcore{}fperms{}PermissableAction")) {
                    consumer.accept(() -> new SaberFactionsCompatibility((Plugin)plugin));
                }
                if (this.classExists("com{}massivecraft{}factions{}perms{}PermissibleActions")) {
                    consumer.accept(() -> new FactionsUUIDCompatibility((Plugin)plugin));
                }
            });
            this.getOptionalPlugin("NoBuildPlus").ifPresent(plugin -> {
                if (this.classExists("p1xel{}nobuildplus{}NoBuildPlus")) {
                    consumer.accept(() -> new NoBuildPlusCompatibility((Plugin)plugin));
                }
            });
        }
    }
}

