/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.libraries.antigrieflib.comp;

import com.craftaro.skyblock.api.SkyBlockAPI;
import com.craftaro.skyblock.api.island.IslandRole;
import java.util.Optional;
import net.momirealms.craftengine.libraries.antigrieflib.AbstractAntiGriefCompatibility;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class FabledSkyBlockCompatibility
extends AbstractAntiGriefCompatibility {
    public FabledSkyBlockCompatibility(Plugin plugin) {
        super(plugin);
    }

    @Override
    public void init() {
    }

    @Override
    public boolean canPlace(Player player, Location location) {
        return this.isIslandMember(player, location);
    }

    @Override
    public boolean canBreak(Player player, Location location) {
        return this.isIslandMember(player, location);
    }

    @Override
    public boolean canInteract(Player player, Location location) {
        return this.isIslandMember(player, location);
    }

    @Override
    public boolean canInteractEntity(Player player, Entity entity) {
        return this.isIslandMember(player, entity.getLocation());
    }

    @Override
    public boolean canDamage(Player player, Entity entity) {
        return this.isIslandMember(player, entity.getLocation());
    }

    private boolean isIslandMember(Player player, Location location) {
        return Optional.ofNullable(SkyBlockAPI.getIslandManager().getIslandAtLocation(location)).map(island -> {
            if (island.isCoopPlayer((OfflinePlayer)player)) {
                return true;
            }
            return Optional.ofNullable(island.getRole((OfflinePlayer)player)).map(islandRole -> islandRole != IslandRole.VISITOR).orElse(false);
        }).orElse(true);
    }
}

