/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.libraries.antigrieflib.comp;

import com.iridium.iridiumskyblock.api.IridiumSkyblockAPI;
import com.iridium.iridiumteams.PermissionType;
import net.momirealms.craftengine.libraries.antigrieflib.AbstractAntiGriefCompatibility;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class IridiumSkyblockCompatibility
extends AbstractAntiGriefCompatibility {
    private IridiumSkyblockAPI api;

    public IridiumSkyblockCompatibility(Plugin plugin) {
        super(plugin);
    }

    @Override
    public void init() {
        this.api = IridiumSkyblockAPI.getInstance();
    }

    @Override
    public boolean canPlace(Player player, Location location) {
        return this.api.getIslandViaLocation(location).map(island -> this.api.getIslandPermission(island, this.api.getUser((OfflinePlayer)player), PermissionType.BLOCK_PLACE)).orElse(true);
    }

    @Override
    public boolean canBreak(Player player, Location location) {
        return this.api.getIslandViaLocation(location).map(island -> this.api.getIslandPermission(island, this.api.getUser((OfflinePlayer)player), PermissionType.BLOCK_BREAK)).orElse(true);
    }

    @Override
    public boolean canInteract(Player player, Location location) {
        return this.api.getIslandViaLocation(location).map(island -> this.api.getIslandPermission(island, this.api.getUser((OfflinePlayer)player), PermissionType.OPEN_CONTAINERS)).orElse(true);
    }

    @Override
    public boolean canInteractEntity(Player player, Entity entity) {
        return this.api.getIslandViaLocation(entity.getLocation()).map(island -> this.api.getIslandPermission(island, this.api.getUser((OfflinePlayer)player), PermissionType.OPEN_CONTAINERS)).orElse(true);
    }

    @Override
    public boolean canDamage(Player player, Entity entity) {
        return this.api.getIslandViaLocation(entity.getLocation()).map(island -> this.api.getIslandPermission(island, this.api.getUser((OfflinePlayer)player), PermissionType.KILL_MOBS)).orElse(true);
    }
}

