/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.libraries.antigrieflib.comp;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.bukkit.util.Entities;
import com.sk89q.worldguard.protection.flags.Flags;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import net.momirealms.craftengine.libraries.antigrieflib.AbstractAntiGriefCompatibility;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class WorldGuardCompatibility
extends AbstractAntiGriefCompatibility {
    private StateFlag PLACE_FLAG;
    private StateFlag BREAK_FLAG;
    private StateFlag INTERACT_FLAG;
    private RegionContainer container;

    public WorldGuardCompatibility(Plugin plugin) {
        super(plugin);
    }

    public void setPlaceFlag(StateFlag PLACE_FLAG) {
        this.PLACE_FLAG = PLACE_FLAG;
    }

    public void setBreakFlag(StateFlag BREAK_FLAG) {
        this.BREAK_FLAG = BREAK_FLAG;
    }

    public void setInteractFlag(StateFlag INTERACT_FLAG) {
        this.INTERACT_FLAG = INTERACT_FLAG;
    }

    @Override
    public void init() {
        this.container = WorldGuard.getInstance().getPlatform().getRegionContainer();
    }

    @Override
    public boolean canPlace(Player player, Location location) {
        return this.container.createQuery().testBuild(BukkitAdapter.adapt((Location)location), WorldGuardPlugin.inst().wrapPlayer(player), new StateFlag[]{this.PLACE_FLAG == null ? Flags.BLOCK_PLACE : this.PLACE_FLAG});
    }

    @Override
    public boolean canBreak(Player player, Location location) {
        return this.container.createQuery().testBuild(BukkitAdapter.adapt((Location)location), WorldGuardPlugin.inst().wrapPlayer(player), new StateFlag[]{this.BREAK_FLAG == null ? Flags.BLOCK_BREAK : this.BREAK_FLAG});
    }

    @Override
    public boolean canInteract(Player player, Location location) {
        return this.container.createQuery().testBuild(BukkitAdapter.adapt((Location)location), WorldGuardPlugin.inst().wrapPlayer(player), new StateFlag[]{this.INTERACT_FLAG == null ? Flags.INTERACT : this.INTERACT_FLAG});
    }

    @Override
    public boolean canInteractEntity(Player player, Entity entity) {
        return this.container.createQuery().testBuild(BukkitAdapter.adapt((Location)entity.getLocation()), WorldGuardPlugin.inst().wrapPlayer(player), new StateFlag[]{Flags.INTERACT});
    }

    @Override
    public boolean canDamage(Player player, Entity entity) {
        StateFlag flag = Entities.isHostile((Entity)entity) ? Flags.MOB_DAMAGE : (Entities.isNonHostile((Entity)entity) ? Flags.DAMAGE_ANIMALS : Flags.INTERACT);
        return this.container.createQuery().testBuild(BukkitAdapter.adapt((Location)entity.getLocation()), WorldGuardPlugin.inst().wrapPlayer(player), new StateFlag[]{entity instanceof Player ? Flags.PVP : flag});
    }
}

