/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.libraries.concurrentutil.lock;

import java.util.Objects;
import java.util.concurrent.locks.LockSupport;
import net.momirealms.craftengine.libraries.concurrentutil.collection.MultiThreadedQueue;
import net.momirealms.craftengine.libraries.concurrentutil.map.ConcurrentLong2ReferenceChainedHashTable;
import net.momirealms.craftengine.libraries.concurrentutil.util.IntPairUtil;

public final class ReentrantAreaLock {
    public final int coordinateShift;
    private final ConcurrentLong2ReferenceChainedHashTable<Node> nodes = ConcurrentLong2ReferenceChainedHashTable.createWithCapacity(128, 0.2f);

    public ReentrantAreaLock(int coordinateShift) {
        this.coordinateShift = coordinateShift;
    }

    public boolean isHeldByCurrentThread(int x, int z) {
        Thread currThread = Thread.currentThread();
        int shift = this.coordinateShift;
        int sectionX = x >> shift;
        int sectionZ = z >> shift;
        long coordinate = IntPairUtil.key(sectionX, sectionZ);
        Node node = this.nodes.get(coordinate);
        return node != null && node.thread == currThread;
    }

    public boolean isHeldByCurrentThread(int centerX, int centerZ, int radius) {
        return this.isHeldByCurrentThread(centerX - radius, centerZ - radius, centerX + radius, centerZ + radius);
    }

    public boolean isHeldByCurrentThread(int fromX, int fromZ, int toX, int toZ) {
        if (fromX > toX || fromZ > toZ) {
            throw new IllegalArgumentException();
        }
        Thread currThread = Thread.currentThread();
        int shift = this.coordinateShift;
        int fromSectionX = fromX >> shift;
        int fromSectionZ = fromZ >> shift;
        int toSectionX = toX >> shift;
        int toSectionZ = toZ >> shift;
        for (int currZ = fromSectionZ; currZ <= toSectionZ; ++currZ) {
            for (int currX = fromSectionX; currX <= toSectionX; ++currX) {
                long coordinate = IntPairUtil.key(currX, currZ);
                Node node = this.nodes.get(coordinate);
                if (node != null && node.thread == currThread) continue;
                return false;
            }
        }
        return true;
    }

    public Node tryLock(int x, int z) {
        return this.tryLock(x, z, x, z);
    }

    public Node tryLock(int centerX, int centerZ, int radius) {
        return this.tryLock(centerX - radius, centerZ - radius, centerX + radius, centerZ + radius);
    }

    public Node tryLock(int fromX, int fromZ, int toX, int toZ) {
        if (fromX > toX || fromZ > toZ) {
            throw new IllegalArgumentException();
        }
        Thread currThread = Thread.currentThread();
        int shift = this.coordinateShift;
        int fromSectionX = fromX >> shift;
        int fromSectionZ = fromZ >> shift;
        int toSectionX = toX >> shift;
        int toSectionZ = toZ >> shift;
        long[] areaAffected = new long[(toSectionX - fromSectionX + 1) * (toSectionZ - fromSectionZ + 1)];
        int areaAffectedLen = 0;
        Node ret = new Node(this, areaAffected, currThread);
        boolean failed = false;
        block0: for (int currZ = fromSectionZ; currZ <= toSectionZ; ++currZ) {
            for (int currX = fromSectionX; currX <= toSectionX; ++currX) {
                long coordinate = IntPairUtil.key(currX, currZ);
                Node prev = this.nodes.putIfAbsent(coordinate, ret);
                if (prev == null) {
                    areaAffected[areaAffectedLen++] = coordinate;
                    continue;
                }
                if (prev.thread == currThread) continue;
                failed = true;
                continue block0;
            }
        }
        if (!failed) {
            return ret;
        }
        if (areaAffectedLen != 0) {
            Thread unpark;
            for (int i = 0; i < areaAffectedLen; ++i) {
                long key = areaAffected[i];
                if (this.nodes.remove(key) == ret) continue;
                throw new IllegalStateException();
            }
            areaAffectedLen = 0;
            while ((unpark = (Thread)ret.pollOrBlockAdds()) != null) {
                LockSupport.unpark(unpark);
            }
        }
        return null;
    }

    public Node lock(int x, int z) {
        Thread currThread = Thread.currentThread();
        int shift = this.coordinateShift;
        int sectionX = x >> shift;
        int sectionZ = z >> shift;
        long coordinate = IntPairUtil.key(sectionX, sectionZ);
        long[] areaAffected = new long[]{coordinate};
        Node ret = new Node(this, areaAffected, currThread);
        long failures = 0L;
        while (true) {
            Node prev;
            if ((prev = this.nodes.putIfAbsent(coordinate, ret)) == null) {
                ret.areaAffectedLen = 1;
                return ret;
            }
            if (prev.thread == currThread) {
                return ret;
            }
            Node park = prev;
            if (++failures > 128L && park.add(currThread)) {
                LockSupport.park();
                continue;
            }
            if (failures < 128L) {
                for (long i = 0L; i < failures; ++i) {
                    Thread.onSpinWait();
                }
                failures <<= 1;
                continue;
            }
            if (failures < 1200L) {
                LockSupport.parkNanos(1000L);
                ++failures;
                continue;
            }
            Thread.yield();
            LockSupport.parkNanos(100000L * failures);
            ++failures;
        }
    }

    public Node lock(int centerX, int centerZ, int radius) {
        return this.lock(centerX - radius, centerZ - radius, centerX + radius, centerZ + radius);
    }

    public Node lock(int fromX, int fromZ, int toX, int toZ) {
        if (fromX > toX || fromZ > toZ) {
            throw new IllegalArgumentException();
        }
        Thread currThread = Thread.currentThread();
        int shift = this.coordinateShift;
        int fromSectionX = fromX >> shift;
        int toSectionX = toX >> shift;
        int fromSectionZ = fromZ >> shift;
        int toSectionZ = toZ >> shift;
        if ((fromSectionX ^ toSectionX | fromSectionZ ^ toSectionZ) == 0) {
            return this.lock(fromX, fromZ);
        }
        long[] areaAffected = new long[(toSectionX - fromSectionX + 1) * (toSectionZ - fromSectionZ + 1)];
        int areaAffectedLen = 0;
        Node ret = new Node(this, areaAffected, currThread);
        long failures = 0L;
        while (true) {
            MultiThreadedQueue park = null;
            boolean addedToArea = false;
            boolean alreadyOwned = false;
            boolean allOwned = true;
            block1: for (int currZ = fromSectionZ; currZ <= toSectionZ; ++currZ) {
                for (int currX = fromSectionX; currX <= toSectionX; ++currX) {
                    long coordinate = IntPairUtil.key(currX, currZ);
                    Node prev = this.nodes.putIfAbsent(coordinate, ret);
                    if (prev == null) {
                        addedToArea = true;
                        allOwned = false;
                        areaAffected[areaAffectedLen++] = coordinate;
                        continue;
                    }
                    if (prev.thread == currThread) continue;
                    park = prev;
                    alreadyOwned = true;
                    continue block1;
                }
            }
            if (park != null && addedToArea || park == null && alreadyOwned && !allOwned) {
                Thread unpark;
                for (int i = 0; i < areaAffectedLen; ++i) {
                    long key = areaAffected[i];
                    if (this.nodes.remove(key) == ret) continue;
                    throw new IllegalStateException();
                }
                areaAffectedLen = 0;
                while ((unpark = (Thread)ret.pollOrBlockAdds()) != null) {
                    LockSupport.unpark(unpark);
                }
            }
            if (park == null) {
                if (alreadyOwned && !allOwned) {
                    throw new IllegalStateException("Improper lock usage: Should never acquire intersecting areas");
                }
                ret.areaAffectedLen = areaAffectedLen;
                return ret;
            }
            if (++failures > 128L && park.add(currThread)) {
                LockSupport.park(park);
            } else if (failures < 128L) {
                for (long i = 0L; i < failures; ++i) {
                    Thread.onSpinWait();
                }
                failures <<= 1;
            } else if (failures < 1200L) {
                LockSupport.parkNanos(1000L);
                ++failures;
            } else {
                Thread.yield();
                LockSupport.parkNanos(100000L * failures);
                ++failures;
            }
            if (!addedToArea) continue;
            ret.allowAdds();
        }
    }

    public void unlock(Node node) {
        Thread unpark;
        if (node.lock != this) {
            throw new IllegalStateException("Unlock target lock mismatch");
        }
        long[] areaAffected = node.areaAffected;
        int areaAffectedLen = node.areaAffectedLen;
        if (areaAffectedLen == 0) {
            return;
        }
        Objects.checkFromToIndex(0, areaAffectedLen, areaAffected.length);
        for (int i = 0; i < areaAffectedLen; ++i) {
            long coordinate = areaAffected[i];
            if (this.nodes.remove(coordinate, node) == node) continue;
            throw new IllegalStateException();
        }
        while ((unpark = (Thread)node.pollOrBlockAdds()) != null) {
            LockSupport.unpark(unpark);
        }
    }

    public static final class Node
    extends MultiThreadedQueue<Thread> {
        private final ReentrantAreaLock lock;
        private final long[] areaAffected;
        private int areaAffectedLen;
        private final Thread thread;

        private Node(ReentrantAreaLock lock, long[] areaAffected, Thread thread) {
            this.lock = lock;
            this.areaAffected = areaAffected;
            this.thread = thread;
        }

        @Override
        public String toString() {
            return "Node{areaAffected=" + IntPairUtil.toString(this.areaAffected, 0, this.areaAffectedLen) + ", thread=" + String.valueOf(this.thread) + "}";
        }
    }
}

