/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.libraries.nbt;

import java.io.DataOutput;
import java.io.IOException;
import net.momirealms.craftengine.libraries.nbt.NumericTag;
import net.momirealms.craftengine.libraries.nbt.TagType;
import net.momirealms.craftengine.libraries.nbt.TagTypes;
import net.momirealms.craftengine.libraries.nbt.TagVisitor;
import net.momirealms.craftengine.libraries.nbt.util.MathUtil;

public class FloatTag
extends NumericTag {
    private final float value;

    public FloatTag(float value) {
        this.value = value;
    }

    @Override
    public void write(DataOutput output) throws IOException {
        output.writeFloat(this.value);
    }

    @Override
    public byte getId() {
        return 5;
    }

    @Override
    public TagType<?> getType() {
        return TagTypes.FLOAT;
    }

    @Override
    public FloatTag deepClone() {
        return new FloatTag(this.value);
    }

    @Override
    public FloatTag copy() {
        return this;
    }

    @Override
    public void accept(TagVisitor visitor) {
        visitor.visitFloat(this);
    }

    @Override
    public long getAsLong() {
        return (long)this.value;
    }

    @Override
    public int getAsInt() {
        return MathUtil.fastFloor(this.value);
    }

    @Override
    public short getAsShort() {
        return (short)(MathUtil.fastFloor(this.value) & 0xFFFF);
    }

    @Override
    public byte getAsByte() {
        return (byte)(MathUtil.fastFloor(this.value) & 0xFF);
    }

    @Override
    public double getAsDouble() {
        return this.value;
    }

    @Override
    public float getAsFloat() {
        return this.value;
    }

    @Override
    public Number getAsNumber() {
        return Float.valueOf(this.value);
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FloatTag)) {
            return false;
        }
        FloatTag floatTag = (FloatTag)o;
        return Float.compare(this.value, floatTag.value) == 0;
    }

    public int hashCode() {
        return Float.hashCode(this.value);
    }
}

