/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.libraries.nbt;

import java.io.DataOutput;
import java.io.IOException;
import net.momirealms.craftengine.libraries.nbt.TagType;
import net.momirealms.craftengine.libraries.nbt.TagVisitor;
import net.momirealms.craftengine.libraries.nbt.visitor.CompactStringTagVisitor;

public interface Tag {
    public static final byte TAG_END_ID = 0;
    public static final byte TAG_BYTE_ID = 1;
    public static final byte TAG_SHORT_ID = 2;
    public static final byte TAG_INT_ID = 3;
    public static final byte TAG_LONG_ID = 4;
    public static final byte TAG_FLOAT_ID = 5;
    public static final byte TAG_DOUBLE_ID = 6;
    public static final byte TAG_BYTE_ARRAY_ID = 7;
    public static final byte TAG_STRING_ID = 8;
    public static final byte TAG_LIST_ID = 9;
    public static final byte TAG_COMPOUND_ID = 10;
    public static final byte TAG_INT_ARRAY_ID = 11;
    public static final byte TAG_LONG_ARRAY_ID = 12;
    public static final byte TAG_ANY_NUMERIC_ID = 99;

    public void write(DataOutput var1) throws IOException;

    public String toString();

    public byte getId();

    public TagType<?> getType();

    public Tag copy();

    public Tag deepClone();

    default public String getAsString() {
        return new CompactStringTagVisitor().visit(this);
    }

    public void accept(TagVisitor var1);

    default public boolean isTypeOf(int type) {
        byte i = this.getId();
        if (i == type) {
            return true;
        }
        if (type != 99) {
            return false;
        }
        return Tag.isNumericTag(i);
    }

    public static boolean isNumericTag(int tagType) {
        return switch (tagType) {
            case 1, 2, 3, 4, 5, 6 -> true;
            default -> false;
        };
    }
}

