/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.libraries.nbt.adventure;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import net.momirealms.craftengine.libraries.adventure.key.Key;
import net.momirealms.craftengine.libraries.adventure.text.BlockNBTComponent;
import net.momirealms.craftengine.libraries.adventure.text.Component;
import net.momirealms.craftengine.libraries.adventure.text.ComponentLike;
import net.momirealms.craftengine.libraries.adventure.text.EntityNBTComponent;
import net.momirealms.craftengine.libraries.adventure.text.KeybindComponent;
import net.momirealms.craftengine.libraries.adventure.text.NBTComponent;
import net.momirealms.craftengine.libraries.adventure.text.ScoreComponent;
import net.momirealms.craftengine.libraries.adventure.text.SelectorComponent;
import net.momirealms.craftengine.libraries.adventure.text.StorageNBTComponent;
import net.momirealms.craftengine.libraries.adventure.text.TextComponent;
import net.momirealms.craftengine.libraries.adventure.text.TranslatableComponent;
import net.momirealms.craftengine.libraries.adventure.text.TranslationArgument;
import net.momirealms.craftengine.libraries.adventure.text.format.Style;
import net.momirealms.craftengine.libraries.adventure.util.Services;
import net.momirealms.craftengine.libraries.nbt.CompoundTag;
import net.momirealms.craftengine.libraries.nbt.ListTag;
import net.momirealms.craftengine.libraries.nbt.StringTag;
import net.momirealms.craftengine.libraries.nbt.Tag;
import net.momirealms.craftengine.libraries.nbt.adventure.NBTComponentSerializer;
import net.momirealms.craftengine.libraries.nbt.adventure.NBTSerializerOptions;
import net.momirealms.craftengine.libraries.nbt.adventure.NBTStyleSerializer;
import net.momirealms.craftengine.libraries.option.OptionState;
import org.jetbrains.annotations.NotNull;

class NBTComponentSerializerImpl
implements NBTComponentSerializer {
    private static final Optional<NBTComponentSerializer.Provider> SERVICE = Services.service(NBTComponentSerializer.Provider.class);
    private static final Consumer<NBTComponentSerializer.Builder> BUILDER = SERVICE.map(NBTComponentSerializer.Provider::builder).orElse(builder -> {});
    private static final String TYPE = "type";
    private static final String TYPE_TEXT = "text";
    private static final String TYPE_TRANSLATABLE = "translatable";
    private static final String TYPE_KEYBIND = "keybind";
    private static final String TYPE_SCORE = "score";
    private static final String TYPE_SELECTOR = "selector";
    private static final String TYPE_NBT = "nbt";
    private static final String EXTRA = "extra";
    private static final String TEXT = "text";
    private static final String TRANSLATE_KEY = "translate";
    private static final String TRANSLATE_WITH = "with";
    private static final String TRANSLATE_FALLBACK = "fallback";
    private static final String KEYBIND = "keybind";
    private static final String SCORE = "score";
    private static final String SCORE_NAME = "name";
    private static final String SCORE_OBJECTIVE = "objective";
    private static final String SELECTOR = "selector";
    private static final String SELECTOR_SEPARATOR = "separator";
    private static final String NBT_SOURCE = "source";
    private static final String NBT = "nbt";
    private static final String NBT_INTERPRET = "interpret";
    private static final String NBT_SEPARATOR = "separator";
    private static final String NBT_BLOCK = "block";
    private static final String NBT_ENTITY = "entity";
    private static final String NBT_STORAGE = "storage";
    private final OptionState flags;
    public final boolean modernHoverEvent;
    public final boolean modernClickEvent;
    public final boolean componentRelease;

    @Override
    @NotNull
    public Style deserializeStyle(@NotNull CompoundTag tag) {
        return NBTStyleSerializer.deserialize(tag, this);
    }

    @Override
    @NotNull
    public CompoundTag serializeStyle(@NotNull Style style) {
        CompoundTag builder = new CompoundTag();
        NBTStyleSerializer.serialize(style, builder, this);
        return builder;
    }

    NBTComponentSerializerImpl(@NotNull OptionState flags) {
        this.flags = flags;
        this.modernClickEvent = (Boolean)flags.value(NBTSerializerOptions.EMIT_CLICK_EVENT_TYPE);
        this.modernHoverEvent = (Boolean)flags.value(NBTSerializerOptions.EMIT_HOVER_EVENT_TYPE);
        this.componentRelease = (Boolean)flags.value(NBTSerializerOptions.DATA_COMPONENT_RELEASE);
    }

    @NotNull
    public Component deserialize(@NotNull Tag input) {
        if (!(input instanceof CompoundTag)) {
            return Component.text((String)input.getAsString());
        }
        CompoundTag compound = (CompoundTag)input;
        String type = compound.getString(TYPE);
        if (type == null) {
            if (compound.containsKey("text")) {
                type = "text";
            } else if (compound.containsKey(TRANSLATE_KEY)) {
                type = TYPE_TRANSLATABLE;
            } else if (compound.containsKey("keybind")) {
                type = "keybind";
            } else if (compound.containsKey("score")) {
                type = "score";
            } else if (compound.containsKey("selector")) {
                type = "selector";
            } else if (compound.containsKey("nbt") && (compound.containsKey(NBT_SOURCE) || compound.containsKey(NBT_BLOCK) || compound.containsKey(NBT_STORAGE) || compound.containsKey(NBT_ENTITY))) {
                type = "nbt";
            } else {
                throw new IllegalArgumentException("Could not infer the type of the component");
            }
        }
        Style style = NBTStyleSerializer.deserialize(compound, this);
        ArrayList children = new ArrayList();
        ListTag binaryChildren = compound.getList(EXTRA);
        if (binaryChildren != null) {
            binaryChildren.forEach(child -> children.add(this.deserialize((Tag)child)));
        }
        switch (type) {
            case "text": {
                return ((TextComponent.Builder)((TextComponent.Builder)Component.text().content(compound.getString("text")).style(style)).append(children)).build();
            }
            case "translatable": {
                ListTag binaryArguments = compound.getList(TRANSLATE_WITH);
                String fallback = compound.getString(TRANSLATE_FALLBACK);
                ArrayList<Component> arguments = new ArrayList<Component>();
                if (binaryArguments != null) {
                    for (Tag argument : binaryArguments) {
                        arguments.add(this.deserialize(argument));
                    }
                }
                return ((TranslatableComponent.Builder)((TranslatableComponent.Builder)Component.translatable().key(compound.getString(TRANSLATE_KEY)).fallback(fallback).arguments(arguments).style(style)).append(children)).build();
            }
            case "keybind": {
                return ((KeybindComponent.Builder)((KeybindComponent.Builder)Component.keybind().keybind(compound.getString("keybind")).style(style)).append(children)).build();
            }
            case "score": {
                CompoundTag binaryScore = compound.getCompound("score");
                String scoreName = binaryScore.getString(SCORE_NAME);
                String scoreObjective = binaryScore.getString(SCORE_OBJECTIVE);
                return ((ScoreComponent.Builder)((ScoreComponent.Builder)Component.score().name(scoreName).objective(scoreObjective).style(style)).append(children)).build();
            }
            case "selector": {
                String selector = compound.getString("selector");
                Component selectorSeparator = null;
                Tag binarySelectorSeparator = compound.get("separator");
                if (binarySelectorSeparator != null) {
                    selectorSeparator = this.deserialize(binarySelectorSeparator);
                }
                return ((SelectorComponent.Builder)((SelectorComponent.Builder)Component.selector().pattern(selector).separator((ComponentLike)selectorSeparator).style(style)).append(children)).build();
            }
            case "nbt": {
                Tag binaryBlock;
                String nbtPath = compound.getString("nbt");
                boolean nbtInterpret = compound.getBoolean(NBT_INTERPRET);
                Component nbtSeparator = null;
                Tag binaryNbtSeparator = compound.get("separator");
                if (binaryNbtSeparator != null) {
                    nbtSeparator = this.deserialize(binaryNbtSeparator);
                }
                if ((binaryBlock = compound.get(NBT_BLOCK)) != null) {
                    BlockNBTComponent.Pos pos = BlockNBTComponent.Pos.fromString((String)binaryBlock.getAsString());
                    return ((BlockNBTComponent.Builder)((BlockNBTComponent.Builder)((BlockNBTComponent.Builder)((BlockNBTComponent.Builder)((BlockNBTComponent.Builder)Component.blockNBT().nbtPath(nbtPath)).interpret(nbtInterpret)).separator((ComponentLike)nbtSeparator)).pos(pos).style(style)).append(children)).build();
                }
                Tag binaryEntity = compound.get(NBT_ENTITY);
                if (binaryEntity != null) {
                    return ((EntityNBTComponent.Builder)((EntityNBTComponent.Builder)((EntityNBTComponent.Builder)((EntityNBTComponent.Builder)((EntityNBTComponent.Builder)Component.entityNBT().nbtPath(nbtPath)).interpret(nbtInterpret)).separator((ComponentLike)nbtSeparator)).selector(binaryEntity.getAsString()).style(style)).append(children)).build();
                }
                Tag binaryStorage = compound.get(NBT_STORAGE);
                if (binaryStorage == null) break;
                return ((StorageNBTComponent.Builder)((StorageNBTComponent.Builder)((StorageNBTComponent.Builder)((StorageNBTComponent.Builder)((StorageNBTComponent.Builder)Component.storageNBT().nbtPath(nbtPath)).interpret(nbtInterpret)).separator((ComponentLike)nbtSeparator)).storage(Key.key((String)binaryStorage.getAsString())).style(style)).append(children)).build();
            }
        }
        throw new IllegalArgumentException("Unknown component type " + type);
    }

    @NotNull
    public Tag serialize(@NotNull Component component) {
        if (((Boolean)this.flags.value(NBTSerializerOptions.EMIT_COMPACT_TEXT_COMPONENT)).booleanValue() && component instanceof TextComponent && !component.hasStyling() && component.children().isEmpty()) {
            return new StringTag(((TextComponent)component).content());
        }
        return this.writeCompoundComponent(component);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    private CompoundTag writeCompoundComponent(@NotNull Component component) {
        CompoundTag builder = new CompoundTag();
        NBTStyleSerializer.serialize(component.style(), builder, this);
        if (component instanceof TextComponent) {
            this.writeComponentType("text", builder);
            builder.putString("text", ((TextComponent)component).content());
        } else if (component instanceof TranslatableComponent) {
            String fallback;
            this.writeComponentType(TYPE_TRANSLATABLE, builder);
            TranslatableComponent translatable = (TranslatableComponent)component;
            builder.putString(TRANSLATE_KEY, translatable.key());
            List arguments = translatable.arguments();
            if (!arguments.isEmpty()) {
                ArrayList<Tag> argumentsTags = new ArrayList<Tag>();
                for (TranslationArgument argument : arguments) {
                    argumentsTags.add(this.writeCompoundComponent(argument.asComponent()));
                }
                builder.put(TRANSLATE_WITH, new ListTag(argumentsTags));
            }
            if ((fallback = translatable.fallback()) != null) {
                builder.putString(TRANSLATE_FALLBACK, fallback);
            }
        } else if (component instanceof KeybindComponent) {
            this.writeComponentType("keybind", builder);
            builder.putString("keybind", ((KeybindComponent)component).keybind());
        } else if (component instanceof ScoreComponent) {
            this.writeComponentType("score", builder);
            ScoreComponent score = (ScoreComponent)component;
            CompoundTag scoreBuilder = new CompoundTag();
            scoreBuilder.putString(SCORE_NAME, score.name());
            scoreBuilder.putString(SCORE_OBJECTIVE, score.objective());
            builder.put("score", scoreBuilder);
        } else if (component instanceof SelectorComponent) {
            this.writeComponentType("selector", builder);
            SelectorComponent selector = (SelectorComponent)component;
            builder.putString("selector", selector.pattern());
            separator = selector.separator();
            if (separator != null) {
                builder.put("separator", this.serialize(separator));
            }
        } else {
            if (!(component instanceof NBTComponent)) throw NBTComponentSerializerImpl.notSureHowToSerialize(component);
            this.writeComponentType("nbt", builder);
            NBTComponent nbt = (NBTComponent)component;
            builder.putString("nbt", nbt.nbtPath());
            builder.putBoolean(NBT_INTERPRET, nbt.interpret());
            separator = nbt.separator();
            if (separator != null) {
                builder.put("separator", this.serialize(separator));
            }
            if (nbt instanceof BlockNBTComponent) {
                builder.putString(NBT_BLOCK, ((BlockNBTComponent)nbt).pos().asString());
            } else if (nbt instanceof EntityNBTComponent) {
                builder.putString(NBT_ENTITY, ((EntityNBTComponent)nbt).selector());
            } else {
                if (!(nbt instanceof StorageNBTComponent)) throw NBTComponentSerializerImpl.notSureHowToSerialize(component);
                builder.putString(NBT_STORAGE, ((StorageNBTComponent)nbt).storage().asString());
            }
        }
        List children = component.children();
        if (children.isEmpty()) return builder;
        ArrayList<Tag> serializedChildren = new ArrayList<Tag>();
        for (Component child : children) {
            serializedChildren.add(this.writeCompoundComponent(child));
        }
        builder.put(EXTRA, new ListTag(serializedChildren));
        return builder;
    }

    @NotNull
    OptionState flags() {
        return this.flags;
    }

    private void writeComponentType(String componentType, CompoundTag tag) {
        if (((Boolean)this.flags.value(NBTSerializerOptions.SERIALIZE_COMPONENT_TYPES)).booleanValue()) {
            tag.putString(TYPE, componentType);
        }
    }

    private static IllegalArgumentException notSureHowToSerialize(Component component) {
        return new IllegalArgumentException("Don't know how to serialize " + String.valueOf(component) + " as a Component");
    }

    static final class BuilderImpl
    implements NBTComponentSerializer.Builder {
        private OptionState flags = OptionState.emptyOptionState();

        BuilderImpl() {
            BUILDER.accept(this);
        }

        @Override
        @NotNull
        public NBTComponentSerializer.Builder options(@NotNull OptionState flags) {
            this.flags = Objects.requireNonNull(flags, "flags");
            return this;
        }

        @Override
        @NotNull
        public NBTComponentSerializer.Builder editOptions(@NotNull Consumer<OptionState.Builder> optionEditor) {
            OptionState.Builder builder = OptionState.optionState().values(this.flags);
            Objects.requireNonNull(optionEditor, "optionEditor").accept(builder);
            this.flags = builder.build();
            return this;
        }

        @Override
        @NotNull
        public NBTComponentSerializer build() {
            return new NBTComponentSerializerImpl(this.flags);
        }
    }

    static final class Instances {
        static final NBTComponentSerializer INSTANCE = SERVICE.map(NBTComponentSerializer.Provider::nbt).orElseGet(() -> new NBTComponentSerializerImpl(OptionState.emptyOptionState()));

        Instances() {
        }
    }
}

