/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.libraries.nbt.adventure;

import java.util.Map;
import net.momirealms.craftengine.libraries.adventure.text.event.DataComponentValue;
import net.momirealms.craftengine.libraries.nbt.CompoundTag;
import net.momirealms.craftengine.libraries.nbt.Tag;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.NonExtendable
public interface NBTDataComponentValue
extends DataComponentValue {
    @NotNull
    public Tag tag();

    default public boolean isRemoved() {
        return false;
    }

    @NotNull
    public static NBTDataComponentValue of(@NotNull Tag tag) {
        return new NBTDataComponentValueImpl(tag);
    }

    @NotNull
    public static NBTDataComponentValue nbtDataComponentValue(@NotNull Tag tag) {
        return new NBTDataComponentValueImpl(tag);
    }

    public static NBTDataComponentValue removed() {
        return RemovedNBTDataComponentValue.INSTANCE;
    }

    public static class NBTDataComponentValueImpl
    implements NBTDataComponentValue {
        private final Tag tag;

        NBTDataComponentValueImpl(@NotNull Tag tag) {
            this.tag = tag;
        }

        @Override
        @NotNull
        public Tag tag() {
            return this.tag;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof NBTDataComponentValueImpl)) {
                return false;
            }
            NBTDataComponentValueImpl that = (NBTDataComponentValueImpl)o;
            return this.tag.equals(that.tag());
        }

        public int hashCode() {
            return this.tag.hashCode();
        }
    }

    public static class RemovedNBTDataComponentValue
    implements NBTDataComponentValue {
        @NotNull
        public static final RemovedNBTDataComponentValue INSTANCE = new RemovedNBTDataComponentValue();
        private final CompoundTag tag = new CompoundTag(Map.of());

        private RemovedNBTDataComponentValue() {
        }

        @Override
        @NotNull
        public Tag tag() {
            return this.tag;
        }

        @Override
        public boolean isRemoved() {
            return true;
        }
    }
}

