/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.libraries.nbt.adventure;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.momirealms.craftengine.libraries.adventure.key.Key;
import net.momirealms.craftengine.libraries.adventure.key.Keyed;
import net.momirealms.craftengine.libraries.adventure.nbt.api.BinaryTagHolder;
import net.momirealms.craftengine.libraries.adventure.text.Component;
import net.momirealms.craftengine.libraries.adventure.text.event.HoverEvent;
import net.momirealms.craftengine.libraries.nbt.CompoundTag;
import net.momirealms.craftengine.libraries.nbt.IntArrayTag;
import net.momirealms.craftengine.libraries.nbt.ListTag;
import net.momirealms.craftengine.libraries.nbt.StringTag;
import net.momirealms.craftengine.libraries.nbt.Tag;
import net.momirealms.craftengine.libraries.nbt.adventure.NBTComponentSerializerImpl;
import net.momirealms.craftengine.libraries.nbt.adventure.NBTDataComponentValue;
import net.momirealms.craftengine.libraries.nbt.util.UUIDUtil;
import org.jetbrains.annotations.NotNull;

class NBTHoverEventSerializer {
    private static final String HOVER_EVENT_ACTION = "action";
    private static final String HOVER_EVENT_CONTENTS = "contents";
    private static final String HOVER_EVENT_SHOW_TEXT = "show_text";
    private static final String HOVER_EVENT_SHOW_ITEM = "show_item";
    private static final String HOVER_EVENT_SHOW_ENTITY = "show_entity";
    private static final String SHOW_TEXT_VALUE = "value";
    private static final String SHOW_ITEM_ID = "id";
    private static final String SHOW_ITEM_COUNT = "count";
    private static final String SHOW_ITEM_COMPONENTS = "components";
    private static final String SHOW_ITEM_TAG = "tag";
    private static final String SHOW_ENTITY_NAME = "name";
    private static final String LEGACY_SHOW_ENTITY_TYPE = "type";
    private static final String LEGACY_SHOW_ENTITY_ID = "id";
    private static final String MODERN_SHOW_ENTITY_ID = "id";
    private static final String MODERN_SHOW_ENTITY_UUID = "uuid";

    private NBTHoverEventSerializer() {
    }

    @NotNull
    static HoverEvent<?> deserialize(@NotNull CompoundTag compound, @NotNull NBTComponentSerializerImpl serializer) {
        HoverEvent.Action action = (HoverEvent.Action)HoverEvent.Action.NAMES.valueOrThrow((Object)compound.getString(HOVER_EVENT_ACTION));
        if (serializer.modernHoverEvent) {
            return NBTHoverEventSerializer.deserializeModern(compound, serializer);
        }
        return NBTHoverEventSerializer.deserializeLegacy(compound, serializer);
    }

    @NotNull
    static HoverEvent<?> deserializeModern(@NotNull CompoundTag compound, @NotNull NBTComponentSerializerImpl serializer) {
        UUID entityId;
        HoverEvent.Action action = (HoverEvent.Action)HoverEvent.Action.NAMES.valueOrThrow((Object)compound.getString(HOVER_EVENT_ACTION));
        if (action == HoverEvent.Action.SHOW_TEXT) {
            return HoverEvent.showText((Component)serializer.deserialize(compound.get(SHOW_TEXT_VALUE)));
        }
        if (action == HoverEvent.Action.SHOW_ITEM) {
            Key itemId = Key.key((String)compound.getString("id"));
            int itemCount = compound.getInt(SHOW_ITEM_COUNT, 1);
            CompoundTag components = (CompoundTag)compound.get(SHOW_ITEM_COMPONENTS);
            if (components != null) {
                HashMap<Key, NBTDataComponentValue> componentValues = new HashMap<Key, NBTDataComponentValue>();
                for (String key : components.keySet()) {
                    Tag value = components.get(key);
                    if (value == null) continue;
                    if (key.charAt(0) == '!') {
                        componentValues.put(Key.key((String)key.substring(1)), NBTDataComponentValue.removed());
                        continue;
                    }
                    componentValues.put(Key.key((String)key), NBTDataComponentValue.of(value));
                }
                return HoverEvent.showItem((Keyed)itemId, (int)itemCount, componentValues);
            }
            return HoverEvent.showItem((Key)itemId, (int)itemCount);
        }
        Key entityType = Key.key((String)compound.getString("id"));
        Tag uuidTag = compound.get(MODERN_SHOW_ENTITY_UUID);
        if (uuidTag instanceof StringTag) {
            StringTag stringTag = (StringTag)uuidTag;
            entityId = UUID.fromString(stringTag.getAsString());
        } else if (uuidTag instanceof IntArrayTag) {
            IntArrayTag intArrayTag = (IntArrayTag)uuidTag;
            entityId = UUIDUtil.uuidFromIntArray(intArrayTag.getAsIntArray());
        } else {
            entityId = new UUID(0L, 0L);
        }
        Tag entityName = compound.get(SHOW_ENTITY_NAME);
        if (entityName != null) {
            return HoverEvent.showEntity((Key)entityType, (UUID)entityId, (Component)serializer.deserialize(entityName));
        }
        return HoverEvent.showEntity((Key)entityType, (UUID)entityId);
    }

    @NotNull
    static HoverEvent<?> deserializeLegacy(@NotNull CompoundTag compound, @NotNull NBTComponentSerializerImpl serializer) {
        HoverEvent.Action action = (HoverEvent.Action)HoverEvent.Action.NAMES.valueOrThrow((Object)compound.getString(HOVER_EVENT_ACTION));
        Tag contents = compound.get(HOVER_EVENT_CONTENTS);
        if (contents == null) {
            throw new IllegalArgumentException("The hover event doesn't contain any contents");
        }
        Class actionType = action.type();
        if (Component.class.isAssignableFrom(actionType)) {
            return HoverEvent.showText((Component)serializer.deserialize(contents));
        }
        if (HoverEvent.ShowItem.class.isAssignableFrom(actionType)) {
            if (contents instanceof CompoundTag) {
                CompoundTag showItemContents = (CompoundTag)contents;
                if (serializer.componentRelease) {
                    return NBTHoverEventSerializer.deserializeModernShowItem(serializer, showItemContents);
                }
                return NBTHoverEventSerializer.deserializeLegacyShowItem(serializer, showItemContents);
            }
            if (contents instanceof StringTag) {
                StringTag stringTag = (StringTag)contents;
                return HoverEvent.showItem((Key)Key.key((String)stringTag.getAsString()), (int)1);
            }
            throw new IllegalArgumentException("Failed to deserialize show item hover event. Unkown tag type: " + contents.getType().name() + ". " + contents.getAsString());
        }
        if (HoverEvent.ShowEntity.class.isAssignableFrom(actionType)) {
            UUID entityId;
            CompoundTag showEntityContents = (CompoundTag)contents;
            Key entityType = Key.key((String)showEntityContents.getString(LEGACY_SHOW_ENTITY_TYPE));
            Tag uuidTag = showEntityContents.get("id");
            if (uuidTag instanceof StringTag) {
                StringTag stringTag = (StringTag)uuidTag;
                entityId = UUID.fromString(stringTag.getAsString());
            } else if (uuidTag instanceof ListTag) {
                ListTag listTag = (ListTag)uuidTag;
                entityId = UUIDUtil.uuidFromIntArray(new int[]{listTag.getInt(0), listTag.getInt(1), listTag.getInt(2), listTag.getInt(3)});
            } else {
                entityId = new UUID(0L, 0L);
            }
            Tag entityName = showEntityContents.get(SHOW_ENTITY_NAME);
            if (entityName != null) {
                return HoverEvent.showEntity((Key)entityType, (UUID)entityId, (Component)serializer.deserialize(entityName));
            }
            return HoverEvent.showEntity((Key)entityType, (UUID)entityId);
        }
        throw new IllegalArgumentException("Failed to deserialize hover event. Unkown action type: " + String.valueOf(actionType));
    }

    static HoverEvent deserializeLegacyShowItem(NBTComponentSerializerImpl serializer, @NotNull CompoundTag showItemContents) {
        Key itemId = Key.key((String)showItemContents.getString("id"));
        int itemCount = showItemContents.getInt(SHOW_ITEM_COUNT, 1);
        String tag = showItemContents.getString(SHOW_ITEM_TAG);
        if (tag != null && !tag.isEmpty()) {
            return HoverEvent.showItem((Key)itemId, (int)itemCount, (BinaryTagHolder)BinaryTagHolder.binaryTagHolder((String)tag));
        }
        return HoverEvent.showItem((Key)itemId, (int)itemCount);
    }

    static HoverEvent deserializeModernShowItem(NBTComponentSerializerImpl serializer, @NotNull CompoundTag showItemContents) {
        Key itemId = Key.key((String)showItemContents.getString("id"));
        int itemCount = showItemContents.getInt(SHOW_ITEM_COUNT, 1);
        CompoundTag components = (CompoundTag)showItemContents.get(SHOW_ITEM_COMPONENTS);
        if (components != null && !components.isEmpty()) {
            HashMap<Key, NBTDataComponentValue> componentValues = new HashMap<Key, NBTDataComponentValue>();
            for (Map.Entry<String, Tag> entry : components.entrySet()) {
                String key = entry.getKey();
                if (key.charAt(0) == '!') {
                    componentValues.put(Key.key((String)key.substring(1)), NBTDataComponentValue.removed());
                    continue;
                }
                componentValues.put(Key.key((String)key), NBTDataComponentValue.of(entry.getValue()));
            }
            return HoverEvent.showItem((Keyed)itemId, (int)itemCount, componentValues);
        }
        return HoverEvent.showItem((Key)itemId, (int)itemCount);
    }

    @NotNull
    static <V> CompoundTag serialize(@NotNull HoverEvent<V> event, @NotNull NBTComponentSerializerImpl serializer) {
        if (serializer.modernHoverEvent) {
            return NBTHoverEventSerializer.serializeModern(event, serializer);
        }
        return NBTHoverEventSerializer.serializeLegacy(event, serializer);
    }

    static <V> CompoundTag serializeModern(@NotNull HoverEvent<V> event, @NotNull NBTComponentSerializerImpl serializer) {
        HoverEvent.Action action = event.action();
        CompoundTag hoverTag = new CompoundTag();
        if (action == HoverEvent.Action.SHOW_TEXT) {
            hoverTag.putString(HOVER_EVENT_ACTION, HOVER_EVENT_SHOW_TEXT);
            hoverTag.put(SHOW_TEXT_VALUE, serializer.serialize((Component)event.value()));
        } else if (action == HoverEvent.Action.SHOW_ITEM) {
            HoverEvent.ShowItem item = (HoverEvent.ShowItem)event.value();
            hoverTag.putString(HOVER_EVENT_ACTION, HOVER_EVENT_SHOW_ITEM);
            hoverTag.putString("id", item.item().asString());
            hoverTag.putInt(SHOW_ITEM_COUNT, item.count());
            Map components = item.dataComponentsAs(NBTDataComponentValue.class);
            if (!components.isEmpty()) {
                CompoundTag dataComponents = new CompoundTag();
                for (Map.Entry entry : components.entrySet()) {
                    NBTDataComponentValue value = (NBTDataComponentValue)entry.getValue();
                    String component = ((Key)entry.getKey()).asString();
                    if (value.isRemoved()) {
                        dataComponents.put("!" + component, value.tag());
                        continue;
                    }
                    dataComponents.put(component, value.tag());
                }
                hoverTag.put(SHOW_ITEM_COMPONENTS, dataComponents);
            }
        } else if (action == HoverEvent.Action.SHOW_ENTITY) {
            HoverEvent.ShowEntity entity = (HoverEvent.ShowEntity)event.value();
            hoverTag.putString(HOVER_EVENT_ACTION, HOVER_EVENT_SHOW_ENTITY);
            hoverTag.putString("id", entity.type().asString());
            hoverTag.putString(MODERN_SHOW_ENTITY_UUID, entity.id().toString());
            Component customName = entity.name();
            if (customName != null) {
                hoverTag.put(SHOW_ENTITY_NAME, serializer.serialize(customName));
            }
        } else {
            throw new IllegalArgumentException("Failed to serialize " + String.valueOf(event) + " as a hoverTag. Unknown action type: " + String.valueOf(action));
        }
        return hoverTag;
    }

    static <V> CompoundTag serializeLegacy(@NotNull HoverEvent<V> event, @NotNull NBTComponentSerializerImpl serializer) {
        String actionType;
        Tag contents;
        HoverEvent.Action action = event.action();
        CompoundTag hoverTag = new CompoundTag();
        if (action == HoverEvent.Action.SHOW_TEXT) {
            contents = serializer.serialize((Component)event.value());
            actionType = HOVER_EVENT_SHOW_TEXT;
        } else if (action == HoverEvent.Action.SHOW_ITEM) {
            HoverEvent.ShowItem item = (HoverEvent.ShowItem)event.value();
            CompoundTag showItemTag = new CompoundTag();
            showItemTag.putString("id", item.item().asString());
            showItemTag.putInt(SHOW_ITEM_COUNT, item.count());
            if (serializer.componentRelease) {
                Map components = item.dataComponentsAs(NBTDataComponentValue.class);
                if (!components.isEmpty()) {
                    CompoundTag dataComponents = new CompoundTag();
                    for (Map.Entry entry : components.entrySet()) {
                        NBTDataComponentValue value = (NBTDataComponentValue)entry.getValue();
                        String component = ((Key)entry.getKey()).asString();
                        if (value.isRemoved()) {
                            dataComponents.put("!" + component, value.tag());
                            continue;
                        }
                        dataComponents.put(component, value.tag());
                    }
                    showItemTag.put(SHOW_ITEM_COMPONENTS, dataComponents);
                }
            } else {
                BinaryTagHolder nbt = item.nbt();
                if (nbt != null) {
                    showItemTag.putString(SHOW_ITEM_TAG, nbt.string());
                }
            }
            contents = showItemTag;
            actionType = HOVER_EVENT_SHOW_ITEM;
        } else if (action == HoverEvent.Action.SHOW_ENTITY) {
            HoverEvent.ShowEntity entity = (HoverEvent.ShowEntity)event.value();
            CompoundTag showEntityTag = new CompoundTag();
            showEntityTag.putString(LEGACY_SHOW_ENTITY_TYPE, entity.type().asString());
            showEntityTag.putString("id", entity.id().toString());
            Component customName = entity.name();
            if (customName != null) {
                showEntityTag.put(SHOW_ENTITY_NAME, serializer.serialize(customName));
            }
            contents = showEntityTag;
            actionType = HOVER_EVENT_SHOW_ENTITY;
        } else {
            throw new IllegalArgumentException("Failed to serialize " + String.valueOf(event) + " as a hoverTag. Unknown action type: " + String.valueOf(action));
        }
        hoverTag.putString(HOVER_EVENT_ACTION, actionType);
        hoverTag.put(HOVER_EVENT_CONTENTS, contents);
        return hoverTag;
    }
}

