/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.block.entity.renderer.element;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import net.momirealms.craftengine.bukkit.block.entity.renderer.element.TextDisplayBlockEntityElement;
import net.momirealms.craftengine.bukkit.entity.data.TextDisplayEntityData;
import net.momirealms.craftengine.bukkit.util.ComponentUtils;
import net.momirealms.craftengine.core.block.entity.render.element.BlockEntityElement;
import net.momirealms.craftengine.core.block.entity.render.element.BlockEntityElementConfig;
import net.momirealms.craftengine.core.block.entity.render.element.BlockEntityElementConfigFactory;
import net.momirealms.craftengine.core.entity.Billboard;
import net.momirealms.craftengine.core.entity.player.Player;
import net.momirealms.craftengine.core.plugin.context.PlayerOptionalContext;
import net.momirealms.craftengine.core.util.AdventureHelper;
import net.momirealms.craftengine.core.util.ResourceConfigUtils;
import net.momirealms.craftengine.core.world.BlockPos;
import net.momirealms.craftengine.core.world.World;
import net.momirealms.craftengine.libraries.adventure.text.Component;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class TextDisplayBlockEntityElementConfig
implements BlockEntityElementConfig<TextDisplayBlockEntityElement> {
    public static final Factory FACTORY = new Factory();
    private final Function<Player, List<Object>> lazyMetadataPacket;
    private final String text;
    private final Vector3f scale;
    private final Vector3f position;
    private final Vector3f translation;
    private final float xRot;
    private final float yRot;
    private final Quaternionf rotation;
    private final Billboard billboard;

    public TextDisplayBlockEntityElementConfig(String text, Vector3f scale, Vector3f position, Vector3f translation, float xRot, float yRot, Quaternionf rotation, Billboard billboard) {
        this.text = text;
        this.scale = scale;
        this.position = position;
        this.translation = translation;
        this.xRot = xRot;
        this.yRot = yRot;
        this.rotation = rotation;
        this.billboard = billboard;
        this.lazyMetadataPacket = player -> {
            ArrayList<Object> dataValues = new ArrayList<Object>();
            TextDisplayEntityData.Text.addEntityDataIfNotDefaultValue(ComponentUtils.adventureToMinecraft(this.text((Player)player)), dataValues);
            TextDisplayEntityData.Scale.addEntityDataIfNotDefaultValue(this.scale, dataValues);
            TextDisplayEntityData.RotationLeft.addEntityDataIfNotDefaultValue(this.rotation, dataValues);
            TextDisplayEntityData.BillboardConstraints.addEntityDataIfNotDefaultValue(this.billboard.id(), dataValues);
            TextDisplayEntityData.Translation.addEntityDataIfNotDefaultValue(this.translation, dataValues);
            return dataValues;
        };
    }

    @Override
    public TextDisplayBlockEntityElement create(World world, BlockPos pos) {
        return new TextDisplayBlockEntityElement(this, pos);
    }

    public Component text(Player player) {
        return AdventureHelper.miniMessage().deserialize(this.text, PlayerOptionalContext.of(player).tagResolvers());
    }

    public Vector3f scale() {
        return this.scale;
    }

    public Vector3f translation() {
        return this.translation;
    }

    public Vector3f position() {
        return this.position;
    }

    public float yRot() {
        return this.yRot;
    }

    public float xRot() {
        return this.xRot;
    }

    public Billboard billboard() {
        return this.billboard;
    }

    public Quaternionf rotation() {
        return this.rotation;
    }

    public List<Object> metadataValues(Player player) {
        return this.lazyMetadataPacket.apply(player);
    }

    public static class Factory
    implements BlockEntityElementConfigFactory {
        @Override
        public <E extends BlockEntityElement> BlockEntityElementConfig<E> create(Map<String, Object> arguments) {
            String text = ResourceConfigUtils.requireNonEmptyStringOrThrow(arguments.get("text"), "warning.config.block.state.entity_renderer.text_display.missing_text");
            return new TextDisplayBlockEntityElementConfig(text, ResourceConfigUtils.getAsVector3f(arguments.getOrDefault("scale", Float.valueOf(1.0f)), "scale"), ResourceConfigUtils.getAsVector3f(arguments.getOrDefault("position", Float.valueOf(0.5f)), "position"), ResourceConfigUtils.getAsVector3f(arguments.get("translation"), "translation"), ResourceConfigUtils.getAsFloat(arguments.getOrDefault("pitch", Float.valueOf(0.0f)), "pitch"), ResourceConfigUtils.getAsFloat(arguments.getOrDefault("yaw", Float.valueOf(0.0f)), "yaw"), ResourceConfigUtils.getAsQuaternionf(arguments.getOrDefault("rotation", Float.valueOf(0.0f)), "rotation"), Billboard.valueOf(arguments.getOrDefault("billboard", "fixed").toString().toUpperCase(Locale.ROOT)));
        }
    }
}

