/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.compatibility.item;

import io.lumine.mythic.api.adapters.AbstractEntity;
import io.lumine.mythic.api.adapters.AbstractPlayer;
import io.lumine.mythic.api.drops.DropMetadata;
import io.lumine.mythic.api.skills.SkillCaster;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.drops.DropMetadataImpl;
import java.util.Optional;
import net.momirealms.craftengine.core.item.ExternalItemSource;
import net.momirealms.craftengine.core.item.ItemBuildContext;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

public class MythicMobsSource
implements ExternalItemSource<ItemStack> {
    private MythicBukkit mythicBukkit;

    @Override
    public String plugin() {
        return "mythicmobs";
    }

    @Override
    @Nullable
    public ItemStack build(String id, ItemBuildContext context) {
        if (this.mythicBukkit == null || this.mythicBukkit.isClosed()) {
            this.mythicBukkit = MythicBukkit.inst();
        }
        return Optional.ofNullable(context.player()).map(p -> (Player)p.platformPlayer()).map(p -> {
            AbstractPlayer target = BukkitAdapter.adapt((Player)p);
            SkillCaster caster = this.mythicBukkit.getSkillManager().getCaster((AbstractEntity)target);
            DropMetadataImpl meta = new DropMetadataImpl(caster, (AbstractEntity)target);
            return this.mythicBukkit.getItemManager().getItem(id).map(i -> i.generateItemStack((DropMetadata)meta, 1)).map(BukkitAdapter::adapt).orElse(null);
        }).orElseGet(() -> this.mythicBukkit.getItemManager().getItemStack(id));
    }

    @Override
    public String id(ItemStack item) {
        if (this.mythicBukkit == null || this.mythicBukkit.isClosed()) {
            this.mythicBukkit = MythicBukkit.inst();
        }
        return this.mythicBukkit.getItemManager().getMythicTypeFromItem(item);
    }
}

