/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.compatibility.model.modelengine;

import com.ticxo.modelengine.api.ModelEngineAPI;
import com.ticxo.modelengine.api.entity.BaseEntity;
import com.ticxo.modelengine.api.entity.Dummy;
import com.ticxo.modelengine.api.model.ActiveModel;
import com.ticxo.modelengine.api.model.ModeledEntity;
import net.momirealms.craftengine.bukkit.compatibility.model.modelengine.ModelEngineBlockEntityElementConfig;
import net.momirealms.craftengine.core.block.entity.render.element.BlockEntityElement;
import net.momirealms.craftengine.core.world.BlockPos;
import net.momirealms.craftengine.core.world.World;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.joml.Vector3f;

public class ModelEngineBlockEntityElement
implements BlockEntityElement {
    private Dummy<?> dummy;
    private final Location location;
    private final ModelEngineBlockEntityElementConfig config;

    public ModelEngineBlockEntityElement(World world, BlockPos pos, ModelEngineBlockEntityElementConfig config) {
        this.config = config;
        Vector3f position = config.position();
        this.location = new Location((org.bukkit.World)world.platformWorld(), (double)((float)pos.x() + position.x), (double)((float)pos.y() + position.y), (double)((float)pos.z() + position.z), config.yaw(), config.pitch());
        this.dummy = this.createDummy();
    }

    private Dummy<?> createDummy() {
        ActiveModel activeModel = ModelEngineAPI.createActiveModel((String)this.config.model());
        if (activeModel == null) {
            return null;
        }
        Dummy dummy = new Dummy();
        dummy.setLocation(this.location);
        dummy.setDetectingPlayers(false);
        ModeledEntity modeledEntity = ModelEngineAPI.createModeledEntity((BaseEntity)dummy);
        modeledEntity.addModel(activeModel, false);
        return dummy;
    }

    @Override
    public void hide(net.momirealms.craftengine.core.entity.player.Player player) {
        if (this.dummy != null) {
            this.dummy.setForceViewing((Player)player.platformPlayer(), true);
        }
    }

    @Override
    public void show(net.momirealms.craftengine.core.entity.player.Player player) {
        if (this.dummy != null) {
            this.dummy.setForceHidden((Player)player.platformPlayer(), true);
        }
    }

    @Override
    public void deactivate() {
        if (this.dummy != null) {
            this.dummy.setRemoved(true);
            this.dummy = null;
        }
    }

    @Override
    public void activate() {
        if (this.dummy == null) {
            this.dummy = this.createDummy();
        }
    }
}

