/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.compatibility.skript.condition;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import net.momirealms.craftengine.bukkit.compatibility.skript.event.EvtCraftEngineReload;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="CraftEngine has been load")
@Description(value={"Checks CraftEngine has been load."})
@Since(value={"1.0"})
public class CondIsCraftEngineHasBeenLoad
extends Condition {
    public static void register() {
        Skript.registerCondition(CondIsCraftEngineHasBeenLoad.class, (String[])new String[]{"(ce|craft[-]engine) (has been|is) load[ed]", "(ce|craft[-]engine) (has not been|is not) load[ed] [yet]", "(ce|craft[-]engine) (hasn't been|isn't) load[ed] [yet]"});
    }

    public boolean init(Expression<?>[] expressions, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.setNegated(matchedPattern >= 1);
        return true;
    }

    public boolean check(Event event) {
        boolean beenLoad = EvtCraftEngineReload.hasBeenLoad();
        return this.isNegated() ? !beenLoad : beenLoad;
    }

    public String toString(@Nullable Event event, boolean debug) {
        return "craft-engine " + (this.isNegated() ? "is not" : "is") + " loaded";
    }
}

