/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.compatibility.skript.event;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.registrations.EventValues;
import java.util.Arrays;
import net.momirealms.craftengine.bukkit.api.event.CustomBlockBreakEvent;
import net.momirealms.craftengine.bukkit.api.event.CustomBlockPlaceEvent;
import net.momirealms.craftengine.bukkit.util.BlockStateUtils;
import net.momirealms.craftengine.core.block.ImmutableBlockState;
import net.momirealms.craftengine.core.block.UnsafeBlockStateMatcher;
import net.momirealms.craftengine.core.entity.player.InteractionHand;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerEvent;
import org.jetbrains.annotations.Nullable;

@Name(value="On Custom Block Place And Break")
@Description(value={"Fires when a Custom block gets place and broken"})
@Since(value={"1.0"})
public class EvtCustomBlock
extends SkriptEvent {
    @Nullable
    private Literal<UnsafeBlockStateMatcher> blocks;
    private UnsafeBlockStateMatcher[] blockArray;
    private boolean mine = false;

    public static void register() {
        Skript.registerEvent((String)"Break Custom Block", EvtCustomBlock.class, CustomBlockBreakEvent.class, (String[])new String[]{"(break[ing]|1\u00a6min(e|ing)) of (custom|ce|craft-engine) block[s] [[of] %-unsafeblockstatematchers%]"}).description(new String[]{"Called when a custom block is broken by a player. If you use 'on mine', only events where the broken block dropped something will call the trigger."});
        EventValues.registerEventValue(CustomBlockBreakEvent.class, Location.class, CustomBlockBreakEvent::location, (int)0);
        EventValues.registerEventValue(CustomBlockBreakEvent.class, Player.class, PlayerEvent::getPlayer, (int)0);
        EventValues.registerEventValue(CustomBlockBreakEvent.class, Block.class, CustomBlockBreakEvent::bukkitBlock, (int)0);
        EventValues.registerEventValue(CustomBlockBreakEvent.class, World.class, event -> event.location().getWorld(), (int)0);
        Skript.registerEvent((String)"Place Custom Block", EvtCustomBlock.class, CustomBlockPlaceEvent.class, (String[])new String[]{"(plac(e|ing)|build[ing]) of (custom|ce|craft-engine) block[s] [[of] %-unsafeblockstatematchers%]"}).description(new String[]{"Called when a player places a custom block."});
        EventValues.registerEventValue(CustomBlockPlaceEvent.class, Location.class, CustomBlockPlaceEvent::location, (int)0);
        EventValues.registerEventValue(CustomBlockPlaceEvent.class, Player.class, CustomBlockPlaceEvent::player, (int)0);
        EventValues.registerEventValue(CustomBlockPlaceEvent.class, Block.class, CustomBlockPlaceEvent::bukkitBlock, (int)0);
        EventValues.registerEventValue(CustomBlockPlaceEvent.class, World.class, event -> event.location().getWorld(), (int)0);
    }

    public boolean init(Literal<?>[] args, int matchedPattern, SkriptParser.ParseResult parser) {
        if (args[0] != null) {
            this.blocks = args[0];
            this.blockArray = (UnsafeBlockStateMatcher[])this.blocks.getAll();
        }
        this.mine = parser.mark == 1;
        return true;
    }

    public boolean check(Event event) {
        ImmutableBlockState state;
        CustomBlockBreakEvent customBlockBreakEvent;
        if (this.mine && event instanceof CustomBlockBreakEvent && !BlockStateUtils.isCorrectTool((customBlockBreakEvent = (CustomBlockBreakEvent)event).blockState(), customBlockBreakEvent.player().getItemInHand(InteractionHand.MAIN_HAND))) {
            return false;
        }
        if (this.blocks == null) {
            return true;
        }
        if (event instanceof CustomBlockBreakEvent) {
            CustomBlockBreakEvent customBlockBreakEvent2 = (CustomBlockBreakEvent)event;
            state = customBlockBreakEvent2.blockState();
        } else if (event instanceof CustomBlockPlaceEvent) {
            CustomBlockPlaceEvent customBlockPlaceEvent = (CustomBlockPlaceEvent)event;
            state = customBlockPlaceEvent.blockState();
        } else {
            return false;
        }
        return Arrays.stream(this.blockArray).anyMatch(block -> block.matches(state));
    }

    public String toString(@Nullable Event event, boolean debug) {
        return "break/place" + (String)(this.blocks != null ? " of " + this.blocks.toString(event, debug) : "");
    }
}

