/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.compatibility.skript.event;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Literal;
import ch.njol.skript.lang.SkriptEvent;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.registrations.EventValues;
import java.util.Arrays;
import net.momirealms.craftengine.bukkit.api.event.FurnitureBreakEvent;
import net.momirealms.craftengine.bukkit.api.event.FurniturePlaceEvent;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.Nullable;

@Name(value="On Custom Furniture Place And Break")
@Description(value={"Fires when a Custom furniture gets place and broken"})
@Since(value={"1.0"})
public class EvtCustomFurniture
extends SkriptEvent {
    @Nullable
    private Literal<String> ids;
    private String[] idArray;

    public static void register() {
        Skript.registerEvent((String)"Break Furniture", EvtCustomFurniture.class, FurnitureBreakEvent.class, (String[])new String[]{"(break[ing]) of [(custom|ce|craft-engine)] furniture[s] [[of] %-strings%]"}).description(new String[]{"Called when a furniture is broken by a player."});
        EventValues.registerEventValue(FurnitureBreakEvent.class, Location.class, FurnitureBreakEvent::location, (int)0);
        EventValues.registerEventValue(FurnitureBreakEvent.class, Player.class, FurnitureBreakEvent::player, (int)0);
        EventValues.registerEventValue(FurnitureBreakEvent.class, Entity.class, event -> event.furniture().baseEntity(), (int)0);
        EventValues.registerEventValue(FurnitureBreakEvent.class, World.class, event -> event.location().getWorld(), (int)0);
        Skript.registerEvent((String)"Place Furniture", EvtCustomFurniture.class, FurniturePlaceEvent.class, (String[])new String[]{"(plac(e|ing)|build[ing]) of [(custom|ce|craft-engine)] furniture[s] [[of] %-strings%]"}).description(new String[]{"Called when a player places a furniture."});
        EventValues.registerEventValue(FurniturePlaceEvent.class, Location.class, FurniturePlaceEvent::location, (int)0);
        EventValues.registerEventValue(FurniturePlaceEvent.class, Player.class, FurniturePlaceEvent::player, (int)0);
        EventValues.registerEventValue(FurniturePlaceEvent.class, Entity.class, event -> event.furniture().baseEntity(), (int)0);
        EventValues.registerEventValue(FurniturePlaceEvent.class, World.class, event -> event.location().getWorld(), (int)0);
    }

    public boolean init(Literal<?>[] args, int matchedPattern, SkriptParser.ParseResult parser) {
        if (args[0] != null) {
            this.ids = args[0];
            this.idArray = (String[])this.ids.getAll();
        }
        return true;
    }

    public boolean check(Event event) {
        String id;
        if (this.ids == null) {
            return true;
        }
        if (event instanceof FurnitureBreakEvent) {
            FurnitureBreakEvent e = (FurnitureBreakEvent)event;
            id = e.furniture().id().toString();
        } else if (event instanceof FurniturePlaceEvent) {
            FurniturePlaceEvent e = (FurniturePlaceEvent)event;
            id = e.furniture().id().toString();
        } else {
            return false;
        }
        return Arrays.asList(this.idArray).contains(id);
    }

    public String toString(@Nullable Event event, boolean debug) {
        return "break/place" + (String)(this.ids != null ? " of " + this.ids.toString(event, debug) : "");
    }
}

