/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.compatibility.skript.expression;

import ch.njol.skript.Skript;
import ch.njol.skript.aliases.ItemType;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import ch.njol.skript.doc.Since;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.util.ArrayList;
import net.momirealms.craftengine.bukkit.api.CraftEngineItems;
import net.momirealms.craftengine.core.item.CustomItem;
import net.momirealms.craftengine.core.item.ItemBuildContext;
import net.momirealms.craftengine.core.util.Key;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

@Name(value="CraftEngine Item")
@Description(value={"Get CraftEngine items."})
@Since(value={"1.0"})
public class ExprCustomItem
extends SimpleExpression<ItemType> {
    private Expression<?> itemIds;

    public static void register() {
        Skript.registerExpression(ExprCustomItem.class, ItemType.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[(the|a)] (custom|ce|craft-engine) item [with [namespace] id] %strings%"});
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.itemIds = exprs[0];
        return true;
    }

    @Nullable
    protected ItemType[] get(Event event) {
        Object[] objects = this.itemIds.getArray(event);
        ArrayList<ItemType> items = new ArrayList<ItemType>();
        for (Object object : objects) {
            String string;
            CustomItem<ItemStack> customItem;
            if (!(object instanceof String) || (customItem = CraftEngineItems.byId(Key.of(string = (String)object))) == null) continue;
            ItemType itemType = new ItemType((ItemStack)customItem.buildItemStack(ItemBuildContext.empty()));
            items.add(itemType);
        }
        return items.toArray(new ItemType[0]);
    }

    public boolean isSingle() {
        return true;
    }

    public Class<ItemType> getReturnType() {
        return ItemType.class;
    }

    public String toString(@Nullable Event e, boolean debug) {
        return "craft-engine item with id " + this.itemIds.toString(e, debug);
    }
}

