/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.entity;

import java.lang.ref.WeakReference;
import java.util.UUID;
import net.momirealms.craftengine.bukkit.util.EntityUtils;
import net.momirealms.craftengine.bukkit.world.BukkitWorld;
import net.momirealms.craftengine.core.entity.AbstractEntity;
import net.momirealms.craftengine.core.util.Direction;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.world.World;
import org.bukkit.entity.Entity;

public class BukkitEntity
extends AbstractEntity {
    private final WeakReference<Entity> entity;

    public BukkitEntity(Entity entity) {
        this.entity = new WeakReference<Entity>(entity);
    }

    @Override
    public double x() {
        return this.literalObject().getX();
    }

    @Override
    public double y() {
        return this.literalObject().getY();
    }

    @Override
    public double z() {
        return this.literalObject().getZ();
    }

    @Override
    public void tick() {
    }

    @Override
    public int entityID() {
        return this.literalObject().getEntityId();
    }

    @Override
    public float xRot() {
        return this.literalObject().getYaw();
    }

    @Override
    public float yRot() {
        return this.literalObject().getPitch();
    }

    @Override
    public World world() {
        return new BukkitWorld(this.literalObject().getWorld());
    }

    @Override
    public Direction getDirection() {
        return Direction.NORTH;
    }

    public Entity literalObject() {
        return (Entity)this.entity.get();
    }

    @Override
    public Key type() {
        return EntityUtils.getEntityType(this.literalObject());
    }

    @Override
    public String name() {
        return this.literalObject().getName();
    }

    @Override
    public UUID uuid() {
        return this.literalObject().getUniqueId();
    }
}

