/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.entity.data;

import java.util.List;
import net.momirealms.craftengine.bukkit.entity.data.EntityDataValue;
import net.momirealms.craftengine.bukkit.entity.data.SimpleEntityData;

public interface EntityData<T> {
    public Object serializer();

    public int id();

    public T defaultValue();

    public Object entityDataAccessor();

    default public Object createEntityDataIfNotDefaultValue(T value) {
        if (this.defaultValue().equals(value)) {
            return null;
        }
        return EntityDataValue.create(this.id(), this.serializer(), this.entityDataAccessor(), value);
    }

    default public void addEntityDataIfNotDefaultValue(T value, List<Object> list) {
        if (!this.defaultValue().equals(value)) {
            list.add(EntityDataValue.create(this.id(), this.serializer(), this.entityDataAccessor(), value));
        }
    }

    default public void addEntityData(T value, List<Object> list) {
        list.add(EntityDataValue.create(this.id(), this.serializer(), this.entityDataAccessor(), value));
    }

    public static <T> EntityData<T> of(Class<?> clazz, Object serializer, T defaultValue) {
        return new SimpleEntityData<T>(clazz, serializer, defaultValue);
    }
}

