/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.entity.furniture.hitbox;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.momirealms.craftengine.bukkit.entity.data.InteractionEntityData;
import net.momirealms.craftengine.bukkit.entity.data.ShulkerData;
import net.momirealms.craftengine.bukkit.entity.furniture.BukkitCollider;
import net.momirealms.craftengine.bukkit.nms.FastNMS;
import net.momirealms.craftengine.bukkit.plugin.reflection.minecraft.CoreReflections;
import net.momirealms.craftengine.bukkit.plugin.reflection.minecraft.MAttributeHolders;
import net.momirealms.craftengine.bukkit.plugin.reflection.minecraft.MEntityTypes;
import net.momirealms.craftengine.bukkit.plugin.reflection.minecraft.NetworkReflections;
import net.momirealms.craftengine.bukkit.util.DirectionUtils;
import net.momirealms.craftengine.core.entity.furniture.AbstractHitBox;
import net.momirealms.craftengine.core.entity.furniture.Collider;
import net.momirealms.craftengine.core.entity.furniture.HitBox;
import net.momirealms.craftengine.core.entity.furniture.HitBoxFactory;
import net.momirealms.craftengine.core.entity.furniture.HitBoxTypes;
import net.momirealms.craftengine.core.entity.furniture.Seat;
import net.momirealms.craftengine.core.util.Direction;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.MCUtils;
import net.momirealms.craftengine.core.util.ResourceConfigUtils;
import net.momirealms.craftengine.core.util.VersionHelper;
import net.momirealms.craftengine.core.world.Vec3d;
import net.momirealms.craftengine.core.world.World;
import net.momirealms.craftengine.core.world.WorldPosition;
import net.momirealms.craftengine.core.world.collision.AABB;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ShulkerHitBox
extends AbstractHitBox {
    public static final Factory FACTORY = new Factory();
    private final float scale;
    private final byte peek;
    private final boolean interactive;
    private final boolean interactionEntity;
    private final Direction direction;
    private final List<Object> cachedShulkerValues = new ArrayList<Object>();
    private final DirectionalShulkerSpawner spawner;
    private final AABBCreator aabbCreator;

    public ShulkerHitBox(Seat[] seats, Vector3f position, Direction direction, float scale, byte peek, boolean interactionEntity, boolean interactive, boolean canUseOn, boolean blocksBuilding, boolean canBeHitByProjectile) {
        super(seats, position, canUseOn, blocksBuilding, canBeHitByProjectile);
        this.direction = direction;
        this.scale = scale;
        this.peek = peek;
        this.interactive = interactive;
        this.interactionEntity = interactionEntity;
        ShulkerData.Peek.addEntityDataIfNotDefaultValue(peek, this.cachedShulkerValues);
        ShulkerData.Color.addEntityDataIfNotDefaultValue((byte)0, this.cachedShulkerValues);
        ShulkerData.NoGravity.addEntityDataIfNotDefaultValue(true, this.cachedShulkerValues);
        ShulkerData.Silent.addEntityDataIfNotDefaultValue(true, this.cachedShulkerValues);
        ShulkerData.MobFlags.addEntityDataIfNotDefaultValue((byte)1, this.cachedShulkerValues);
        ShulkerData.SharedFlags.addEntityDataIfNotDefaultValue((byte)32, this.cachedShulkerValues);
        float shulkerHeight = (ShulkerHitBox.getPhysicalPeek((float)peek * 0.01f) + 1.0f) * scale;
        ArrayList<Object> cachedInteractionValues = new ArrayList<Object>();
        if (this.direction == Direction.UP) {
            InteractionEntityData.Height.addEntityDataIfNotDefaultValue(Float.valueOf(shulkerHeight + 0.01f), cachedInteractionValues);
            InteractionEntityData.Width.addEntityDataIfNotDefaultValue(Float.valueOf(scale + 0.005f), cachedInteractionValues);
            InteractionEntityData.Responsive.addEntityDataIfNotDefaultValue(interactive, cachedInteractionValues);
            this.spawner = (entityIds, world, x, y, z, yaw, offset, packets, collider, aabb) -> {
                collider.accept(this.createCollider(Direction.UP, world, offset, x, y, z, entityIds[1], aabb));
                if (interactionEntity) {
                    packets.accept(FastNMS.INSTANCE.constructor$ClientboundAddEntityPacket(entityIds[2], UUID.randomUUID(), x + (double)offset.x, y + (double)offset.y - (double)0.005f, z - (double)offset.z, 0.0f, yaw, MEntityTypes.INTERACTION, 0, CoreReflections.instance$Vec3$Zero, 0.0), true);
                    packets.accept(FastNMS.INSTANCE.constructor$ClientboundSetEntityDataPacket(entityIds[2], List.copyOf(cachedInteractionValues)), true);
                    if (canUseOn) {
                        aabb.accept(entityIds[2], AABB.fromInteraction(new Vec3d(x + (double)offset.x, y + (double)offset.y, z - (double)offset.z), scale, shulkerHeight));
                    }
                }
            };
            this.aabbCreator = (x, y, z, yaw, offset) -> this.createAABB(Direction.UP, offset, x, y, z);
        } else if (this.direction == Direction.DOWN) {
            InteractionEntityData.Height.addEntityDataIfNotDefaultValue(Float.valueOf(shulkerHeight + 0.01f), cachedInteractionValues);
            InteractionEntityData.Width.addEntityDataIfNotDefaultValue(Float.valueOf(scale + 0.005f), cachedInteractionValues);
            InteractionEntityData.Responsive.addEntityDataIfNotDefaultValue(interactive, cachedInteractionValues);
            this.spawner = (entityIds, world, x, y, z, yaw, offset, packets, collider, aabb) -> {
                collider.accept(this.createCollider(Direction.DOWN, world, offset, x, y, z, entityIds[1], aabb));
                packets.accept(FastNMS.INSTANCE.constructor$ClientboundSetEntityDataPacket(entityIds[1], List.of(ShulkerData.AttachFace.createEntityDataIfNotDefaultValue(CoreReflections.instance$Direction$UP))), false);
                if (interactionEntity) {
                    packets.accept(FastNMS.INSTANCE.constructor$ClientboundAddEntityPacket(entityIds[2], UUID.randomUUID(), x + (double)offset.x, y + (double)offset.y - (double)0.005f - (double)shulkerHeight + (double)scale, z - (double)offset.z, 0.0f, yaw, MEntityTypes.INTERACTION, 0, CoreReflections.instance$Vec3$Zero, 0.0), true);
                    packets.accept(FastNMS.INSTANCE.constructor$ClientboundSetEntityDataPacket(entityIds[2], List.copyOf(cachedInteractionValues)), true);
                    if (canUseOn) {
                        aabb.accept(entityIds[2], AABB.fromInteraction(new Vec3d(x + (double)offset.x, y + (double)offset.y - (double)shulkerHeight + (double)scale, z - (double)offset.z), scale, shulkerHeight));
                    }
                }
            };
            this.aabbCreator = (x, y, z, yaw, offset) -> this.createAABB(Direction.DOWN, offset, x, y, z);
        } else {
            InteractionEntityData.Height.addEntityDataIfNotDefaultValue(Float.valueOf(scale + 0.01f), cachedInteractionValues);
            InteractionEntityData.Width.addEntityDataIfNotDefaultValue(Float.valueOf(scale + 0.005f), cachedInteractionValues);
            InteractionEntityData.Responsive.addEntityDataIfNotDefaultValue(interactive, cachedInteractionValues);
            this.spawner = (entityIds, world, x, y, z, yaw, offset, packets, collider, aabb) -> {
                Direction shulkerAnchor = ShulkerHitBox.getOriginalDirection(direction, Direction.fromYaw(yaw));
                Direction shulkerDirection = shulkerAnchor.opposite();
                collider.accept(this.createCollider(shulkerDirection, world, offset, x, y, z, entityIds[1], aabb));
                packets.accept(FastNMS.INSTANCE.constructor$ClientboundSetEntityDataPacket(entityIds[1], List.of(ShulkerData.AttachFace.createEntityDataIfNotDefaultValue(DirectionUtils.toNMSDirection(shulkerAnchor)))), false);
                if (interactionEntity) {
                    packets.accept(FastNMS.INSTANCE.constructor$ClientboundAddEntityPacket(entityIds[2], UUID.randomUUID(), x + (double)offset.x, y + (double)offset.y - (double)0.005f, z - (double)offset.z, 0.0f, yaw, MEntityTypes.INTERACTION, 0, CoreReflections.instance$Vec3$Zero, 0.0), true);
                    packets.accept(FastNMS.INSTANCE.constructor$ClientboundSetEntityDataPacket(entityIds[2], List.copyOf(cachedInteractionValues)), true);
                    double distance = shulkerHeight - scale;
                    packets.accept(FastNMS.INSTANCE.constructor$ClientboundAddEntityPacket(entityIds[3], UUID.randomUUID(), x + (double)offset.x + (double)shulkerDirection.stepX() * distance, y + (double)offset.y - (double)0.005f, z - (double)offset.z + (double)shulkerDirection.stepZ() * distance, 0.0f, yaw, MEntityTypes.INTERACTION, 0, CoreReflections.instance$Vec3$Zero, 0.0), true);
                    packets.accept(FastNMS.INSTANCE.constructor$ClientboundSetEntityDataPacket(entityIds[3], List.copyOf(cachedInteractionValues)), true);
                    if (canUseOn) {
                        aabb.accept(entityIds[2], AABB.fromInteraction(new Vec3d(x + (double)offset.x, y + (double)offset.y, z - (double)offset.z), scale, scale));
                        aabb.accept(entityIds[3], AABB.fromInteraction(new Vec3d(x + (double)offset.x + (double)shulkerDirection.stepX() * distance, y + (double)offset.y, z - (double)offset.z + (double)shulkerDirection.stepZ() * distance), scale, scale));
                    }
                }
            };
            this.aabbCreator = (x, y, z, yaw, offset) -> {
                Direction shulkerAnchor = ShulkerHitBox.getOriginalDirection(direction, Direction.fromYaw(yaw));
                Direction shulkerDirection = shulkerAnchor.opposite();
                return this.createAABB(shulkerDirection, offset, x, y, z);
            };
        }
    }

    public Collider createCollider(Direction direction, World world, Vector3f offset, double x, double y, double z, int entityId, BiConsumer<Integer, AABB> aabb) {
        AABB ceAABB = this.createAABB(direction, offset, x, y, z);
        Object level = world.serverWorld();
        Object nmsAABB = FastNMS.INSTANCE.constructor$AABB(ceAABB.minX, ceAABB.minY, ceAABB.minZ, ceAABB.maxX, ceAABB.maxY, ceAABB.maxZ);
        aabb.accept(entityId, ceAABB);
        return new BukkitCollider(level, nmsAABB, x, y, z, this.canBeHitByProjectile(), true, this.blocksBuilding());
    }

    public AABB createAABB(Direction direction, Vector3f offset, double x, double y, double z) {
        float peek = ShulkerHitBox.getPhysicalPeek((float)this.peek() * 0.01f);
        double x1 = (double)(-this.scale) * 0.5;
        double y1 = 0.0;
        double z1 = (double)(-this.scale) * 0.5;
        double x2 = (double)this.scale * 0.5;
        double y2 = this.scale;
        double z2 = (double)this.scale * 0.5;
        double dx = (double)direction.stepX() * (double)peek * (double)this.scale;
        if (dx > 0.0) {
            x2 += dx;
        } else if (dx < 0.0) {
            x1 += dx;
        }
        double dy = (double)direction.stepY() * (double)peek * (double)this.scale;
        if (dy > 0.0) {
            y2 += dy;
        } else if (dy < 0.0) {
            y1 += dy;
        }
        double dz = (double)direction.stepZ() * (double)peek * (double)this.scale;
        if (dz > 0.0) {
            z2 += dz;
        } else if (dz < 0.0) {
            z1 += dz;
        }
        double minX = x + x1 + (double)offset.x();
        double maxX = x + x2 + (double)offset.x();
        double minY = y + y1 + (double)offset.y();
        double maxY = y + y2 + (double)offset.y();
        double minZ = z + z1 - (double)offset.z();
        double maxZ = z + z2 - (double)offset.z();
        return new AABB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    private static float getPhysicalPeek(float peek) {
        return 0.5f - MCUtils.sin((0.5f + peek) * (float)Math.PI) * 0.5f;
    }

    public boolean interactionEntity() {
        return this.interactionEntity;
    }

    public boolean interactive() {
        return this.interactive;
    }

    public Direction direction() {
        return this.direction;
    }

    public byte peek() {
        return this.peek;
    }

    public float scale() {
        return this.scale;
    }

    @Override
    public Key type() {
        return HitBoxTypes.SHULKER;
    }

    @Override
    public void initPacketsAndColliders(int[] entityIds, WorldPosition position, Quaternionf conjugated, BiConsumer<Object, Boolean> packets, Consumer<Collider> collider, BiConsumer<Integer, AABB> aabb) {
        Vector3f offset = conjugated.transform(new Vector3f((Vector3fc)this.position()));
        try {
            double x = position.x();
            double y = position.y();
            double z = position.z();
            float yaw = position.xRot();
            double originalY = y + (double)offset.y;
            double integerPart = Math.floor(originalY);
            double fractionalPart = originalY - integerPart;
            double processedY = fractionalPart >= 0.5 ? integerPart + 1.0 : originalY;
            packets.accept(FastNMS.INSTANCE.constructor$ClientboundAddEntityPacket(entityIds[0], UUID.randomUUID(), x + (double)offset.x, originalY, z - (double)offset.z, 0.0f, yaw, MEntityTypes.ITEM_DISPLAY, 0, CoreReflections.instance$Vec3$Zero, 0.0), false);
            packets.accept(FastNMS.INSTANCE.constructor$ClientboundAddEntityPacket(entityIds[1], UUID.randomUUID(), x + (double)offset.x, processedY, z - (double)offset.z, 0.0f, yaw, MEntityTypes.SHULKER, 0, CoreReflections.instance$Vec3$Zero, 0.0), false);
            packets.accept(FastNMS.INSTANCE.constructor$ClientboundSetEntityDataPacket(entityIds[1], List.copyOf(this.cachedShulkerValues)), false);
            packets.accept(FastNMS.INSTANCE.constructor$ClientboundSetPassengersPacket(entityIds[0], entityIds[1]), false);
            if (originalY != processedY) {
                double deltaY = originalY - processedY;
                short ya = (short)(deltaY * 8192.0);
                packets.accept(NetworkReflections.constructor$ClientboundMoveEntityPacket$Pos.newInstance(entityIds[1], (short)0, ya, (short)0, true), false);
            }
            if (VersionHelper.isOrAbove1_20_5() && this.scale != 1.0f) {
                Object attributeInstance = CoreReflections.constructor$AttributeInstance.newInstance(MAttributeHolders.SCALE, o -> {});
                CoreReflections.method$AttributeInstance$setBaseValue.invoke(attributeInstance, Float.valueOf(this.scale));
                packets.accept(NetworkReflections.constructor$ClientboundUpdateAttributesPacket0.newInstance(entityIds[1], Collections.singletonList(attributeInstance)), false);
            }
            this.spawner.accept(entityIds, position.world(), x, y, z, yaw, offset, packets, collider, aabb);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Failed to construct shulker hitbox spawn packet", e);
        }
    }

    @Override
    public void initShapeForPlacement(double x, double y, double z, float yaw, Quaternionf conjugated, Consumer<AABB> aabbs) {
        Vector3f offset = conjugated.transform(new Vector3f((Vector3fc)this.position()));
        aabbs.accept(this.aabbCreator.create(x, y, z, yaw, offset));
    }

    @Override
    public int[] acquireEntityIds(Supplier<Integer> entityIdSupplier) {
        if (this.interactionEntity) {
            if (this.direction.stepY() != 0) {
                return new int[]{entityIdSupplier.get(), entityIdSupplier.get(), entityIdSupplier.get()};
            }
            return new int[]{entityIdSupplier.get(), entityIdSupplier.get(), entityIdSupplier.get(), entityIdSupplier.get()};
        }
        return new int[]{entityIdSupplier.get(), entityIdSupplier.get()};
    }

    public static Direction getOriginalDirection(Direction newDirection, Direction oldDirection) {
        switch (newDirection) {
            case NORTH: {
                return switch (oldDirection) {
                    case Direction.NORTH -> Direction.NORTH;
                    case Direction.SOUTH -> Direction.SOUTH;
                    case Direction.WEST -> Direction.EAST;
                    case Direction.EAST -> Direction.WEST;
                    default -> throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)oldDirection));
                };
            }
            case SOUTH: {
                return switch (oldDirection) {
                    case Direction.SOUTH -> Direction.NORTH;
                    case Direction.WEST -> Direction.WEST;
                    case Direction.EAST -> Direction.EAST;
                    case Direction.NORTH -> Direction.SOUTH;
                    default -> throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)oldDirection));
                };
            }
            case WEST: {
                return switch (oldDirection) {
                    case Direction.SOUTH -> Direction.EAST;
                    case Direction.WEST -> Direction.NORTH;
                    case Direction.EAST -> Direction.SOUTH;
                    case Direction.NORTH -> Direction.WEST;
                    default -> throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)oldDirection));
                };
            }
            case EAST: {
                return switch (oldDirection) {
                    case Direction.SOUTH -> Direction.WEST;
                    case Direction.WEST -> Direction.SOUTH;
                    case Direction.EAST -> Direction.NORTH;
                    case Direction.NORTH -> Direction.EAST;
                    default -> throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)oldDirection));
                };
            }
        }
        throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)newDirection));
    }

    @FunctionalInterface
    static interface DirectionalShulkerSpawner {
        public void accept(int[] var1, World var2, double var3, double var5, double var7, float var9, Vector3f var10, BiConsumer<Object, Boolean> var11, Consumer<Collider> var12, BiConsumer<Integer, AABB> var13);
    }

    @FunctionalInterface
    static interface AABBCreator {
        public AABB create(double var1, double var3, double var5, float var7, Vector3f var8);
    }

    public static class Factory
    implements HitBoxFactory {
        @Override
        public HitBox create(Map<String, Object> arguments) {
            Vector3f position = ResourceConfigUtils.getAsVector3f(arguments.getOrDefault("position", "0"), "position");
            float scale = ResourceConfigUtils.getAsFloat(arguments.getOrDefault("scale", "1"), "scale");
            byte peek = (byte)ResourceConfigUtils.getAsInt(arguments.getOrDefault("peek", 0), "peek");
            Direction directionEnum = Optional.ofNullable(arguments.get("direction")).map(it -> Direction.valueOf(it.toString().toUpperCase(Locale.ENGLISH))).orElse(Direction.UP);
            boolean interactive = ResourceConfigUtils.getAsBoolean(arguments.getOrDefault("interactive", true), "interactive");
            boolean interactionEntity = ResourceConfigUtils.getAsBoolean(arguments.getOrDefault("interaction-entity", true), "interaction-entity");
            boolean canUseItemOn = ResourceConfigUtils.getAsBoolean(arguments.getOrDefault("can-use-item-on", true), "can-use-item-on");
            boolean canBeHitByProjectile = ResourceConfigUtils.getAsBoolean(arguments.getOrDefault("can-be-hit-by-projectile", true), "can-be-hit-by-projectile");
            boolean blocksBuilding = ResourceConfigUtils.getAsBoolean(arguments.getOrDefault("blocks-building", true), "blocks-building");
            return new ShulkerHitBox(HitBoxFactory.getSeats(arguments), position, directionEnum, scale, peek, interactionEntity, interactive, canUseItemOn, blocksBuilding, canBeHitByProjectile);
        }
    }
}

