/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.item;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import net.momirealms.craftengine.bukkit.item.BukkitCustomItem;
import net.momirealms.craftengine.bukkit.item.LegacyNetworkItemHandler;
import net.momirealms.craftengine.bukkit.item.ModernNetworkItemHandler;
import net.momirealms.craftengine.bukkit.item.behavior.AxeItemBehavior;
import net.momirealms.craftengine.bukkit.item.behavior.FlintAndSteelItemBehavior;
import net.momirealms.craftengine.bukkit.item.factory.BukkitItemFactory;
import net.momirealms.craftengine.bukkit.item.listener.ArmorEventListener;
import net.momirealms.craftengine.bukkit.item.listener.DebugStickListener;
import net.momirealms.craftengine.bukkit.item.listener.ItemEventListener;
import net.momirealms.craftengine.bukkit.nms.FastNMS;
import net.momirealms.craftengine.bukkit.plugin.BukkitCraftEngine;
import net.momirealms.craftengine.bukkit.plugin.reflection.minecraft.CoreReflections;
import net.momirealms.craftengine.bukkit.plugin.reflection.minecraft.MBuiltInRegistries;
import net.momirealms.craftengine.bukkit.plugin.reflection.minecraft.MItems;
import net.momirealms.craftengine.bukkit.plugin.reflection.minecraft.MRegistries;
import net.momirealms.craftengine.bukkit.plugin.reflection.minecraft.MRegistryOps;
import net.momirealms.craftengine.bukkit.util.ItemStackUtils;
import net.momirealms.craftengine.bukkit.util.KeyUtils;
import net.momirealms.craftengine.core.entity.player.Player;
import net.momirealms.craftengine.core.item.AbstractItemManager;
import net.momirealms.craftengine.core.item.BuildableItem;
import net.momirealms.craftengine.core.item.CloneableConstantItem;
import net.momirealms.craftengine.core.item.ComponentKeys;
import net.momirealms.craftengine.core.item.CustomItem;
import net.momirealms.craftengine.core.item.ExternalItemSource;
import net.momirealms.craftengine.core.item.Item;
import net.momirealms.craftengine.core.item.ItemBuildContext;
import net.momirealms.craftengine.core.item.ItemKeys;
import net.momirealms.craftengine.core.item.ItemWrapper;
import net.momirealms.craftengine.core.item.NetworkItemHandler;
import net.momirealms.craftengine.core.item.recipe.DatapackRecipeResult;
import net.momirealms.craftengine.core.item.recipe.UniqueIdItem;
import net.momirealms.craftengine.core.plugin.config.Config;
import net.momirealms.craftengine.core.plugin.locale.LocalizedResourceConfigException;
import net.momirealms.craftengine.core.plugin.logger.Debugger;
import net.momirealms.craftengine.core.util.FriendlyByteBuf;
import net.momirealms.craftengine.core.util.GsonHelper;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.UniqueKey;
import net.momirealms.craftengine.core.util.VersionHelper;
import org.bukkit.Bukkit;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BukkitItemManager
extends AbstractItemManager<ItemStack> {
    private static BukkitItemManager instance;
    private final BukkitItemFactory<? extends ItemWrapper<ItemStack>> factory;
    private final BukkitCraftEngine plugin;
    private final ItemEventListener itemEventListener;
    private final DebugStickListener debugStickListener;
    private final ArmorEventListener armorEventListener;
    private final NetworkItemHandler<ItemStack> networkItemHandler;
    private final Object bedrockItemHolder;
    private final Item<ItemStack> emptyItem;
    private final UniqueIdItem<ItemStack> emptyUniqueItem;
    private final Function<Object, Integer> decoratedHashOpsGenerator;
    private Set<Key> lastRegisteredPatterns = Set.of();

    public BukkitItemManager(BukkitCraftEngine plugin) {
        super(plugin);
        instance = this;
        this.plugin = plugin;
        this.factory = BukkitItemFactory.create(plugin);
        this.itemEventListener = new ItemEventListener(plugin, this);
        this.debugStickListener = new DebugStickListener(plugin);
        this.armorEventListener = new ArmorEventListener();
        this.networkItemHandler = VersionHelper.isOrAbove1_20_5() ? new ModernNetworkItemHandler() : new LegacyNetworkItemHandler();
        this.registerAllVanillaItems();
        this.bedrockItemHolder = FastNMS.INSTANCE.method$Registry$getHolderByResourceKey(MBuiltInRegistries.ITEM, FastNMS.INSTANCE.method$ResourceKey$create(MRegistries.ITEM, KeyUtils.toResourceLocation(Key.of("minecraft:bedrock")))).get();
        this.registerCustomTrimMaterial();
        this.loadLastRegisteredPatterns();
        ItemStack emptyStack = FastNMS.INSTANCE.method$CraftItemStack$asCraftMirror(CoreReflections.instance$ItemStack$EMPTY);
        this.emptyItem = this.factory.wrap(emptyStack);
        this.emptyUniqueItem = UniqueIdItem.of(this.emptyItem);
        this.decoratedHashOpsGenerator = VersionHelper.isOrAbove1_21_5() ? (Function)FastNMS.INSTANCE.createDecoratedHashOpsGenerator(MRegistryOps.HASHCODE) : null;
    }

    @Override
    public void delayedLoad() {
        super.delayedLoad();
        ArrayList sources = new ArrayList();
        for (String externalSource : Config.recipeIngredientSources()) {
            String sourceId = externalSource.toLowerCase(Locale.ENGLISH);
            ExternalItemSource provider = this.getExternalItemSource(sourceId);
            if (provider == null) continue;
            sources.add(provider);
        }
        this.factory.resetRecipeIngredientSources(sources.isEmpty() ? null : sources.toArray(new ExternalItemSource[0]));
    }

    @Override
    public UniqueIdItem<ItemStack> uniqueEmptyItem() {
        return this.emptyUniqueItem;
    }

    @Override
    public void delayedInit() {
        Bukkit.getPluginManager().registerEvents((Listener)this.itemEventListener, (Plugin)this.plugin.javaPlugin());
        Bukkit.getPluginManager().registerEvents((Listener)this.debugStickListener, (Plugin)this.plugin.javaPlugin());
        Bukkit.getPluginManager().registerEvents((Listener)this.armorEventListener, (Plugin)this.plugin.javaPlugin());
    }

    @Override
    public Item<ItemStack> decode(FriendlyByteBuf byteBuf) {
        Object friendlyBuf = FastNMS.INSTANCE.constructor$FriendlyByteBuf(byteBuf);
        return this.wrap(FastNMS.INSTANCE.method$FriendlyByteBuf$readItem(friendlyBuf));
    }

    @Override
    public void encode(FriendlyByteBuf byteBuf, Item<ItemStack> item) {
        FastNMS.INSTANCE.method$FriendlyByteBuf$writeItem(FastNMS.INSTANCE.constructor$FriendlyByteBuf(byteBuf), item.getItem());
    }

    @Override
    public NetworkItemHandler<ItemStack> networkItemHandler() {
        return this.networkItemHandler;
    }

    public static BukkitItemManager instance() {
        return instance;
    }

    @Override
    public Item<ItemStack> s2c(Item<ItemStack> item, Player player) {
        if (item.isEmpty()) {
            return item;
        }
        return this.networkItemHandler.s2c(item, player).orElse(item);
    }

    @Override
    public Item<ItemStack> c2s(Item<ItemStack> item) {
        if (item.isEmpty()) {
            return item;
        }
        return this.networkItemHandler.c2s(item).orElse(item);
    }

    public Optional<ItemStack> s2c(ItemStack itemStack, Player player) {
        try {
            Item<ItemStack> wrapped = this.wrap(itemStack);
            if (wrapped.isEmpty()) {
                return Optional.empty();
            }
            return this.networkItemHandler.s2c(wrapped, player).map(Item::getItem);
        }
        catch (Throwable e) {
            Debugger.ITEM.warn(() -> "Failed to handle s2c items.", e);
            return Optional.empty();
        }
    }

    public Optional<ItemStack> c2s(ItemStack itemStack) {
        try {
            Item<ItemStack> wrapped = this.wrap(itemStack);
            if (wrapped.isEmpty()) {
                return Optional.empty();
            }
            return this.networkItemHandler.c2s(wrapped).map(Item::getItem);
        }
        catch (Throwable e) {
            Debugger.COMMON.warn(() -> "Failed to handle c2s items.", e);
            return Optional.empty();
        }
    }

    @Override
    public Item<ItemStack> build(DatapackRecipeResult result) {
        if (result.components() == null) {
            ItemStack itemStack = this.createVanillaItemStack(Key.of(result.id()));
            return this.wrap(itemStack).count(result.count());
        }
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("id", result.id());
        jsonObject.addProperty("count", (Number)result.count());
        jsonObject.add("components", (JsonElement)result.components());
        Object nmsStack = CoreReflections.instance$ItemStack$CODEC.parse(MRegistryOps.JSON, (Object)jsonObject).resultOrPartial(itemId -> this.plugin.logger().severe("Tried to load invalid item: '" + itemId + "'")).orElse(null);
        if (nmsStack == null) {
            return this.emptyItem;
        }
        return this.wrap(FastNMS.INSTANCE.method$CraftItemStack$asCraftMirror(nmsStack));
    }

    @Override
    public Optional<BuildableItem<ItemStack>> getVanillaItem(Key key) {
        ItemStack vanilla = this.createVanillaItemStack(key);
        if (vanilla == null) {
            return Optional.empty();
        }
        return Optional.of(CloneableConstantItem.of(this.wrap(vanilla)));
    }

    @Override
    public int fuelTime(ItemStack itemStack) {
        if (ItemStackUtils.isEmpty(itemStack)) {
            return 0;
        }
        Optional<CustomItem<ItemStack>> customItem = this.wrap(itemStack).getCustomItem();
        return customItem.map(it -> it.settings().fuelTime()).orElse(0);
    }

    @Override
    public int fuelTime(Key id) {
        return this.getCustomItem(id).map(it -> it.settings().fuelTime()).orElse(0);
    }

    @Override
    public void disable() {
        this.unload();
        HandlerList.unregisterAll((Listener)this.itemEventListener);
        HandlerList.unregisterAll((Listener)this.debugStickListener);
        HandlerList.unregisterAll((Listener)this.armorEventListener);
        this.persistLastRegisteredPatterns();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void registerArmorTrimPattern(Collection<Key> equipments) {
        if (equipments.isEmpty()) {
            return;
        }
        this.lastRegisteredPatterns = new HashSet<Key>(equipments);
        if (Config.sacrificedAssetId() != null) {
            this.lastRegisteredPatterns.add(Config.sacrificedAssetId());
        }
        Object registry = FastNMS.INSTANCE.method$RegistryAccess$lookupOrThrow(FastNMS.INSTANCE.registryAccess(), MRegistries.TRIM_PATTERN);
        try {
            CoreReflections.field$MappedRegistry$frozen.set(registry, false);
            for (Key assetId : this.lastRegisteredPatterns) {
                Object resourceLocation = KeyUtils.toResourceLocation(assetId);
                Object previous = FastNMS.INSTANCE.method$Registry$getValue(registry, resourceLocation);
                if (previous != null) continue;
                Object trimPattern = this.createTrimPattern(assetId);
                Object holder = CoreReflections.method$Registry$registerForHolder.invoke(null, registry, resourceLocation, trimPattern);
                CoreReflections.method$Holder$Reference$bindValue.invoke(holder, trimPattern);
                CoreReflections.field$Holder$Reference$tags.set(holder, Set.of());
            }
        }
        catch (Exception e) {
            this.plugin.logger().warn("Failed to register armor trim pattern.", e);
        }
        finally {
            try {
                CoreReflections.field$MappedRegistry$frozen.set(registry, true);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {}
        }
    }

    private void persistLastRegisteredPatterns() {
        Path persistTrimPatternPath = this.plugin.dataFolderPath().resolve("cache").resolve("trim_patterns.json");
        try {
            Files.createDirectories(persistTrimPatternPath.getParent(), new FileAttribute[0]);
            JsonObject json = new JsonObject();
            JsonArray jsonElements = new JsonArray();
            for (Key key : this.lastRegisteredPatterns) {
                jsonElements.add((JsonElement)new JsonPrimitive(key.toString()));
            }
            json.add("patterns", (JsonElement)jsonElements);
            if (jsonElements.isEmpty()) {
                if (Files.exists(persistTrimPatternPath, new LinkOption[0])) {
                    Files.delete(persistTrimPatternPath);
                }
            } else {
                GsonHelper.writeJsonFile((JsonElement)json, persistTrimPatternPath);
            }
        }
        catch (IOException e) {
            this.plugin.logger().warn("Failed to persist registered trim patterns.", e);
        }
    }

    private void loadLastRegisteredPatterns() {
        Path persistTrimPatternPath = this.plugin.dataFolderPath().resolve("cache").resolve("trim_patterns.json");
        if (Files.exists(persistTrimPatternPath, new LinkOption[0]) && Files.isRegularFile(persistTrimPatternPath, new LinkOption[0])) {
            try {
                JsonObject cache = GsonHelper.readJsonFile(persistTrimPatternPath).getAsJsonObject();
                JsonArray patterns = cache.getAsJsonArray("patterns");
                HashSet<Key> trims = new HashSet<Key>();
                for (JsonElement element : patterns) {
                    if (!(element instanceof JsonPrimitive)) continue;
                    JsonPrimitive primitive = (JsonPrimitive)element;
                    trims.add(Key.of(primitive.getAsString()));
                }
                this.registerArmorTrimPattern(trims);
                this.lastRegisteredPatterns = trims;
            }
            catch (IOException e) {
                this.plugin.logger().warn("Failed to load registered trim patterns.", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerCustomTrimMaterial() {
        Object resourceLocation;
        Object registry = FastNMS.INSTANCE.method$RegistryAccess$lookupOrThrow(FastNMS.INSTANCE.registryAccess(), MRegistries.TRIM_MATERIAL);
        Object previous = FastNMS.INSTANCE.method$Registry$getValue(registry, resourceLocation = KeyUtils.toResourceLocation(Key.of("minecraft", "custom")));
        if (previous == null) {
            try {
                CoreReflections.field$MappedRegistry$frozen.set(registry, false);
                Object trimMaterial = this.createTrimMaterial();
                Object holder = CoreReflections.method$Registry$registerForHolder.invoke(null, registry, resourceLocation, trimMaterial);
                CoreReflections.method$Holder$Reference$bindValue.invoke(holder, trimMaterial);
                CoreReflections.field$Holder$Reference$tags.set(holder, Set.of());
            }
            catch (Exception e) {
                this.plugin.logger().warn("Failed to register trim material.", e);
            }
            finally {
                try {
                    CoreReflections.field$MappedRegistry$frozen.set(registry, true);
                }
                catch (ReflectiveOperationException reflectiveOperationException) {}
            }
        }
    }

    private Object createTrimPattern(Key key) throws ReflectiveOperationException {
        if (VersionHelper.isOrAbove1_21_5()) {
            return CoreReflections.constructor$TrimPattern.newInstance(KeyUtils.toResourceLocation(key), CoreReflections.instance$Component$empty, false);
        }
        if (VersionHelper.isOrAbove1_20_2()) {
            return CoreReflections.constructor$TrimPattern.newInstance(KeyUtils.toResourceLocation(key), this.bedrockItemHolder, CoreReflections.instance$Component$empty, false);
        }
        return CoreReflections.constructor$TrimPattern.newInstance(KeyUtils.toResourceLocation(key), this.bedrockItemHolder, CoreReflections.instance$Component$empty);
    }

    private Object createTrimMaterial() throws ReflectiveOperationException {
        if (VersionHelper.isOrAbove1_21_5()) {
            Object assetGroup = CoreReflections.method$MaterialAssetGroup$create.invoke(null, "custom");
            return CoreReflections.constructor$TrimMaterial.newInstance(assetGroup, CoreReflections.instance$Component$empty);
        }
        if (VersionHelper.isOrAbove1_21_4()) {
            return CoreReflections.constructor$TrimMaterial.newInstance("custom", this.bedrockItemHolder, Map.of(), CoreReflections.instance$Component$empty);
        }
        return CoreReflections.constructor$TrimMaterial.newInstance("custom", this.bedrockItemHolder, Float.valueOf(0.0f), Map.of(), CoreReflections.instance$Component$empty);
    }

    @Override
    public Item<ItemStack> fromByteArray(byte[] bytes) {
        return this.factory.wrap(Bukkit.getUnsafe().deserializeItem(bytes));
    }

    @Override
    public ItemStack buildCustomItemStack(Key id, Player player) {
        return Optional.ofNullable((CustomItem)this.customItemsById.get(id)).map(it -> (ItemStack)it.buildItemStack(ItemBuildContext.of(player), 1)).orElse(null);
    }

    @Override
    public ItemStack buildItemStack(Key id, @Nullable Player player) {
        ItemStack customItem = this.buildCustomItemStack(id, player);
        if (customItem != null) {
            return customItem;
        }
        return this.createVanillaItemStack(id);
    }

    @Override
    public Item<ItemStack> createCustomWrappedItem(Key id, Player player) {
        return Optional.ofNullable((CustomItem)this.customItemsById.get(id)).map(it -> it.buildItem(player)).orElse(null);
    }

    @Override
    public Item<ItemStack> createWrappedItem(Key id, @Nullable Player player) {
        CustomItem customItem = (CustomItem)this.customItemsById.get(id);
        if (customItem != null) {
            return customItem.buildItem(player);
        }
        ItemStack itemStack = this.createVanillaItemStack(id);
        if (itemStack != null) {
            return this.wrap(itemStack);
        }
        return null;
    }

    @Nullable
    private ItemStack createVanillaItemStack(Key id) {
        Object item = FastNMS.INSTANCE.method$Registry$getValue(MBuiltInRegistries.ITEM, KeyUtils.toResourceLocation(id));
        if (item == MItems.AIR && !id.equals(ItemKeys.AIR)) {
            return null;
        }
        return FastNMS.INSTANCE.method$CraftItemStack$asCraftMirror(FastNMS.INSTANCE.constructor$ItemStack(item, 1));
    }

    @Override
    @NotNull
    public Item<ItemStack> wrap(ItemStack itemStack) {
        if (itemStack == null || itemStack.isEmpty()) {
            return this.emptyItem;
        }
        return this.factory.wrap(itemStack);
    }

    @Override
    protected CustomItem.Builder<ItemStack> createPlatformItemBuilder(UniqueKey id, Key materialId, Key clientBoundMaterialId) {
        Object clientBoundItem;
        Object item = FastNMS.INSTANCE.method$Registry$getValue(MBuiltInRegistries.ITEM, KeyUtils.toResourceLocation(materialId));
        Object object = clientBoundItem = materialId == clientBoundMaterialId ? item : FastNMS.INSTANCE.method$Registry$getValue(MBuiltInRegistries.ITEM, KeyUtils.toResourceLocation(clientBoundMaterialId));
        if (item == MItems.AIR) {
            throw new LocalizedResourceConfigException("warning.config.item.invalid_material", materialId.toString());
        }
        if (clientBoundItem == MItems.AIR) {
            throw new LocalizedResourceConfigException("warning.config.item.invalid_material", clientBoundMaterialId.toString());
        }
        return BukkitCustomItem.builder(item, clientBoundItem).id(id).material(materialId).clientBoundMaterial(clientBoundMaterialId);
    }

    private void registerAllVanillaItems() {
        try {
            for (Object item : (Iterable)MBuiltInRegistries.ITEM) {
                Object resourceLocation = FastNMS.INSTANCE.method$Registry$getKey(MBuiltInRegistries.ITEM, item);
                Key itemKey = KeyUtils.resourceLocationToKey(resourceLocation);
                VANILLA_ITEMS.add(itemKey);
                UniqueKey uniqueKey = UniqueKey.create(itemKey);
                Object mcHolder = FastNMS.INSTANCE.method$Registry$getHolderByResourceKey(MBuiltInRegistries.ITEM, FastNMS.INSTANCE.method$ResourceKey$create(MRegistries.ITEM, resourceLocation)).get();
                Set tags = (Set)CoreReflections.field$Holder$Reference$tags.get(mcHolder);
                for (Object tag : tags) {
                    Key tagId = Key.of(CoreReflections.field$TagKey$location.get(tag).toString());
                    VANILLA_ITEM_TAGS.computeIfAbsent(tagId, key -> new ArrayList()).add(uniqueKey);
                }
            }
        }
        catch (ReflectiveOperationException e) {
            this.plugin.logger().warn("Failed to init vanilla items", e);
        }
    }

    @Override
    public Item<ItemStack> applyTrim(Item<ItemStack> base, Item<ItemStack> addition, Item<ItemStack> template, Key pattern) {
        Optional<Object> optionalPattern;
        Optional optionalMaterial = FastNMS.INSTANCE.method$TrimMaterials$getFromIngredient(addition.getLiteralObject());
        Optional<Object> optional = optionalPattern = VersionHelper.isOrAbove1_21_5() ? FastNMS.INSTANCE.method$Registry$getHolderByResourceLocation(FastNMS.INSTANCE.method$RegistryAccess$lookupOrThrow(FastNMS.INSTANCE.registryAccess(), MRegistries.TRIM_PATTERN), KeyUtils.toResourceLocation(pattern)) : FastNMS.INSTANCE.method$TrimPatterns$getFromTemplate(template.getLiteralObject());
        if (optionalMaterial.isPresent() && optionalPattern.isPresent()) {
            Object previousTrim;
            Object armorTrim = FastNMS.INSTANCE.constructor$ArmorTrim(optionalMaterial.get(), optionalPattern.get());
            if (VersionHelper.isOrAbove1_20_5()) {
                previousTrim = base.getExactComponent(ComponentKeys.TRIM);
            } else {
                try {
                    previousTrim = VersionHelper.isOrAbove1_20_2() ? ((Optional)CoreReflections.method$ArmorTrim$getTrim.invoke(null, FastNMS.INSTANCE.registryAccess(), base.getLiteralObject(), true)).orElse(null) : ((Optional)CoreReflections.method$ArmorTrim$getTrim.invoke(null, FastNMS.INSTANCE.registryAccess(), base.getLiteralObject())).orElse(null);
                }
                catch (ReflectiveOperationException e) {
                    this.plugin.logger().warn("Failed to get armor trim", e);
                    return this.emptyItem;
                }
            }
            if (armorTrim.equals(previousTrim)) {
                return this.emptyItem;
            }
            Item<ItemStack> newItem = base.copyWithCount(1);
            if (VersionHelper.isOrAbove1_20_5()) {
                newItem.setExactComponent(ComponentKeys.TRIM, armorTrim);
            } else {
                try {
                    CoreReflections.method$ArmorTrim$setTrim.invoke(null, FastNMS.INSTANCE.registryAccess(), newItem.getLiteralObject(), armorTrim);
                }
                catch (ReflectiveOperationException e) {
                    this.plugin.logger().warn("Failed to set armor trim", e);
                    return this.emptyItem;
                }
            }
            return newItem;
        }
        return this.emptyItem;
    }

    @Nullable
    public Function<Object, Integer> decoratedHashOpsGenerator() {
        return this.decoratedHashOpsGenerator;
    }

    static {
        BukkitItemManager.registerVanillaItemExtraBehavior(FlintAndSteelItemBehavior.INSTANCE, ItemKeys.FLINT_AND_STEEL);
        BukkitItemManager.registerVanillaItemExtraBehavior(AxeItemBehavior.INSTANCE, ItemKeys.AXES);
    }
}

