/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.item;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.momirealms.craftengine.bukkit.item.BukkitCustomItem;
import net.momirealms.craftengine.bukkit.nms.FastNMS;
import net.momirealms.craftengine.core.entity.player.Player;
import net.momirealms.craftengine.core.item.CustomItem;
import net.momirealms.craftengine.core.item.Item;
import net.momirealms.craftengine.core.item.ItemBuildContext;
import net.momirealms.craftengine.core.item.NetworkItemHandler;
import net.momirealms.craftengine.core.item.modifier.ItemDataModifier;
import net.momirealms.craftengine.core.plugin.CraftEngine;
import net.momirealms.craftengine.core.plugin.config.Config;
import net.momirealms.craftengine.core.plugin.context.Context;
import net.momirealms.craftengine.core.plugin.context.ContextHolder;
import net.momirealms.craftengine.core.plugin.context.ContextKey;
import net.momirealms.craftengine.core.plugin.context.NetworkTextReplaceContext;
import net.momirealms.craftengine.core.plugin.text.component.ComponentProvider;
import net.momirealms.craftengine.core.util.AdventureHelper;
import net.momirealms.craftengine.libraries.nbt.CompoundTag;
import net.momirealms.craftengine.libraries.nbt.ListTag;
import net.momirealms.craftengine.libraries.nbt.StringTag;
import net.momirealms.craftengine.libraries.nbt.Tag;
import org.bukkit.inventory.ItemStack;

public final class LegacyNetworkItemHandler
implements NetworkItemHandler<ItemStack> {
    @Override
    public Optional<Item<ItemStack>> c2s(Item<ItemStack> wrapped) {
        BukkitCustomItem customItem;
        Optional<CustomItem<ItemStack>> optionalCustomItem = wrapped.getCustomItem();
        boolean hasDifferentMaterial = false;
        if (optionalCustomItem.isPresent() && (customItem = (BukkitCustomItem)optionalCustomItem.get()).item() != FastNMS.INSTANCE.method$ItemStack$getItem(wrapped.getLiteralObject())) {
            wrapped = wrapped.unsafeTransmuteCopy(customItem.item(), wrapped.count());
            hasDifferentMaterial = true;
        }
        if (!wrapped.hasTag("craftengine:network_modifiers") && hasDifferentMaterial) {
            return Optional.of(wrapped);
        }
        CompoundTag networkData = (CompoundTag)wrapped.getTag("craftengine:network_modifiers");
        if (networkData == null) {
            return Optional.empty();
        }
        wrapped.removeTag("craftengine:network_modifiers");
        for (Map.Entry<String, Tag> entry : networkData.entrySet()) {
            Tag tag = entry.getValue();
            if (!(tag instanceof CompoundTag)) continue;
            CompoundTag tag2 = (CompoundTag)tag;
            NetworkItemHandler.apply(entry.getKey(), tag2, wrapped);
        }
        return Optional.of(wrapped);
    }

    @Override
    public Optional<Item<ItemStack>> s2c(Item<ItemStack> wrapped, Player player) {
        ItemBuildContext context;
        boolean hasDifferentMaterial;
        Optional<CustomItem<ItemStack>> optionalCustomItem = wrapped.getCustomItem();
        if (optionalCustomItem.isEmpty()) {
            if (!Config.interceptItem()) {
                return Optional.empty();
            }
            return new OtherItem(wrapped, false).process(NetworkTextReplaceContext.of(player));
        }
        BukkitCustomItem customItem = (BukkitCustomItem)optionalCustomItem.get();
        Object serverItem = FastNMS.INSTANCE.method$ItemStack$getItem(wrapped.getLiteralObject());
        boolean bl = hasDifferentMaterial = serverItem == customItem.item() && serverItem != customItem.clientItem();
        if (hasDifferentMaterial) {
            wrapped = wrapped.unsafeTransmuteCopy(customItem.clientItem(), wrapped.count());
        }
        if (!customItem.hasClientBoundDataModifier()) {
            if (!Config.interceptItem() && !hasDifferentMaterial) {
                return Optional.empty();
            }
            return new OtherItem(wrapped, hasDifferentMaterial).process(NetworkTextReplaceContext.of(player));
        }
        CompoundTag tag = new CompoundTag();
        Tag argumentTag = wrapped.getTag("craftengine:arguments");
        if (argumentTag instanceof CompoundTag) {
            CompoundTag arguments = (CompoundTag)argumentTag;
            ContextHolder.Builder builder = ContextHolder.builder();
            for (Map.Entry<String, Tag> entry : arguments.entrySet()) {
                builder.withParameter(ContextKey.direct(entry.getKey()), entry.getValue().getAsString());
            }
            context = ItemBuildContext.of(player, builder);
        } else {
            context = ItemBuildContext.of(player);
        }
        for (ItemDataModifier<ItemStack> itemDataModifier : customItem.clientBoundDataModifiers()) {
            itemDataModifier.prepareNetworkItem(wrapped, context, tag);
        }
        for (ItemDataModifier<ItemStack> itemDataModifier : customItem.clientBoundDataModifiers()) {
            itemDataModifier.apply(wrapped, context);
        }
        if (Config.interceptItem()) {
            if (!tag.containsKey("display.Name")) {
                LegacyNetworkItemHandler.processCustomName(wrapped, tag::put, context);
            }
            if (!tag.containsKey("display.Lore")) {
                LegacyNetworkItemHandler.processLore(wrapped, tag::put, context);
            }
        }
        if (tag.isEmpty()) {
            if (hasDifferentMaterial) {
                return Optional.of(wrapped);
            }
            return Optional.empty();
        }
        wrapped.setTag(tag, "craftengine:network_modifiers");
        return Optional.of(wrapped);
    }

    public static boolean processCustomName(Item<ItemStack> item, BiConsumer<String, CompoundTag> callback, Context context) {
        Optional<String> optionalCustomName = item.customNameJson();
        if (optionalCustomName.isPresent()) {
            String line = optionalCustomName.get();
            Map<String, ComponentProvider> tokens = CraftEngine.instance().fontManager().matchTags(line);
            if (!tokens.isEmpty()) {
                item.customNameJson(AdventureHelper.componentToJson(AdventureHelper.replaceText(AdventureHelper.jsonToComponent(line), tokens, context)));
                callback.accept("display.Name", NetworkItemHandler.pack(NetworkItemHandler.Operation.ADD, new StringTag(line)));
                return true;
            }
        }
        return false;
    }

    private static boolean processLore(Item<ItemStack> item, BiConsumer<String, CompoundTag> callback, Context context) {
        Optional<List<String>> optionalLore = item.loreJson();
        if (optionalLore.isPresent()) {
            boolean changed = false;
            List<String> lore = optionalLore.get();
            ArrayList<String> newLore = new ArrayList<String>(lore.size());
            for (String line : lore) {
                Map<String, ComponentProvider> tokens = CraftEngine.instance().fontManager().matchTags(line);
                if (tokens.isEmpty()) {
                    newLore.add(line);
                    continue;
                }
                newLore.add(AdventureHelper.componentToJson(AdventureHelper.replaceText(AdventureHelper.jsonToComponent(line), tokens, context)));
                changed = true;
            }
            if (changed) {
                item.loreJson(newLore);
                ListTag listTag = new ListTag();
                for (String line : lore) {
                    listTag.add(new StringTag(line));
                }
                callback.accept("display.Lore", NetworkItemHandler.pack(NetworkItemHandler.Operation.ADD, listTag));
                return true;
            }
        }
        return false;
    }

    static class OtherItem {
        private final Item<ItemStack> item;
        private boolean globalChanged = false;
        private CompoundTag networkTag;
        private final boolean forceReturn;

        public OtherItem(Item<ItemStack> item, boolean forceReturn) {
            this.item = item;
            this.forceReturn = forceReturn;
        }

        public Optional<Item<ItemStack>> process(Context context) {
            if (LegacyNetworkItemHandler.processLore(this.item, (s, c) -> this.networkTag().put((String)s, (Tag)c), context)) {
                this.globalChanged = true;
            }
            if (LegacyNetworkItemHandler.processCustomName(this.item, (s, c) -> this.networkTag().put((String)s, (Tag)c), context)) {
                this.globalChanged = true;
            }
            if (this.globalChanged) {
                this.item.setTag(this.networkTag, "craftengine:network_modifiers");
                return Optional.of(this.item);
            }
            if (this.forceReturn) {
                return Optional.of(this.item);
            }
            return Optional.empty();
        }

        public CompoundTag networkTag() {
            if (this.networkTag == null) {
                this.networkTag = new CompoundTag();
            }
            return this.networkTag;
        }
    }
}

