/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.item.listener;

import io.papermc.paper.event.block.CompostItemEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.momirealms.craftengine.bukkit.api.BukkitAdaptors;
import net.momirealms.craftengine.bukkit.api.event.CustomBlockInteractEvent;
import net.momirealms.craftengine.bukkit.entity.BukkitEntity;
import net.momirealms.craftengine.bukkit.item.BukkitCustomItem;
import net.momirealms.craftengine.bukkit.item.BukkitItemManager;
import net.momirealms.craftengine.bukkit.nms.FastNMS;
import net.momirealms.craftengine.bukkit.plugin.BukkitCraftEngine;
import net.momirealms.craftengine.bukkit.plugin.reflection.minecraft.CoreReflections;
import net.momirealms.craftengine.bukkit.plugin.user.BukkitServerPlayer;
import net.momirealms.craftengine.bukkit.util.BlockStateUtils;
import net.momirealms.craftengine.bukkit.util.DamageCauseUtils;
import net.momirealms.craftengine.bukkit.util.DirectionUtils;
import net.momirealms.craftengine.bukkit.util.EventUtils;
import net.momirealms.craftengine.bukkit.util.InteractUtils;
import net.momirealms.craftengine.bukkit.util.ItemStackUtils;
import net.momirealms.craftengine.bukkit.util.LocationUtils;
import net.momirealms.craftengine.bukkit.world.BukkitExistingBlock;
import net.momirealms.craftengine.core.block.BlockBehavior;
import net.momirealms.craftengine.core.block.CustomBlock;
import net.momirealms.craftengine.core.block.ImmutableBlockState;
import net.momirealms.craftengine.core.block.behavior.AbstractBlockBehavior;
import net.momirealms.craftengine.core.entity.player.InteractionHand;
import net.momirealms.craftengine.core.entity.player.InteractionResult;
import net.momirealms.craftengine.core.entity.player.Player;
import net.momirealms.craftengine.core.item.CustomItem;
import net.momirealms.craftengine.core.item.Item;
import net.momirealms.craftengine.core.item.ItemBuildContext;
import net.momirealms.craftengine.core.item.behavior.ItemBehavior;
import net.momirealms.craftengine.core.item.context.UseOnContext;
import net.momirealms.craftengine.core.item.setting.FoodData;
import net.momirealms.craftengine.core.item.updater.ItemUpdateResult;
import net.momirealms.craftengine.core.plugin.config.Config;
import net.momirealms.craftengine.core.plugin.context.ContextHolder;
import net.momirealms.craftengine.core.plugin.context.PlayerOptionalContext;
import net.momirealms.craftengine.core.plugin.context.event.EventTrigger;
import net.momirealms.craftengine.core.plugin.context.parameter.DirectContextParameters;
import net.momirealms.craftengine.core.sound.SoundData;
import net.momirealms.craftengine.core.sound.SoundSource;
import net.momirealms.craftengine.core.util.Cancellable;
import net.momirealms.craftengine.core.util.Direction;
import net.momirealms.craftengine.core.util.ItemUtils;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.MCUtils;
import net.momirealms.craftengine.core.util.RandomUtils;
import net.momirealms.craftengine.core.util.VersionHelper;
import net.momirealms.craftengine.core.world.BlockHitResult;
import net.momirealms.craftengine.core.world.BlockPos;
import net.momirealms.craftengine.core.world.Vec3d;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Openable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.enchantment.PrepareItemEnchantEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.inventory.EnchantingInventory;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class ItemEventListener
implements Listener {
    private final BukkitCraftEngine plugin;
    private final BukkitItemManager itemManager;

    public ItemEventListener(BukkitCraftEngine plugin, BukkitItemManager itemManager) {
        this.plugin = plugin;
        this.itemManager = itemManager;
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onInteractEntity(PlayerInteractEntityEvent event) {
        org.bukkit.entity.Player player = event.getPlayer();
        Entity entity = event.getRightClicked();
        BukkitServerPlayer serverPlayer = BukkitAdaptors.adapt(player);
        if (serverPlayer == null) {
            return;
        }
        InteractionHand hand = event.getHand() == EquipmentSlot.HAND ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        serverPlayer.updateLastInteractEntityTick(hand);
        Item<ItemStack> itemInHand = serverPlayer.getItemInHand(hand);
        if (ItemUtils.isEmpty(itemInHand)) {
            return;
        }
        Optional<CustomItem<ItemStack>> optionalCustomItem = itemInHand.getCustomItem();
        if (optionalCustomItem.isEmpty()) {
            return;
        }
        if (InteractUtils.isEntityInteractable(player, entity, itemInHand)) {
            return;
        }
        Cancellable cancellable = Cancellable.of(() -> ((PlayerInteractEntityEvent)event).isCancelled(), arg_0 -> ((PlayerInteractEntityEvent)event).setCancelled(arg_0));
        PlayerOptionalContext context = PlayerOptionalContext.of((Player)serverPlayer, ContextHolder.builder().withOptionalParameter(DirectContextParameters.ITEM_IN_HAND, itemInHand).withParameter(DirectContextParameters.HAND, hand).withParameter(DirectContextParameters.EVENT, cancellable).withParameter(DirectContextParameters.ENTITY, new BukkitEntity(entity)).withParameter(DirectContextParameters.POSITION, LocationUtils.toWorldPosition(event.getRightClicked().getLocation())));
        CustomItem<ItemStack> customItem = optionalCustomItem.get();
        customItem.execute(context, EventTrigger.RIGHT_CLICK);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onInteractBlock(PlayerInteractEvent event) {
        InteractionResult result;
        InteractionHand hand;
        Action action = event.getAction();
        org.bukkit.entity.Player player = event.getPlayer();
        if (action != Action.LEFT_CLICK_BLOCK && action != Action.RIGHT_CLICK_BLOCK || player.getGameMode() == GameMode.SPECTATOR || action == Action.LEFT_CLICK_BLOCK && player.getGameMode() == GameMode.CREATIVE) {
            return;
        }
        BukkitServerPlayer serverPlayer = BukkitAdaptors.adapt(player);
        if (serverPlayer == null) {
            return;
        }
        InteractionHand interactionHand = hand = event.getHand() == EquipmentSlot.HAND ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        if (this.cancelEventIfHasInteraction(event, serverPlayer, hand)) {
            return;
        }
        Block block = Objects.requireNonNull(event.getClickedBlock());
        BlockData blockData = block.getBlockData();
        Object blockState = BlockStateUtils.blockDataToBlockState(blockData);
        ImmutableBlockState immutableBlockState = BlockStateUtils.getOptionalCustomBlockState(blockState).orElse(null);
        Item<ItemStack> itemInHand = serverPlayer.getItemInHand(hand);
        Location interactionPoint = event.getInteractionPoint();
        BlockHitResult hitResult = null;
        if (action == Action.RIGHT_CLICK_BLOCK && interactionPoint != null) {
            Direction direction = DirectionUtils.toDirection(event.getBlockFace());
            BlockPos pos = LocationUtils.toBlockPos(block.getLocation());
            Vec3d vec3d = new Vec3d(interactionPoint.getX(), interactionPoint.getY(), interactionPoint.getZ());
            hitResult = new BlockHitResult(vec3d, direction, pos, false);
        }
        if (immutableBlockState != null) {
            CustomBlockInteractEvent interactEvent = new CustomBlockInteractEvent(player, block.getLocation(), interactionPoint, immutableBlockState, block, event.getBlockFace(), hand, action.isRightClick() ? CustomBlockInteractEvent.Action.RIGHT_CLICK : CustomBlockInteractEvent.Action.LEFT_CLICK, event.getItem());
            if (EventUtils.fireAndCheckCancel((Event)interactEvent)) {
                event.setCancelled(true);
                return;
            }
            if (action.isRightClick() && hitResult != null && InteractUtils.willConsume(player, BlockStateUtils.fromBlockData(immutableBlockState.vanillaBlockState().literalObject()), hitResult, itemInHand)) {
                player.updateInventory();
            }
            Cancellable dummy = Cancellable.dummy();
            CustomBlock customBlock = immutableBlockState.owner().value();
            PlayerOptionalContext context = PlayerOptionalContext.of((Player)serverPlayer, ContextHolder.builder().withParameter(DirectContextParameters.BLOCK, new BukkitExistingBlock(block)).withParameter(DirectContextParameters.CUSTOM_BLOCK_STATE, immutableBlockState).withParameter(DirectContextParameters.HAND, hand).withParameter(DirectContextParameters.EVENT, dummy).withParameter(DirectContextParameters.POSITION, LocationUtils.toWorldPosition(block.getLocation())).withOptionalParameter(DirectContextParameters.ITEM_IN_HAND, ItemUtils.isEmpty(itemInHand) ? null : itemInHand));
            if (action.isRightClick()) {
                customBlock.execute(context, EventTrigger.RIGHT_CLICK);
            } else {
                customBlock.execute(context, EventTrigger.LEFT_CLICK);
            }
            if (dummy.isCancelled()) {
                event.setCancelled(true);
                return;
            }
            if (hitResult != null) {
                BlockBehavior blockBehavior;
                boolean flag;
                UseOnContext useOnContext = new UseOnContext(serverPlayer, hand, itemInHand, hitResult);
                boolean hasItem = player.getInventory().getItemInMainHand().getType() != Material.AIR || player.getInventory().getItemInOffHand().getType() != Material.AIR;
                boolean bl = flag = player.isSneaking() && hasItem;
                if (!flag && (blockBehavior = immutableBlockState.behavior()) instanceof AbstractBlockBehavior) {
                    AbstractBlockBehavior behavior = (AbstractBlockBehavior)blockBehavior;
                    result = behavior.useOnBlock(useOnContext, immutableBlockState);
                    if (result.success()) {
                        serverPlayer.updateLastSuccessfulInteractionTick(serverPlayer.gameTicks());
                        if (result == InteractionResult.SUCCESS_AND_CANCEL) {
                            event.setCancelled(true);
                        }
                        return;
                    }
                    if (result == InteractionResult.TRY_EMPTY_HAND && hand == InteractionHand.MAIN_HAND && (result = behavior.useWithoutItem(useOnContext, immutableBlockState)).success()) {
                        serverPlayer.updateLastSuccessfulInteractionTick(serverPlayer.gameTicks());
                        if (result == InteractionResult.SUCCESS_AND_CANCEL) {
                            event.setCancelled(true);
                        }
                        return;
                    }
                    if (result == InteractionResult.FAIL) {
                        return;
                    }
                }
            }
        } else if (Config.enableSoundSystem() && hitResult != null) {
            Object blockOwner = FastNMS.INSTANCE.method$BlockState$getBlock(blockState);
            if (this.plugin.blockManager().isOpenableBlockSoundRemoved(blockOwner)) {
                boolean flag;
                boolean hasItem = player.getInventory().getItemInMainHand().getType() != Material.AIR || player.getInventory().getItemInOffHand().getType() != Material.AIR;
                boolean bl = flag = player.isSneaking() && hasItem;
                if (!flag && blockData instanceof Openable) {
                    Openable openable = (Openable)blockData;
                    SoundData soundData = this.plugin.blockManager().getRemovedOpenableBlockSound(blockOwner, !openable.isOpen());
                    serverPlayer.playSound(soundData.id(), SoundSource.BLOCK, ((Float)soundData.volume().get()).floatValue(), ((Float)soundData.pitch().get()).floatValue());
                }
            }
        }
        boolean hasItem = !itemInHand.isEmpty();
        Optional<Object> optionalCustomItem = hasItem ? itemInHand.getCustomItem() : Optional.empty();
        boolean hasCustomItem = optionalCustomItem.isPresent();
        if (hasItem && action == Action.RIGHT_CLICK_BLOCK) {
            Optional<List<ItemBehavior>> optionalItemBehaviors;
            if (interactionPoint == null) {
                if (hasCustomItem) {
                    event.setCancelled(true);
                }
                return;
            }
            if (itemInHand.isBlockItem()) {
                if (!hasCustomItem) {
                    if (immutableBlockState != null) {
                        BlockData craftBlockData = BlockStateUtils.fromBlockData(immutableBlockState.vanillaBlockState().literalObject());
                        if (InteractUtils.isInteractable(player, craftBlockData, hitResult, itemInHand)) {
                            if (!serverPlayer.isSecondaryUseActive()) {
                                serverPlayer.setResendSound();
                            }
                        } else if (BlockStateUtils.isReplaceable(immutableBlockState.customBlockState().literalObject()) && !BlockStateUtils.isReplaceable(immutableBlockState.vanillaBlockState().literalObject())) {
                            serverPlayer.setResendSwing();
                        }
                    }
                } else {
                    if (((CustomItem)optionalCustomItem.get()).settings().canPlaceRelatedVanillaBlock()) {
                        return;
                    }
                    if (serverPlayer.isSecondaryUseActive() || !InteractUtils.isInteractable(player, blockData, hitResult, itemInHand)) {
                        event.setCancelled(true);
                    }
                }
            }
            if ((optionalItemBehaviors = itemInHand.getItemBehavior()).isPresent()) {
                boolean interactable;
                boolean bl = interactable = immutableBlockState == null && InteractUtils.isInteractable(player, blockData, hitResult, itemInHand);
                if (!serverPlayer.isSecondaryUseActive() && interactable) {
                    return;
                }
                UseOnContext useOnContext = new UseOnContext(serverPlayer, hand, itemInHand, hitResult);
                for (ItemBehavior itemBehavior : optionalItemBehaviors.get()) {
                    result = itemBehavior.useOnBlock(useOnContext);
                    if (result.success()) {
                        serverPlayer.updateLastSuccessfulInteractionTick(serverPlayer.gameTicks());
                    }
                    if (result == InteractionResult.SUCCESS_AND_CANCEL) {
                        event.setCancelled(true);
                        return;
                    }
                    if (result == InteractionResult.PASS) continue;
                    return;
                }
            }
            if (hasCustomItem && (serverPlayer.isSecondaryUseActive() || !InteractUtils.isInteractable(player, blockData, hitResult, itemInHand))) {
                Cancellable dummy = Cancellable.dummy();
                PlayerOptionalContext context = PlayerOptionalContext.of((Player)serverPlayer, ContextHolder.builder().withParameter(DirectContextParameters.BLOCK, new BukkitExistingBlock(block)).withOptionalParameter(DirectContextParameters.CUSTOM_BLOCK_STATE, immutableBlockState).withOptionalParameter(DirectContextParameters.ITEM_IN_HAND, itemInHand).withParameter(DirectContextParameters.POSITION, LocationUtils.toWorldPosition(block.getLocation())).withParameter(DirectContextParameters.HAND, hand).withParameter(DirectContextParameters.EVENT, dummy));
                CustomItem customItem = (CustomItem)optionalCustomItem.get();
                customItem.execute(context, EventTrigger.RIGHT_CLICK);
                if (dummy.isCancelled()) {
                    event.setCancelled(true);
                    return;
                }
            }
        }
        if (hasCustomItem && action == Action.LEFT_CLICK_BLOCK) {
            Cancellable dummy = Cancellable.dummy();
            PlayerOptionalContext context = PlayerOptionalContext.of((Player)serverPlayer, ContextHolder.builder().withParameter(DirectContextParameters.BLOCK, new BukkitExistingBlock(block)).withOptionalParameter(DirectContextParameters.CUSTOM_BLOCK_STATE, immutableBlockState).withOptionalParameter(DirectContextParameters.ITEM_IN_HAND, itemInHand).withParameter(DirectContextParameters.POSITION, LocationUtils.toWorldPosition(block.getLocation())).withParameter(DirectContextParameters.HAND, hand));
            CustomItem customItem = (CustomItem)optionalCustomItem.get();
            customItem.execute(context, EventTrigger.LEFT_CLICK);
            if (dummy.isCancelled()) {
                event.setCancelled(true);
                return;
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onInteractAir(PlayerInteractEvent event) {
        Optional<List<ItemBehavior>> optionalItemBehaviors;
        InteractionHand hand;
        Action action = event.getAction();
        if (action != Action.RIGHT_CLICK_AIR && action != Action.LEFT_CLICK_AIR) {
            return;
        }
        org.bukkit.entity.Player player = event.getPlayer();
        BukkitServerPlayer serverPlayer = BukkitAdaptors.adapt(player);
        if (serverPlayer.isSpectatorMode()) {
            return;
        }
        InteractionHand interactionHand = hand = event.getHand() == EquipmentSlot.HAND ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        if (serverPlayer.lastInteractEntityCheck(hand)) {
            return;
        }
        Item<ItemStack> itemInHand = serverPlayer.getItemInHand(hand);
        if (ItemUtils.isEmpty(itemInHand)) {
            return;
        }
        if (this.cancelEventIfHasInteraction(event, serverPlayer, hand)) {
            return;
        }
        Optional<CustomItem<ItemStack>> optionalCustomItem = itemInHand.getCustomItem();
        if (optionalCustomItem.isPresent()) {
            PlayerOptionalContext context = PlayerOptionalContext.of((Player)serverPlayer, ContextHolder.builder().withParameter(DirectContextParameters.HAND, hand).withOptionalParameter(DirectContextParameters.ITEM_IN_HAND, itemInHand).withParameter(DirectContextParameters.POSITION, LocationUtils.toWorldPosition(player.getLocation())));
            CustomItem<ItemStack> customItem = optionalCustomItem.get();
            if (action.isRightClick()) {
                customItem.execute(context, EventTrigger.RIGHT_CLICK);
            } else {
                customItem.execute(context, EventTrigger.LEFT_CLICK);
            }
        }
        if (action.isRightClick() && (optionalItemBehaviors = itemInHand.getItemBehavior()).isPresent()) {
            for (ItemBehavior itemBehavior : optionalItemBehaviors.get()) {
                InteractionResult result = itemBehavior.use(serverPlayer.world(), serverPlayer, hand);
                if (result.success()) {
                    serverPlayer.updateLastSuccessfulInteractionTick(serverPlayer.gameTicks());
                }
                if (result == InteractionResult.SUCCESS_AND_CANCEL) {
                    event.setCancelled(true);
                    return;
                }
                if (result == InteractionResult.PASS) continue;
                return;
            }
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOW)
    public void onConsumeItem(PlayerItemConsumeEvent event) {
        ItemStack consumedItem = event.getItem();
        if (ItemStackUtils.isEmpty(consumedItem)) {
            return;
        }
        Item<ItemStack> wrapped = this.plugin.itemManager().wrap(consumedItem);
        Optional<CustomItem<ItemStack>> optionalCustomItem = wrapped.getCustomItem();
        if (optionalCustomItem.isEmpty()) {
            return;
        }
        Cancellable cancellable = Cancellable.of(() -> ((PlayerItemConsumeEvent)event).isCancelled(), arg_0 -> ((PlayerItemConsumeEvent)event).setCancelled(arg_0));
        CustomItem<ItemStack> customItem = optionalCustomItem.get();
        PlayerOptionalContext context = PlayerOptionalContext.of((Player)BukkitAdaptors.adapt(event.getPlayer()), ContextHolder.builder().withParameter(DirectContextParameters.ITEM_IN_HAND, wrapped).withParameter(DirectContextParameters.EVENT, cancellable).withParameter(DirectContextParameters.HAND, event.getHand() == EquipmentSlot.HAND ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND));
        customItem.execute(context, EventTrigger.CONSUME);
        if (event.isCancelled()) {
            return;
        }
        if (event.getPlayer().getGameMode() != GameMode.CREATIVE) {
            Key replacement = customItem.settings().consumeReplacement();
            if (replacement == null) {
                event.setReplacement(null);
            } else {
                ItemStack replacementItem = this.plugin.itemManager().buildItemStack(replacement, BukkitAdaptors.adapt(event.getPlayer()));
                event.setReplacement(replacementItem);
            }
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOW)
    public void onFoodLevelChange(FoodLevelChangeEvent event) {
        if (VersionHelper.isOrAbove1_20_5()) {
            return;
        }
        HumanEntity humanEntity = event.getEntity();
        if (!(humanEntity instanceof org.bukkit.entity.Player)) {
            return;
        }
        org.bukkit.entity.Player player = (org.bukkit.entity.Player)humanEntity;
        ItemStack consumedItem = event.getItem();
        if (ItemStackUtils.isEmpty(consumedItem)) {
            return;
        }
        Item<ItemStack> wrapped = this.plugin.itemManager().wrap(consumedItem);
        Optional<CustomItem<ItemStack>> optionalCustomItem = wrapped.getCustomItem();
        if (optionalCustomItem.isEmpty()) {
            return;
        }
        CustomItem<ItemStack> customItem = optionalCustomItem.get();
        FoodData foodData = customItem.settings().foodData();
        if (foodData == null) {
            return;
        }
        event.setCancelled(true);
        int oldFoodLevel = player.getFoodLevel();
        if (foodData.nutrition() != 0) {
            player.setFoodLevel(MCUtils.clamp(oldFoodLevel + foodData.nutrition(), 0, 20));
        }
        float oldSaturation = player.getSaturation();
        if (foodData.saturation() != 0.0f) {
            player.setSaturation(MCUtils.clamp(oldSaturation, 0.0f, 10.0f));
        }
    }

    private boolean cancelEventIfHasInteraction(PlayerInteractEvent event, BukkitServerPlayer player, InteractionHand hand) {
        if (hand == InteractionHand.OFF_HAND) {
            int currentTicks = player.gameTicks();
            if (player.lastSuccessfulInteractionTick() == currentTicks) {
                event.setCancelled(true);
                return true;
            }
        }
        return false;
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onEntityDamage(EntityDamageEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof org.bukkit.entity.Item) {
            org.bukkit.entity.Item item = (org.bukkit.entity.Item)entity;
            Optional.of(this.plugin.itemManager().wrap(item.getItemStack())).flatMap(Item::getCustomItem).ifPresent(it -> {
                if (it.settings().invulnerable().contains((Object)DamageCauseUtils.fromBukkit(event.getCause()))) {
                    event.setCancelled(true);
                }
            });
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onEnchant(PrepareItemEnchantEvent event) {
        ItemStack itemToEnchant = event.getItem();
        Item<ItemStack> wrapped = this.plugin.itemManager().wrap(itemToEnchant);
        Optional<CustomItem<ItemStack>> optionalCustomItem = wrapped.getCustomItem();
        if (optionalCustomItem.isEmpty()) {
            return;
        }
        CustomItem<ItemStack> customItem = optionalCustomItem.get();
        if (!customItem.settings().canEnchant()) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onCompost(CompostItemEvent event) {
        ItemStack itemToCompost = event.getItem();
        Item<ItemStack> wrapped = this.plugin.itemManager().wrap(itemToCompost);
        Optional<CustomItem<ItemStack>> optionalCustomItem = wrapped.getCustomItem();
        if (optionalCustomItem.isEmpty()) {
            return;
        }
        event.setWillRaiseLevel(RandomUtils.generateRandomFloat(0.0f, 1.0f) < optionalCustomItem.get().settings().compostProbability());
    }

    @EventHandler(ignoreCancelled=true)
    public void onInventoryClick(InventoryClickEvent event) {
        Inventory inventory = event.getInventory();
        if (!(inventory instanceof EnchantingInventory)) {
            return;
        }
        EnchantingInventory inventory2 = (EnchantingInventory)inventory;
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof org.bukkit.entity.Player)) {
            return;
        }
        org.bukkit.entity.Player player = (org.bukkit.entity.Player)humanEntity;
        ItemStack lazuli = inventory2.getSecondary();
        if (lazuli != null) {
            return;
        }
        ItemStack item = inventory2.getItem();
        if (ItemStackUtils.isEmpty(item)) {
            return;
        }
        Item<ItemStack> wrapped = this.plugin.itemManager().wrap(item);
        if (ItemUtils.isEmpty(wrapped)) {
            return;
        }
        Optional<CustomItem<ItemStack>> optionalCustomItem = wrapped.getCustomItem();
        if (optionalCustomItem.isEmpty()) {
            return;
        }
        BukkitCustomItem customItem = (BukkitCustomItem)optionalCustomItem.get();
        if (customItem.clientItem() == FastNMS.INSTANCE.method$ItemStack$getItem(wrapped.getLiteralObject())) {
            return;
        }
        BukkitServerPlayer serverPlayer = BukkitAdaptors.adapt(player);
        if (serverPlayer == null) {
            return;
        }
        this.plugin.scheduler().sync().runDelayed(() -> {
            Object container = FastNMS.INSTANCE.field$Player$containerMenu(serverPlayer.serverPlayer());
            if (!CoreReflections.clazz$EnchantmentMenu.isInstance(container)) {
                return;
            }
            Object secondSlotItem = FastNMS.INSTANCE.method$Slot$getItem(FastNMS.INSTANCE.method$AbstractContainerMenu$getSlot(container, 1));
            if (secondSlotItem == null || FastNMS.INSTANCE.method$ItemStack$isEmpty(secondSlotItem)) {
                return;
            }
            Object[] dataSlots = FastNMS.INSTANCE.field$AbstractContainerMenu$dataSlots(container).toArray();
            ArrayList<Object> packets = new ArrayList<Object>(dataSlots.length);
            for (int i = 0; i < dataSlots.length; ++i) {
                Object dataSlot = dataSlots[i];
                int data = FastNMS.INSTANCE.method$DataSlot$get(dataSlot);
                packets.add(FastNMS.INSTANCE.constructor$ClientboundContainerSetDataPacket(FastNMS.INSTANCE.field$AbstractContainerMenu$containerId(container), i, data));
            }
            serverPlayer.sendPackets(packets, false);
        });
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
    public void onDropItem(PlayerDropItemEvent event) {
        if (!Config.triggerUpdateDrop()) {
            return;
        }
        org.bukkit.entity.Item itemDrop = event.getItemDrop();
        ItemStack itemStack = itemDrop.getItemStack();
        Item<ItemStack> wrapped = this.itemManager.wrap(itemStack);
        ItemUpdateResult result = this.itemManager.updateItem(wrapped, () -> ItemBuildContext.of(BukkitAdaptors.adapt(event.getPlayer())));
        if (result.updated()) {
            itemDrop.setItemStack((ItemStack)result.finalItem().getItem());
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGH)
    public void onPickUpItem(EntityPickupItemEvent event) {
        if (!Config.triggerUpdatePickUp()) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof org.bukkit.entity.Player)) {
            return;
        }
        org.bukkit.entity.Player player = (org.bukkit.entity.Player)livingEntity;
        org.bukkit.entity.Item itemDrop = event.getItem();
        ItemStack itemStack = itemDrop.getItemStack();
        Item<ItemStack> wrapped = this.itemManager.wrap(itemStack);
        ItemUpdateResult result = this.itemManager.updateItem(wrapped, () -> ItemBuildContext.of(BukkitAdaptors.adapt(player)));
        if (result.updated()) {
            itemDrop.setItemStack((ItemStack)result.finalItem().getItem());
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOW)
    public void onInventoryClickItem(InventoryClickEvent event) {
        if (!Config.triggerUpdateClick()) {
            return;
        }
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof org.bukkit.entity.Player)) {
            return;
        }
        org.bukkit.entity.Player player = (org.bukkit.entity.Player)humanEntity;
        Inventory clickedInventory = event.getClickedInventory();
        if (clickedInventory == null || clickedInventory != player.getInventory()) {
            return;
        }
        ItemStack currentItem = event.getCurrentItem();
        Item<ItemStack> wrapped = this.itemManager.wrap(currentItem);
        ItemUpdateResult result = this.itemManager.updateItem(wrapped, () -> ItemBuildContext.of(BukkitAdaptors.adapt(player)));
        if (!result.updated() || !result.replaced()) {
            return;
        }
        event.setCurrentItem((ItemStack)result.finalItem().getItem());
    }
}

