/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.item.recipe;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.papermc.paper.potion.PotionMix;
import java.io.Reader;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import net.momirealms.craftengine.bukkit.item.BukkitItemManager;
import net.momirealms.craftengine.bukkit.item.recipe.CustomIngredientList;
import net.momirealms.craftengine.bukkit.item.recipe.CustomIngredientSet;
import net.momirealms.craftengine.bukkit.item.recipe.RecipeEventListener;
import net.momirealms.craftengine.bukkit.nms.FastNMS;
import net.momirealms.craftengine.bukkit.plugin.BukkitCraftEngine;
import net.momirealms.craftengine.bukkit.plugin.injector.RecipeInjector;
import net.momirealms.craftengine.bukkit.plugin.reflection.ReflectionInitException;
import net.momirealms.craftengine.bukkit.plugin.reflection.bukkit.CraftBukkitReflections;
import net.momirealms.craftengine.bukkit.plugin.reflection.minecraft.CoreReflections;
import net.momirealms.craftengine.bukkit.plugin.reflection.minecraft.MRegistries;
import net.momirealms.craftengine.bukkit.util.KeyUtils;
import net.momirealms.craftengine.core.item.Item;
import net.momirealms.craftengine.core.item.ItemBuildContext;
import net.momirealms.craftengine.core.item.ItemKeys;
import net.momirealms.craftengine.core.item.recipe.AbstractRecipeManager;
import net.momirealms.craftengine.core.item.recipe.CustomBlastingRecipe;
import net.momirealms.craftengine.core.item.recipe.CustomBrewingRecipe;
import net.momirealms.craftengine.core.item.recipe.CustomCampfireRecipe;
import net.momirealms.craftengine.core.item.recipe.CustomCookingRecipe;
import net.momirealms.craftengine.core.item.recipe.CustomShapedRecipe;
import net.momirealms.craftengine.core.item.recipe.CustomShapelessRecipe;
import net.momirealms.craftengine.core.item.recipe.CustomSmeltingRecipe;
import net.momirealms.craftengine.core.item.recipe.CustomSmithingTransformRecipe;
import net.momirealms.craftengine.core.item.recipe.CustomSmithingTrimRecipe;
import net.momirealms.craftengine.core.item.recipe.CustomSmokingRecipe;
import net.momirealms.craftengine.core.item.recipe.CustomStoneCuttingRecipe;
import net.momirealms.craftengine.core.item.recipe.Ingredient;
import net.momirealms.craftengine.core.item.recipe.Recipe;
import net.momirealms.craftengine.core.item.recipe.RecipeSerializer;
import net.momirealms.craftengine.core.item.recipe.RecipeSerializers;
import net.momirealms.craftengine.core.item.recipe.UniqueIdItem;
import net.momirealms.craftengine.core.plugin.CraftEngine;
import net.momirealms.craftengine.core.plugin.config.Config;
import net.momirealms.craftengine.core.registry.BuiltInRegistries;
import net.momirealms.craftengine.core.util.AdventureHelper;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.Pair;
import net.momirealms.craftengine.core.util.UniqueKey;
import net.momirealms.craftengine.core.util.VersionHelper;
import net.momirealms.craftengine.libraries.adventure.text.Component;
import net.momirealms.craftengine.libraries.adventure.text.format.NamedTextColor;
import net.momirealms.craftengine.libraries.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class BukkitRecipeManager
extends AbstractRecipeManager<ItemStack> {
    private static BukkitRecipeManager instance;
    private static final Consumer<Key> MINECRAFT_RECIPE_REMOVER;
    private static final BiFunction<Key, Object, Object> MINECRAFT_RECIPE_ADDER;
    private static final Map<Key, Function<Recipe<ItemStack>, Object>> ADD_RECIPE_FOR_MINECRAFT_RECIPE_HOLDER;
    private final BukkitCraftEngine plugin;
    private final RecipeEventListener recipeEventListener;
    private Object stolenFeatureFlagSet;
    private final List<Pair<Key, Boolean>> recipesToUnregister = new ArrayList<Pair<Key, Boolean>>();
    private final Set<Key> replacedDatapackRecipes = new HashSet<Key>();
    private Map<Key, Recipe<ItemStack>> lastDatapackRecipes = Map.of();
    private Object lastRecipeManager = null;

    private static void modifyShapedRecipeIngredients(CustomShapedRecipe<ItemStack> recipe, Object shapedRecipe) {
        try {
            List<Ingredient<ItemStack>> actualIngredients = recipe.parsedPattern().ingredients().stream().filter(Optional::isPresent).map(Optional::get).toList();
            if (VersionHelper.isOrAbove1_21_2()) {
                CoreReflections.methodHandle$ShapedRecipe$placementInfoSetter.invokeExact(shapedRecipe, null);
            }
            List<Object> ingredients = BukkitRecipeManager.getIngredientsFromShapedRecipe(shapedRecipe);
            BukkitRecipeManager.modifyIngredients(ingredients, actualIngredients);
        }
        catch (Throwable e) {
            CraftEngine.instance().logger().warn("Failed to inject shaped recipe", e);
        }
    }

    public static List<Object> getIngredientsFromShapedRecipe(Object recipe) {
        ArrayList<Object> ingredients = new ArrayList<Object>();
        try {
            if (VersionHelper.isOrAbove1_20_3()) {
                Object pattern = CoreReflections.methodHandle$1_20_3$ShapedRecipe$patternGetter.invokeExact(recipe);
                if (VersionHelper.isOrAbove1_21_2()) {
                    List optionals = CoreReflections.methodHandle$ShapedRecipePattern$ingredients1_21_2Getter.invokeExact(pattern);
                    for (Optional optional : optionals) {
                        optional.ifPresent(ingredients::add);
                    }
                } else {
                    List objectList = CoreReflections.methodHandle$ShapedRecipePattern$ingredients1_20_3Getter.invokeExact(pattern);
                    for (Object object : objectList) {
                        Object[] values = CoreReflections.methodHandle$Ingredient$valuesGetter.invokeExact(object);
                        if (values.length == 0) continue;
                        ingredients.add(object);
                    }
                }
            } else {
                List objectList = CoreReflections.methodHandle$1_20_1$ShapedRecipe$recipeItemsGetter.invokeExact(recipe);
                for (Object object : objectList) {
                    Object[] values = CoreReflections.methodHandle$Ingredient$valuesGetter.invokeExact(object);
                    if (values.length == 0) continue;
                    ingredients.add(object);
                }
            }
        }
        catch (Throwable e) {
            CraftEngine.instance().logger().warn("Failed to get ingredients from shaped recipe", e);
        }
        return ingredients;
    }

    private static void modifyShapelessRecipeIngredients(CustomShapelessRecipe<ItemStack> recipe, Object shapelessRecipe) {
        try {
            List<Ingredient<ItemStack>> actualIngredients = recipe.ingredientsInUse();
            if (VersionHelper.isOrAbove1_21_2()) {
                CoreReflections.methodHandle$ShapelessRecipe$placementInfoSetter.invokeExact(shapelessRecipe, null);
            }
            List ingredients = CoreReflections.methodHandle$ShapelessRecipe$ingredientsGetter.invokeExact(shapelessRecipe);
            BukkitRecipeManager.modifyIngredients(ingredients, actualIngredients);
        }
        catch (Throwable e) {
            CraftEngine.instance().logger().warn("Failed to inject shapeless recipe", e);
        }
    }

    private static void modifyCookingRecipeIngredient(CustomCookingRecipe<ItemStack> recipe, Object cookingRecipe) {
        try {
            Ingredient<ItemStack> actualIngredient = recipe.ingredient();
            Object ingredient = VersionHelper.isOrAbove1_21_2() ? CoreReflections.methodHandle$SingleItemRecipe$inputGetter.invokeExact(cookingRecipe) : CoreReflections.methodHandle$AbstractCookingRecipe$inputGetter.invokeExact(cookingRecipe);
            BukkitRecipeManager.modifyIngredients(List.of(ingredient), List.of(actualIngredient));
        }
        catch (Throwable e) {
            CraftEngine.instance().logger().warn("Failed to inject cooking recipe", e);
        }
    }

    public static List<Object> getIngredientLooks(List<UniqueKey> holders) {
        ArrayList<Object> itemStacks = new ArrayList<Object>();
        for (UniqueKey holder : holders) {
            Optional buildableItem = BukkitItemManager.instance().getBuildableItem(holder.key());
            if (buildableItem.isPresent()) {
                ItemStack itemStack = (ItemStack)buildableItem.get().buildItemStack(ItemBuildContext.empty(), 1);
                Object nmsStack = FastNMS.INSTANCE.method$CraftItemStack$asNMSCopy(itemStack);
                itemStacks.add(nmsStack);
                continue;
            }
            Item<ItemStack> barrier = BukkitItemManager.instance().createWrappedItem(ItemKeys.BARRIER, null);
            assert (barrier != null);
            barrier.customNameJson(AdventureHelper.componentToJson(Component.text((String)holder.key().asString()).color((TextColor)NamedTextColor.RED)));
            itemStacks.add(barrier.getLiteralObject());
        }
        return itemStacks;
    }

    private static void modifyIngredients(List<Object> fakeIngredients, List<Ingredient<ItemStack>> actualIngredients) throws Throwable {
        if (fakeIngredients.size() != actualIngredients.size()) {
            throw new IllegalArgumentException("Ingredient count mismatch");
        }
        for (int i = 0; i < fakeIngredients.size(); ++i) {
            Object ingredient = fakeIngredients.get(i);
            Ingredient<ItemStack> actualIngredient = actualIngredients.get(i);
            List<Object> items = BukkitRecipeManager.getIngredientLooks(actualIngredient.items());
            if (VersionHelper.isOrAbove1_21_4()) {
                CoreReflections.methodHandle$Ingredient$itemStacksSetter.invokeExact(ingredient, new CustomIngredientSet(items, actualIngredient));
                continue;
            }
            if (VersionHelper.isOrAbove1_21_2()) {
                CoreReflections.methodHandle$Ingredient$itemStacksSetter.invokeExact(ingredient, new CustomIngredientList(items, actualIngredient));
                continue;
            }
            Object itemStackArray = Array.newInstance(CoreReflections.clazz$ItemStack, items.size());
            for (int j = 0; j < items.size(); ++j) {
                Array.set(itemStackArray, j, items.get(j));
            }
            CoreReflections.methodHandle$Ingredient$itemStacksSetter.invokeExact(ingredient, itemStackArray);
        }
    }

    public static Object toRecipeResourceKey(Key id) {
        return FastNMS.INSTANCE.method$ResourceKey$create(MRegistries.RECIPE, KeyUtils.toResourceLocation(id));
    }

    public BukkitRecipeManager(BukkitCraftEngine plugin) {
        instance = this;
        this.plugin = plugin;
        this.recipeEventListener = new RecipeEventListener(plugin, this, plugin.itemManager());
    }

    public static Object minecraftRecipeManager() {
        return FastNMS.INSTANCE.method$MinecraftServer$getRecipeManager(FastNMS.INSTANCE.method$MinecraftServer$getServer());
    }

    public static BukkitRecipeManager instance() {
        return instance;
    }

    @Override
    public void delayedInit() {
        Bukkit.getPluginManager().registerEvents((Listener)this.recipeEventListener, (Plugin)this.plugin.javaPlugin());
    }

    @Override
    public void load() {
        if (!Config.enableRecipeSystem()) {
            return;
        }
        if (VersionHelper.isOrAbove1_21_2()) {
            try {
                this.stolenFeatureFlagSet = CoreReflections.methodHandle$RecipeManager$featureflagsetGetter.invokeExact(BukkitRecipeManager.minecraftRecipeManager());
                CoreReflections.methodHandle$RecipeManager$featureflagsetSetter.invokeExact(BukkitRecipeManager.minecraftRecipeManager(), null);
            }
            catch (Throwable e) {
                this.plugin.logger().warn("Failed to steal feature flag set", e);
            }
        }
    }

    @Override
    public void unload() {
        if (!Config.enableRecipeSystem()) {
            return;
        }
        if (!Bukkit.isStopping()) {
            for (Map.Entry entry : this.byId.entrySet()) {
                Key id = (Key)entry.getKey();
                if (this.isDataPackRecipe(id)) continue;
                boolean isBrewingRecipe = entry.getValue() instanceof CustomBrewingRecipe;
                this.recipesToUnregister.add(Pair.of(id, isBrewingRecipe));
            }
        }
        super.unload();
    }

    @Override
    public void delayedLoad() {
        if (!Config.enableRecipeSystem()) {
            return;
        }
        this.loadDataPackRecipes();
    }

    @Override
    public void disable() {
        this.unload();
        HandlerList.unregisterAll((Listener)this.recipeEventListener);
    }

    @Override
    protected void unregisterPlatformRecipeMainThread(Key key, boolean isBrewingRecipe) {
        if (isBrewingRecipe) {
            Bukkit.getPotionBrewer().removePotionMix(new NamespacedKey(key.namespace(), key.value()));
        } else {
            MINECRAFT_RECIPE_REMOVER.accept(key);
        }
    }

    @Override
    protected void registerPlatformRecipeMainThread(Recipe<ItemStack> recipe) {
        Key id = recipe.id();
        if (recipe instanceof CustomBrewingRecipe) {
            CustomBrewingRecipe brewingRecipe = (CustomBrewingRecipe)recipe;
            if (!VersionHelper.isOrAbove1_20_2()) {
                return;
            }
            PotionMix potionMix = new PotionMix(new NamespacedKey(id.namespace(), id.value()), (ItemStack)brewingRecipe.result(ItemBuildContext.empty()), PotionMix.createPredicateChoice(container -> {
                Item<ItemStack> wrapped = this.plugin.itemManager().wrap((ItemStack)container);
                return brewingRecipe.container().test(UniqueIdItem.of(wrapped));
            }), PotionMix.createPredicateChoice(ingredient -> {
                Item<ItemStack> wrapped = this.plugin.itemManager().wrap((ItemStack)ingredient);
                return brewingRecipe.ingredient().test(UniqueIdItem.of(wrapped));
            }));
            Bukkit.getPotionBrewer().addPotionMix(potionMix);
        } else {
            if (this.isDataPackRecipe(id)) {
                block6: {
                    if (!this.replacedDatapackRecipes.add(id)) {
                        for (Ingredient<ItemStack> ingredient2 : recipe.ingredientsInUse()) {
                            if (!ingredient2.hasCustomItem()) continue;
                            break block6;
                        }
                        return;
                    }
                }
                MINECRAFT_RECIPE_REMOVER.accept(id);
            }
            ADD_RECIPE_FOR_MINECRAFT_RECIPE_HOLDER.get(recipe.serializerType()).apply(recipe);
        }
    }

    private void loadDataPackRecipes() {
        Object currentRecipeManager = BukkitRecipeManager.minecraftRecipeManager();
        if (currentRecipeManager != this.lastRecipeManager) {
            this.lastRecipeManager = currentRecipeManager;
            this.replacedDatapackRecipes.clear();
            try {
                this.lastDatapackRecipes = this.scanResources();
            }
            catch (Throwable e) {
                this.plugin.logger().warn("Failed to load datapack recipes", e);
            }
        }
        if (Config.disableAllVanillaRecipes()) {
            this.recipesToUnregister.addAll(this.lastDatapackRecipes.keySet().stream().map(it -> Pair.of(it, false)).toList());
            return;
        }
        boolean hasDisabledAny = !Config.disabledVanillaRecipes().isEmpty();
        for (Map.Entry<Key, Recipe<ItemStack>> entry : this.lastDatapackRecipes.entrySet()) {
            if (hasDisabledAny && Config.disabledVanillaRecipes().contains(entry.getKey())) {
                this.recipesToUnregister.add(Pair.of(entry.getKey(), false));
                continue;
            }
            this.markAsDataPackRecipe(entry.getKey());
            this.registerInternalRecipe(entry.getKey(), entry.getValue());
        }
    }

    private Map<Key, Recipe<ItemStack>> scanResources() throws Throwable {
        Object fileToIdConverter = CoreReflections.methodHandle$FileToIdConverter$json.invokeExact(VersionHelper.isOrAbove1_21() ? "recipe" : "recipes");
        Object minecraftServer = FastNMS.INSTANCE.method$MinecraftServer$getServer();
        Object packRepository = CoreReflections.methodHandle$MinecraftServer$getPackRepository.invokeExact(minecraftServer);
        List selected = CoreReflections.methodHandle$PackRepository$selectedGetter.invokeExact(packRepository);
        ArrayList<Object> packResources = new ArrayList<Object>();
        for (Object pack : selected) {
            packResources.add(CoreReflections.methodHandle$Pack$open.invokeExact(pack));
        }
        HashMap<Key, Recipe<ItemStack>> recipes = new HashMap<Key, Recipe<ItemStack>>();
        try (AutoCloseable resourceManager = CoreReflections.methodHandle$MultiPackResourceManagerConstructor.invokeExact(CoreReflections.instance$PackType$SERVER_DATA, packResources);){
            Map scannedResources = CoreReflections.methodHandle$FileToIdConverter$listMatchingResources.invokeExact(fileToIdConverter, resourceManager);
            for (Map.Entry entry : scannedResources.entrySet()) {
                Key id = this.extractKeyFromResourceLocation(entry.getKey().toString());
                Reader reader = CoreReflections.methodHandle$Resource$openAsReader.invokeExact(entry.getValue());
                JsonObject jsonObject = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                Key serializerType = Key.of(jsonObject.get("type").getAsString());
                RecipeSerializer<?, Recipe<?>> serializer = BuiltInRegistries.RECIPE_SERIALIZER.getValue(serializerType);
                if (serializer == null) continue;
                try {
                    Recipe<?> recipe = serializer.readJson(id, jsonObject);
                    recipes.put(id, recipe);
                }
                catch (Exception e) {
                    this.plugin.logger().warn("Failed to load data pack recipe " + String.valueOf(id) + ". Json: " + String.valueOf(jsonObject), e);
                }
            }
        }
        catch (Throwable e) {
            this.plugin.logger().warn("Unknown error occurred when loading data pack recipes", e);
        }
        return recipes;
    }

    private Key extractKeyFromResourceLocation(String input) {
        int prefixEndIndex = input.indexOf(58);
        String prefix = input.substring(0, prefixEndIndex);
        int lastSlashIndex = input.lastIndexOf(47);
        int lastDotIndex = input.lastIndexOf(46);
        String fileName = input.substring(lastSlashIndex + 1, lastDotIndex);
        return Key.of(prefix, fileName);
    }

    @Override
    public void runDelayedSyncTasks() {
        if (!Config.enableRecipeSystem()) {
            return;
        }
        for (Pair<Key, Boolean> pair : this.recipesToUnregister) {
            this.unregisterPlatformRecipeMainThread(pair.left(), pair.right());
        }
        this.recipesToUnregister.clear();
        for (Recipe recipe : this.byId.values()) {
            try {
                this.registerPlatformRecipeMainThread(recipe);
            }
            catch (Exception e) {
                this.plugin.logger().warn("Failed to register recipe " + recipe.id().toString(), e);
            }
        }
        try {
            Key dyeRecipeId = Key.from("armor_dye");
            MINECRAFT_RECIPE_REMOVER.accept(dyeRecipeId);
            MINECRAFT_RECIPE_ADDER.apply(dyeRecipeId, RecipeInjector.createCustomDyeRecipe(dyeRecipeId));
            Key repairRecipeId = Key.from("repair_item");
            MINECRAFT_RECIPE_REMOVER.accept(repairRecipeId);
            MINECRAFT_RECIPE_ADDER.apply(repairRecipeId, RecipeInjector.createRepairItemRecipe(repairRecipeId));
            Key fireworkStarFadeRecipeId = Key.from("firework_star_fade");
            MINECRAFT_RECIPE_REMOVER.accept(fireworkStarFadeRecipeId);
            MINECRAFT_RECIPE_ADDER.apply(fireworkStarFadeRecipeId, RecipeInjector.createFireworkStarFadeRecipe(fireworkStarFadeRecipeId));
        }
        catch (ReflectiveOperationException e) {
            throw new ReflectionInitException("Failed to inject special recipes", e);
        }
        try {
            if (VersionHelper.isOrAbove1_21_2() && this.stolenFeatureFlagSet != null) {
                CoreReflections.methodHandle$RecipeManager$featureflagsetSetter.invokeExact(BukkitRecipeManager.minecraftRecipeManager(), this.stolenFeatureFlagSet);
                this.stolenFeatureFlagSet = null;
            }
            if (VersionHelper.isOrAbove1_21_2()) {
                CoreReflections.methodHandle$RecipeManager$finalizeRecipeLoading.invokeExact(BukkitRecipeManager.minecraftRecipeManager());
            }
            CoreReflections.methodHandle$DedicatedPlayerList$reloadRecipes.invokeExact(CraftBukkitReflections.methodHandle$CraftServer$playerListGetter.invokeExact(Bukkit.getServer()));
        }
        catch (Throwable e) {
            this.plugin.logger().warn("Failed to run delayed recipe tasks", e);
        }
    }

    static {
        Consumer<Key> consumer = MINECRAFT_RECIPE_REMOVER = VersionHelper.isOrAbove1_21_2() ? id -> {
            Object resourceKey = BukkitRecipeManager.toRecipeResourceKey(id);
            FastNMS.INSTANCE.method$RecipeMap$removeRecipe(FastNMS.INSTANCE.field$RecipeManager$recipes(BukkitRecipeManager.minecraftRecipeManager()), resourceKey);
        } : id -> {
            Object resourceLocation = KeyUtils.toResourceLocation(id);
            FastNMS.INSTANCE.method$RecipeManager$removeRecipe(BukkitRecipeManager.minecraftRecipeManager(), resourceLocation);
        };
        MINECRAFT_RECIPE_ADDER = VersionHelper.isOrAbove1_21_2() ? (id, recipe) -> {
            Object resourceKey = BukkitRecipeManager.toRecipeResourceKey(id);
            Object recipeHolder = FastNMS.INSTANCE.constructor$RecipeHolder(resourceKey, recipe);
            FastNMS.INSTANCE.method$RecipeManager$addRecipe(BukkitRecipeManager.minecraftRecipeManager(), recipeHolder);
            return recipeHolder;
        } : (VersionHelper.isOrAbove1_20_2() ? (id, recipe) -> {
            Object resourceLocation = KeyUtils.toResourceLocation(id);
            Object recipeHolder = FastNMS.INSTANCE.constructor$RecipeHolder(resourceLocation, recipe);
            FastNMS.INSTANCE.method$RecipeManager$addRecipe(BukkitRecipeManager.minecraftRecipeManager(), recipeHolder);
            return recipeHolder;
        } : (id, recipe) -> {
            FastNMS.INSTANCE.method$RecipeManager$addRecipe(BukkitRecipeManager.minecraftRecipeManager(), recipe);
            return recipe;
        });
        ADD_RECIPE_FOR_MINECRAFT_RECIPE_HOLDER = Map.of(RecipeSerializers.SHAPED, recipe -> {
            CustomShapedRecipe shapedRecipe = (CustomShapedRecipe)recipe;
            Object mcRecipe = FastNMS.INSTANCE.createShapedRecipe(shapedRecipe);
            return MINECRAFT_RECIPE_ADDER.apply(recipe.id(), mcRecipe);
        }, RecipeSerializers.SHAPELESS, recipe -> {
            CustomShapelessRecipe shapelessRecipe = (CustomShapelessRecipe)recipe;
            Object mcRecipe = FastNMS.INSTANCE.createShapelessRecipe(shapelessRecipe);
            return MINECRAFT_RECIPE_ADDER.apply(recipe.id(), mcRecipe);
        }, RecipeSerializers.SMELTING, recipe -> {
            CustomSmeltingRecipe smeltingRecipe = (CustomSmeltingRecipe)recipe;
            Object mcRecipe = FastNMS.INSTANCE.createSmeltingRecipe(smeltingRecipe);
            return MINECRAFT_RECIPE_ADDER.apply(recipe.id(), mcRecipe);
        }, RecipeSerializers.BLASTING, recipe -> {
            CustomBlastingRecipe blastingRecipe = (CustomBlastingRecipe)recipe;
            Object mcRecipe = FastNMS.INSTANCE.createBlastingRecipe(blastingRecipe);
            return MINECRAFT_RECIPE_ADDER.apply(recipe.id(), mcRecipe);
        }, RecipeSerializers.SMOKING, recipe -> {
            CustomSmokingRecipe smokingRecipe = (CustomSmokingRecipe)recipe;
            Object mcRecipe = FastNMS.INSTANCE.createSmokingRecipe(smokingRecipe);
            return MINECRAFT_RECIPE_ADDER.apply(recipe.id(), mcRecipe);
        }, RecipeSerializers.CAMPFIRE_COOKING, recipe -> {
            CustomCampfireRecipe campfireRecipe = (CustomCampfireRecipe)recipe;
            Object mcRecipe = FastNMS.INSTANCE.createCampfireRecipe(campfireRecipe);
            return MINECRAFT_RECIPE_ADDER.apply(recipe.id(), mcRecipe);
        }, RecipeSerializers.STONECUTTING, recipe -> {
            Object mcRecipe = FastNMS.INSTANCE.createStonecuttingRecipe((CustomStoneCuttingRecipe)recipe);
            return MINECRAFT_RECIPE_ADDER.apply(recipe.id(), mcRecipe);
        }, RecipeSerializers.SMITHING_TRIM, recipe -> {
            Object mcRecipe = FastNMS.INSTANCE.createSmithingTrimRecipe((CustomSmithingTrimRecipe)recipe);
            return MINECRAFT_RECIPE_ADDER.apply(recipe.id(), mcRecipe);
        }, RecipeSerializers.SMITHING_TRANSFORM, recipe -> {
            Object mcRecipe = FastNMS.INSTANCE.createSmithingTransformRecipe((CustomSmithingTransformRecipe)recipe);
            return MINECRAFT_RECIPE_ADDER.apply(recipe.id(), mcRecipe);
        });
    }
}

