/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.nms.v1_20.recipe;

import net.minecraft.core.NonNullList;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.inventory.InventoryCrafting;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.RecipeItemStack;
import net.minecraft.world.item.crafting.ShapedRecipes;
import net.minecraft.world.level.World;
import net.momirealms.craftengine.bukkit.nms.v1_20.recipe.RecipeHelper;
import net.momirealms.craftengine.core.item.ItemBuildContext;
import net.momirealms.craftengine.core.item.recipe.CustomShapedRecipe;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class InjectedShapedRecipe
extends ShapedRecipes {
    private final CustomShapedRecipe<ItemStack> recipe;
    private final NonNullList<RecipeItemStack> roughIngredients;

    public InjectedShapedRecipe(CustomShapedRecipe<ItemStack> recipe, String group, CraftingBookCategory category, int width, int height, NonNullList<RecipeItemStack> visualIngredients, NonNullList<RecipeItemStack> roughIngredients, net.minecraft.world.item.ItemStack result, boolean showNotification) {
        super(new MinecraftKey(recipe.id().namespace(), recipe.id().value()), group, category, width, height, visualIngredients, result, showNotification);
        this.recipe = recipe;
        this.roughIngredients = roughIngredients;
    }

    public static InjectedShapedRecipe of(CustomShapedRecipe<ItemStack> recipe) {
        String[] shape = recipe.pattern().pattern();
        int width = shape[0].length();
        NonNullList visualData = NonNullList.a((int)(shape.length * width), (Object)RecipeItemStack.a);
        for (int i = 0; i < shape.length; ++i) {
            String row = shape[i];
            for (int j = 0; j < row.length(); ++j) {
                visualData.set(i * width + j, (Object)RecipeHelper.toMinecraftVisual(recipe.pattern().ingredients().get(Character.valueOf(row.charAt(j)))));
            }
        }
        NonNullList roughData = NonNullList.a((int)(shape.length * width), (Object)RecipeItemStack.a);
        for (int i = 0; i < shape.length; ++i) {
            String row = shape[i];
            for (int j = 0; j < row.length(); ++j) {
                roughData.set(i * width + j, (Object)RecipeHelper.toMinecraft(recipe.pattern().ingredients().get(Character.valueOf(row.charAt(j)))));
            }
        }
        return new InjectedShapedRecipe(recipe, recipe.group(), RecipeHelper.toMinecraft(recipe.category()), width, shape.length, (NonNullList<RecipeItemStack>)visualData, (NonNullList<RecipeItemStack>)roughData, (net.minecraft.world.item.ItemStack)recipe.buildVisualOrActualResult(ItemBuildContext.empty()).getLiteralObject(), recipe.showNotification());
    }

    private boolean vanillaMatches(InventoryCrafting inventory, World world) {
        for (int i = 0; i <= inventory.f() - this.k(); ++i) {
            for (int j = 0; j <= inventory.g() - this.l(); ++j) {
                if (this.matches(inventory, i, j, true)) {
                    return true;
                }
                if (!this.matches(inventory, i, j, false)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean matches(InventoryCrafting inv, int offsetX, int offsetY, boolean flipped) {
        for (int k = 0; k < inv.f(); ++k) {
            for (int l = 0; l < inv.g(); ++l) {
                int i1 = k - offsetX;
                int j1 = l - offsetY;
                RecipeItemStack ingredient = RecipeItemStack.a;
                if (i1 >= 0 && j1 >= 0 && i1 < this.k() && j1 < this.l()) {
                    ingredient = flipped ? (RecipeItemStack)this.roughIngredients.get(this.k() - i1 - 1 + j1 * this.k()) : (RecipeItemStack)this.roughIngredients.get(i1 + j1 * this.k());
                }
                if (ingredient.a(inv.a(k + l * inv.f()))) continue;
                return false;
            }
        }
        return true;
    }

    public boolean a(@NotNull InventoryCrafting inventory, @NotNull World world) {
        boolean vanillaMatches = this.vanillaMatches(inventory, world);
        if (!vanillaMatches) {
            return false;
        }
        return this.recipe.matches(RecipeHelper.toCraftEngine(inventory));
    }

    @NotNull
    public NonNullList<net.minecraft.world.item.ItemStack> getRemainingItems(@NotNull InventoryCrafting inventory) {
        return RecipeHelper.getRemainingItems(inventory);
    }

    public boolean i() {
        return this.recipe.showNotification();
    }
}

