/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.nms.v1_20_2.inventory;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.IWorldInventory;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.momirealms.craftengine.bukkit.block.entity.BlockEntityHolder;
import net.momirealms.craftengine.bukkit.nms.StorageContainer;
import net.momirealms.craftengine.bukkit.plugin.BukkitCraftEngine;
import net.momirealms.craftengine.bukkit.plugin.user.BukkitServerPlayer;
import net.momirealms.craftengine.core.block.entity.BlockEntity;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_20_R2.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_20_R2.inventory.CraftItemStack;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.InventoryHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleStorageContainer
implements IWorldInventory,
StorageContainer {
    private final NonNullList<ItemStack> items;
    private int maxStack = 64;
    private final List<HumanEntity> viewers;
    private final InventoryHolder owner;
    private final int[] slots;
    private final boolean canPlaceItem;
    private final boolean canTakeItem;
    private final BlockEntity blockEntity;

    public SimpleStorageContainer(InventoryHolder owner, int size, boolean canPlaceItem, boolean canTakeItem) {
        this.items = NonNullList.a((int)size, (Object)ItemStack.b);
        this.viewers = new ObjectArrayList();
        this.owner = owner;
        this.slots = IntStream.range(0, size).toArray();
        this.canPlaceItem = canPlaceItem;
        this.canTakeItem = canTakeItem;
        if (owner instanceof BlockEntityHolder) {
            BlockEntityHolder blockEntityHolder = (BlockEntityHolder)owner;
            this.blockEntity = blockEntityHolder.blockEntity();
        } else {
            this.blockEntity = null;
        }
    }

    public int b() {
        return this.items.size();
    }

    @NotNull
    public ItemStack a(int slot) {
        return (ItemStack)this.items.get(slot);
    }

    @NotNull
    public ItemStack a(int slot, int amount) {
        ItemStack result;
        ItemStack stack = this.a(slot);
        if (stack == ItemStack.b) {
            return stack;
        }
        if (stack.L() <= amount) {
            this.a(slot, ItemStack.b);
            result = stack;
        } else {
            result = CraftItemStack.copyNMSStack((ItemStack)stack, (int)amount);
            stack.h(amount);
        }
        this.e();
        return result;
    }

    @NotNull
    public ItemStack b(int slot) {
        ItemStack result;
        ItemStack stack = this.a(slot);
        if (stack == ItemStack.b) {
            return stack;
        }
        if (stack.L() <= 1) {
            this.a(slot, ItemStack.b);
            result = stack;
        } else {
            result = CraftItemStack.copyNMSStack((ItemStack)stack, (int)1);
            stack.h(1);
        }
        return result;
    }

    public void a(int slot, @NotNull ItemStack stack) {
        this.items.set(slot, (Object)stack);
        if (stack != ItemStack.b && this.ag_() > 0 && stack.L() > this.ag_()) {
            stack.f(this.ag_());
        }
    }

    public int ag_() {
        return this.maxStack;
    }

    public void setMaxStackSize(int size) {
        this.maxStack = size;
    }

    public void e() {
    }

    public boolean a(@NotNull EntityHuman player) {
        if (this.blockEntity == null) {
            return true;
        }
        BukkitServerPlayer serverPlayer = BukkitCraftEngine.instance().adapt((Player)((EntityPlayer)player).getBukkitEntity());
        if (serverPlayer == null) {
            return false;
        }
        return serverPlayer.canInteractWithBlock(this.blockEntity.pos(), 4.0);
    }

    @NotNull
    public List<ItemStack> getContents() {
        return this.items;
    }

    public void onOpen(@NotNull CraftHumanEntity player) {
        this.viewers.add((HumanEntity)player);
    }

    public void onClose(@NotNull CraftHumanEntity player) {
        this.viewers.remove(player);
    }

    @NotNull
    public List<HumanEntity> getViewers() {
        return this.viewers;
    }

    public InventoryHolder getOwner() {
        return this.owner;
    }

    public boolean b(int slot, @NotNull ItemStack stack) {
        return true;
    }

    public void d_(@NotNull EntityHuman player) {
    }

    public void c(@NotNull EntityHuman player) {
    }

    public void a() {
        this.items.clear();
    }

    @NotNull
    public Location getLocation() {
        if (this.blockEntity == null) {
            return null;
        }
        return new Location((World)this.blockEntity.world().world().platformWorld(), (double)this.blockEntity.pos().x(), (double)this.blockEntity.pos().y(), (double)this.blockEntity.pos().z());
    }

    public boolean af_() {
        ItemStack itemstack;
        Iterator iterator = this.items.iterator();
        do {
            if (iterator.hasNext()) continue;
            return true;
        } while ((itemstack = (ItemStack)iterator.next()).b());
        return false;
    }

    public int @NotNull [] a(@NotNull EnumDirection direction) {
        return this.slots;
    }

    public boolean a(int i, @NotNull ItemStack itemStack, @Nullable EnumDirection direction) {
        return this.canPlaceItem;
    }

    public boolean b(int i, @NotNull ItemStack itemStack, @NotNull EnumDirection direction) {
        return this.canTakeItem;
    }
}

