/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.nms.v1_20_5.inventory;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.momirealms.craftengine.bukkit.block.entity.BlockEntityHolder;
import net.momirealms.craftengine.bukkit.nms.StorageContainer;
import net.momirealms.craftengine.bukkit.plugin.BukkitCraftEngine;
import net.momirealms.craftengine.bukkit.plugin.user.BukkitServerPlayer;
import net.momirealms.craftengine.core.block.entity.BlockEntity;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.InventoryHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleStorageContainer
implements WorldlyContainer,
StorageContainer {
    private final NonNullList<ItemStack> items;
    private int maxStack = 99;
    private final List<HumanEntity> viewers;
    private final InventoryHolder owner;
    private final int[] slots;
    private final boolean canPlaceItem;
    private final boolean canTakeItem;
    private final BlockEntity blockEntity;

    public SimpleStorageContainer(InventoryHolder owner, int size, boolean canPlaceItem, boolean canTakeItem) {
        this.items = NonNullList.withSize((int)size, (Object)ItemStack.EMPTY);
        this.viewers = new ObjectArrayList();
        this.owner = owner;
        this.slots = IntStream.range(0, size).toArray();
        this.canPlaceItem = canPlaceItem;
        this.canTakeItem = canTakeItem;
        if (owner instanceof BlockEntityHolder) {
            BlockEntityHolder blockEntityHolder = (BlockEntityHolder)owner;
            this.blockEntity = blockEntityHolder.blockEntity();
        } else {
            this.blockEntity = null;
        }
    }

    public int getContainerSize() {
        return this.items.size();
    }

    @NotNull
    public ItemStack getItem(int slot) {
        return (ItemStack)this.items.get(slot);
    }

    @NotNull
    public ItemStack removeItem(int slot, int amount) {
        ItemStack result;
        ItemStack stack = this.getItem(slot);
        if (stack == ItemStack.EMPTY) {
            return stack;
        }
        if (stack.getCount() <= amount) {
            this.setItem(slot, ItemStack.EMPTY);
            result = stack;
        } else {
            result = CraftItemStack.copyNMSStack((ItemStack)stack, (int)amount);
            stack.shrink(amount);
        }
        this.setChanged();
        return result;
    }

    @NotNull
    public ItemStack removeItemNoUpdate(int slot) {
        ItemStack result;
        ItemStack stack = this.getItem(slot);
        if (stack == ItemStack.EMPTY) {
            return stack;
        }
        if (stack.getCount() <= 1) {
            this.setItem(slot, ItemStack.EMPTY);
            result = stack;
        } else {
            result = CraftItemStack.copyNMSStack((ItemStack)stack, (int)1);
            stack.shrink(1);
        }
        return result;
    }

    public void setItem(int slot, @NotNull ItemStack stack) {
        this.items.set(slot, (Object)stack);
        if (stack != ItemStack.EMPTY && this.getMaxStackSize() > 0 && stack.getCount() > this.getMaxStackSize()) {
            stack.setCount(this.getMaxStackSize());
        }
    }

    public int getMaxStackSize() {
        return this.maxStack;
    }

    public void setMaxStackSize(int size) {
        this.maxStack = size;
    }

    public void setChanged() {
    }

    public boolean stillValid(@NotNull Player player) {
        if (this.blockEntity == null) {
            return true;
        }
        BukkitServerPlayer serverPlayer = BukkitCraftEngine.instance().adapt((org.bukkit.entity.Player)((ServerPlayer)player).getBukkitEntity());
        if (serverPlayer == null) {
            return false;
        }
        return serverPlayer.canInteractWithBlock(this.blockEntity.pos(), 4.0);
    }

    @NotNull
    public List<ItemStack> getContents() {
        return this.items;
    }

    public void onOpen(@NotNull CraftHumanEntity player) {
        this.viewers.add((HumanEntity)player);
    }

    public void onClose(@NotNull CraftHumanEntity player) {
        this.viewers.remove(player);
    }

    @NotNull
    public List<HumanEntity> getViewers() {
        return this.viewers;
    }

    public InventoryHolder getOwner() {
        return this.owner;
    }

    public boolean canPlaceItem(int slot, @NotNull ItemStack stack) {
        return true;
    }

    public void startOpen(@NotNull Player player) {
    }

    public void stopOpen(@NotNull Player player) {
    }

    public void clearContent() {
        this.items.clear();
    }

    @NotNull
    public Location getLocation() {
        if (this.blockEntity == null) {
            return null;
        }
        return new Location((World)this.blockEntity.world().world().platformWorld(), (double)this.blockEntity.pos().x(), (double)this.blockEntity.pos().y(), (double)this.blockEntity.pos().z());
    }

    public boolean isEmpty() {
        ItemStack itemstack;
        Iterator iterator = this.items.iterator();
        do {
            if (iterator.hasNext()) continue;
            return true;
        } while ((itemstack = (ItemStack)iterator.next()).isEmpty());
        return false;
    }

    public int @NotNull [] getSlotsForFace(@NotNull Direction direction) {
        return this.slots;
    }

    public boolean canPlaceItemThroughFace(int i, @NotNull ItemStack itemStack, @Nullable Direction direction) {
        return this.canPlaceItem;
    }

    public boolean canTakeItemThroughFace(int i, @NotNull ItemStack itemStack, @NotNull Direction direction) {
        return this.canTakeItem;
    }
}

