/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.nms.v1_20_5.recipe;

import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.Level;
import net.momirealms.craftengine.bukkit.nms.v1_20_5.recipe.RecipeHelper;
import net.momirealms.craftengine.core.item.ItemBuildContext;
import net.momirealms.craftengine.core.item.recipe.CustomShapelessRecipe;
import net.momirealms.craftengine.core.item.recipe.input.RecipeInput;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class InjectedShapelessRecipe
extends ShapelessRecipe {
    private final CustomShapelessRecipe<ItemStack> recipe;
    private final ShapelessRecipe companionRecipe;

    public InjectedShapelessRecipe(CustomShapelessRecipe<ItemStack> recipe, String group, CraftingBookCategory category, net.minecraft.world.item.ItemStack result, NonNullList<Ingredient> visualIngredients, NonNullList<Ingredient> roughIngredients) {
        super(group, category, result, visualIngredients);
        this.recipe = recipe;
        this.companionRecipe = new ShapelessRecipe(group, category, result, roughIngredients);
    }

    public static InjectedShapelessRecipe of(CustomShapelessRecipe<ItemStack> recipe) {
        List<net.momirealms.craftengine.core.item.recipe.Ingredient<ItemStack>> visualIngredients = recipe.ingredientsInUse();
        NonNullList visualData = NonNullList.withSize((int)visualIngredients.size(), (Object)Ingredient.EMPTY);
        for (int i = 0; i < visualIngredients.size(); ++i) {
            visualData.set(i, (Object)RecipeHelper.toMinecraftVisual(visualIngredients.get(i)));
        }
        List<net.momirealms.craftengine.core.item.recipe.Ingredient<ItemStack>> roughIngredients = recipe.ingredientsInUse();
        NonNullList roughData = NonNullList.withSize((int)roughIngredients.size(), (Object)Ingredient.EMPTY);
        for (int i = 0; i < roughIngredients.size(); ++i) {
            roughData.set(i, (Object)RecipeHelper.toMinecraft(roughIngredients.get(i)));
        }
        return new InjectedShapelessRecipe(recipe, recipe.group(), RecipeHelper.toMinecraft(recipe.category()), (net.minecraft.world.item.ItemStack)recipe.buildVisualOrActualResult(ItemBuildContext.empty()).getLiteralObject(), (NonNullList<Ingredient>)visualData, (NonNullList<Ingredient>)roughData);
    }

    public boolean matches(@NotNull CraftingContainer inventory, @NotNull Level world) {
        boolean vanillaMatches = this.companionRecipe.matches(inventory, world);
        if (!vanillaMatches) {
            return false;
        }
        return this.recipe.matches((RecipeInput)RecipeHelper.toCraftEngine(inventory));
    }

    @NotNull
    public NonNullList<net.minecraft.world.item.ItemStack> getRemainingItems(@NotNull CraftingContainer inventory) {
        return RecipeHelper.getRemainingItems(inventory);
    }

    public boolean showNotification() {
        return this.recipe.showNotification();
    }
}

