/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.nms.v1_21_4.recipe;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.CookingBookCategory;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.level.ItemLike;
import net.momirealms.craftengine.bukkit.item.BukkitItemManager;
import net.momirealms.craftengine.bukkit.item.recipe.BukkitRecipeManager;
import net.momirealms.craftengine.core.item.CustomItem;
import net.momirealms.craftengine.core.item.Item;
import net.momirealms.craftengine.core.item.ItemBuildContext;
import net.momirealms.craftengine.core.item.recipe.CookingRecipeCategory;
import net.momirealms.craftengine.core.item.recipe.CraftingRecipeCategory;
import net.momirealms.craftengine.core.item.recipe.Ingredient;
import net.momirealms.craftengine.core.item.recipe.UniqueIdItem;
import net.momirealms.craftengine.core.item.recipe.input.CraftingInput;
import net.momirealms.craftengine.core.util.Key;
import net.momirealms.craftengine.core.util.UniqueKey;
import org.bukkit.craftbukkit.inventory.CraftItemStack;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public final class RecipeHelper {
    public static net.minecraft.world.item.crafting.Ingredient toMinecraft(Ingredient<ItemStack> ingredient) {
        if (ingredient == null) {
            return net.minecraft.world.item.crafting.Ingredient.of((ItemLike[])new ItemLike[0]);
        }
        ArrayList<net.minecraft.world.item.Item> items = new ArrayList<net.minecraft.world.item.Item>();
        for (UniqueKey uniqueKey : ingredient.minecraftItems()) {
            net.minecraft.world.item.Item item = (net.minecraft.world.item.Item)BuiltInRegistries.ITEM.getValue(ResourceLocation.fromNamespaceAndPath((String)uniqueKey.key().namespace(), (String)uniqueKey.key().value()));
            items.add(item);
        }
        return net.minecraft.world.item.crafting.Ingredient.of(items.stream());
    }

    public static net.minecraft.world.item.crafting.Ingredient toMinecraftVisual(Ingredient<ItemStack> ingredient) {
        if (ingredient == null) {
            return net.minecraft.world.item.crafting.Ingredient.of((ItemLike[])new ItemLike[0]);
        }
        List<Object> itemStacks = BukkitRecipeManager.getIngredientLooks(ingredient.items());
        return net.minecraft.world.item.crafting.Ingredient.ofStacks(itemStacks);
    }

    public static CraftingInput<ItemStack> toCraftEngine(net.minecraft.world.item.crafting.CraftingInput input) {
        return CraftingInput.of(input.width(), input.height(), input.items().stream().map(it -> UniqueIdItem.of(BukkitItemManager.instance().wrap((ItemStack)CraftItemStack.asCraftMirror((net.minecraft.world.item.ItemStack)it)))).toList());
    }

    public static CraftingBookCategory toMinecraft(CraftingRecipeCategory category) {
        if (category == null) {
            return null;
        }
        return CraftingBookCategory.values()[category.ordinal()];
    }

    public static CookingBookCategory toMinecraft(CookingRecipeCategory category) {
        if (category == null) {
            return null;
        }
        return CookingBookCategory.values()[category.ordinal()];
    }

    public static net.minecraft.world.item.ItemStack craftingRemainer(net.minecraft.world.item.ItemStack stack) {
        CustomItem<ItemStack> customItem;
        if (stack.isEmpty()) {
            return net.minecraft.world.item.ItemStack.EMPTY;
        }
        Item<ItemStack> item = BukkitItemManager.instance().wrap((ItemStack)CraftItemStack.asCraftMirror((net.minecraft.world.item.ItemStack)stack));
        Optional<CustomItem<ItemStack>> optionalCustomItem = item.getCustomItem();
        if (optionalCustomItem.isPresent() && !(customItem = optionalCustomItem.get()).isVanillaItem()) {
            Optional optionalBuildableItem;
            Key remainder = customItem.settings().craftRemainder();
            if (remainder != null && (optionalBuildableItem = BukkitItemManager.instance().getBuildableItem(remainder)).isPresent()) {
                return (net.minecraft.world.item.ItemStack)optionalBuildableItem.get().buildItem(ItemBuildContext.empty()).getLiteralObject();
            }
            return net.minecraft.world.item.ItemStack.EMPTY;
        }
        return stack.getItem().getCraftingRemainder();
    }

    @NotNull
    public static NonNullList<net.minecraft.world.item.ItemStack> getRemainingItems(net.minecraft.world.item.crafting.CraftingInput input) {
        NonNullList list = NonNullList.withSize((int)input.size(), (Object)net.minecraft.world.item.ItemStack.EMPTY);
        for (int i = 0; i < list.size(); ++i) {
            list.set(i, (Object)RecipeHelper.craftingRemainer(input.getItem(i)));
        }
        return list;
    }
}

