/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.plugin;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import net.momirealms.craftengine.bukkit.advancement.BukkitAdvancementManager;
import net.momirealms.craftengine.bukkit.api.event.CraftEngineReloadEvent;
import net.momirealms.craftengine.bukkit.block.BukkitBlockManager;
import net.momirealms.craftengine.bukkit.block.behavior.BukkitBlockBehaviors;
import net.momirealms.craftengine.bukkit.block.entity.renderer.element.BukkitBlockEntityElementConfigs;
import net.momirealms.craftengine.bukkit.entity.furniture.BukkitFurnitureManager;
import net.momirealms.craftengine.bukkit.entity.furniture.hitbox.BukkitHitBoxTypes;
import net.momirealms.craftengine.bukkit.entity.projectile.BukkitProjectileManager;
import net.momirealms.craftengine.bukkit.font.BukkitFontManager;
import net.momirealms.craftengine.bukkit.item.BukkitItemManager;
import net.momirealms.craftengine.bukkit.item.behavior.BukkitItemBehaviors;
import net.momirealms.craftengine.bukkit.item.recipe.BukkitRecipeManager;
import net.momirealms.craftengine.bukkit.loot.BukkitVanillaLootManager;
import net.momirealms.craftengine.bukkit.pack.BukkitPackManager;
import net.momirealms.craftengine.bukkit.plugin.BukkitPlatform;
import net.momirealms.craftengine.bukkit.plugin.command.BukkitCommandManager;
import net.momirealms.craftengine.bukkit.plugin.command.BukkitSenderFactory;
import net.momirealms.craftengine.bukkit.plugin.gui.BukkitGuiManager;
import net.momirealms.craftengine.bukkit.plugin.injector.BlockGenerator;
import net.momirealms.craftengine.bukkit.plugin.injector.BlockStateGenerator;
import net.momirealms.craftengine.bukkit.plugin.injector.InjectionException;
import net.momirealms.craftengine.bukkit.plugin.injector.LootEntryInjector;
import net.momirealms.craftengine.bukkit.plugin.injector.ProtectedFieldVisitor;
import net.momirealms.craftengine.bukkit.plugin.injector.RecipeInjector;
import net.momirealms.craftengine.bukkit.plugin.injector.WorldStorageInjector;
import net.momirealms.craftengine.bukkit.plugin.network.BukkitNetworkManager;
import net.momirealms.craftengine.bukkit.plugin.network.PacketConsumers;
import net.momirealms.craftengine.bukkit.plugin.scheduler.BukkitSchedulerAdapter;
import net.momirealms.craftengine.bukkit.plugin.user.BukkitServerPlayer;
import net.momirealms.craftengine.bukkit.sound.BukkitSoundManager;
import net.momirealms.craftengine.bukkit.util.EventUtils;
import net.momirealms.craftengine.bukkit.util.RegistryUtils;
import net.momirealms.craftengine.bukkit.world.BukkitWorldManager;
import net.momirealms.craftengine.core.item.ItemManager;
import net.momirealms.craftengine.core.plugin.CraftEngine;
import net.momirealms.craftengine.core.plugin.classpath.ClassPathAppender;
import net.momirealms.craftengine.core.plugin.classpath.ReflectionClassPathAppender;
import net.momirealms.craftengine.core.plugin.command.sender.SenderFactory;
import net.momirealms.craftengine.core.plugin.compatibility.CompatibilityManager;
import net.momirealms.craftengine.core.plugin.config.Config;
import net.momirealms.craftengine.core.plugin.dependency.Dependencies;
import net.momirealms.craftengine.core.plugin.dependency.Dependency;
import net.momirealms.craftengine.core.plugin.gui.category.ItemBrowserManagerImpl;
import net.momirealms.craftengine.core.plugin.locale.TranslationManagerImpl;
import net.momirealms.craftengine.core.plugin.logger.JavaPluginLogger;
import net.momirealms.craftengine.core.plugin.logger.PluginLogger;
import net.momirealms.craftengine.core.plugin.scheduler.SchedulerAdapter;
import net.momirealms.craftengine.core.plugin.scheduler.SchedulerTask;
import net.momirealms.craftengine.core.util.CharacterUtils;
import net.momirealms.craftengine.core.util.ReflectionUtils;
import net.momirealms.craftengine.core.util.VersionHelper;
import net.momirealms.craftengine.libraries.antigrieflib.AntiGriefLib;
import net.momirealms.craftengine.libraries.bstats.bukkit.Metrics;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jspecify.annotations.Nullable;

public class BukkitCraftEngine
extends CraftEngine {
    private static final String COMPATIBILITY_CLASS = "net.momirealms.craftengine.bukkit.compatibility.BukkitCompatibilityManager";
    private static BukkitCraftEngine instance;
    private SchedulerTask tickTask;
    private boolean successfullyLoaded = false;
    private boolean successfullyEnabled = false;
    private AntiGriefLib antiGrief;
    private JavaPlugin javaPlugin;
    private final Path dataFolderPath;

    protected BukkitCraftEngine(JavaPlugin plugin) {
        this(new JavaPluginLogger(plugin.getLogger()), plugin.getDataFolder().toPath().toAbsolutePath(), new ReflectionClassPathAppender(plugin.getClass().getClassLoader()), new ReflectionClassPathAppender(plugin.getClass().getClassLoader()));
        this.setJavaPlugin(plugin);
    }

    protected BukkitCraftEngine(PluginLogger logger, Path dataFolderPath, ClassPathAppender sharedClassPathAppender, ClassPathAppender privateClassPathAppender) {
        super((CraftEngine p) -> {
            CraftEngineReloadEvent event = new CraftEngineReloadEvent((BukkitCraftEngine)p);
            EventUtils.fireAndForget(event);
        });
        instance = this;
        this.dataFolderPath = dataFolderPath;
        this.sharedClassPathAppender = sharedClassPathAppender;
        this.privateClassPathAppender = privateClassPathAppender;
        this.logger = logger;
        this.platform = new BukkitPlatform();
        this.scheduler = new BukkitSchedulerAdapter(this);
        Class<?> compatibilityClass = ReflectionUtils.getClazz(COMPATIBILITY_CLASS);
        if (compatibilityClass != null) {
            try {
                this.compatibilityManager = (CompatibilityManager)Objects.requireNonNull(ReflectionUtils.getConstructor(compatibilityClass, 0)).newInstance(this);
            }
            catch (ReflectiveOperationException e) {
                this.logger().warn("Compatibility class could not be instantiated: " + compatibilityClass.getName());
            }
        }
    }

    protected void setJavaPlugin(JavaPlugin javaPlugin) {
        this.javaPlugin = javaPlugin;
    }

    protected void setUpConfig() {
        this.translationManager = new TranslationManagerImpl(this);
        this.config = new Config(this);
    }

    public void injectRegistries() {
        if (this.blockManager != null) {
            return;
        }
        try {
            BlockGenerator.init();
            BlockStateGenerator.init();
            this.blockManager = new BukkitBlockManager(this);
        }
        catch (Exception e) {
            throw new InjectionException("Error injecting blocks", e);
        }
        try {
            LootEntryInjector.init();
        }
        catch (Exception e) {
            throw new InjectionException("Error injecting loot entries", e);
        }
    }

    @Override
    public void onPluginLoad() {
        if (this.blockManager == null) {
            this.injectRegistries();
        }
        try {
            WorldStorageInjector.init();
        }
        catch (Exception e) {
            throw new InjectionException("Error injecting world storage", e);
        }
        try {
            RecipeInjector.init();
        }
        catch (Exception e) {
            throw new InjectionException("Error injecting recipes", e);
        }
        try {
            ProtectedFieldVisitor.init();
        }
        catch (Exception e) {
            throw new InjectionException("Error initializing ProtectedFieldVisitor", e);
        }
        super.onPluginLoad();
        this.blockManager.init();
        this.networkManager = new BukkitNetworkManager(this);
        this.itemManager = new BukkitItemManager(this);
        this.successfullyLoaded = true;
        super.compatibilityManager().onLoad();
    }

    @Override
    protected List<Dependency> platformDependencies() {
        return List.of(Dependencies.BSTATS_BUKKIT, Dependencies.CLOUD_BUKKIT, Dependencies.CLOUD_PAPER, Dependencies.CLOUD_BRIGADIER, Dependencies.CLOUD_MINECRAFT_EXTRAS);
    }

    @Override
    public void onPluginEnable() {
        if (this.successfullyEnabled) {
            this.logger().severe(" ");
            this.logger().severe(" ");
            this.logger().severe(" ");
            this.logger().severe("Please do not restart plugins at runtime.");
            this.logger().severe(" ");
            this.logger().severe(" ");
            this.logger().severe(" ");
            Bukkit.getPluginManager().disablePlugin((Plugin)this.javaPlugin);
            return;
        }
        this.successfullyEnabled = true;
        if (!this.successfullyLoaded) {
            this.logger().severe(" ");
            this.logger().severe(" ");
            this.logger().severe(" ");
            this.logger().severe("Failed to enable CraftEngine. Please check the log on loading stage.");
            this.logger().severe("To reduce the loss caused by plugin not loaded, now shutting down the server");
            this.logger().severe(" ");
            this.logger().severe(" ");
            this.logger().severe(" ");
            Bukkit.getServer().shutdown();
            return;
        }
        BukkitBlockBehaviors.init();
        BukkitItemBehaviors.init();
        BukkitHitBoxTypes.init();
        BukkitBlockEntityElementConfigs.init();
        PacketConsumers.initEntities(RegistryUtils.currentEntityTypeRegistrySize());
        this.packManager = new BukkitPackManager(this);
        this.senderFactory = new BukkitSenderFactory(this);
        this.recipeManager = new BukkitRecipeManager(this);
        this.commandManager = new BukkitCommandManager(this);
        this.itemBrowserManager = new ItemBrowserManagerImpl(this);
        this.guiManager = new BukkitGuiManager(this);
        this.worldManager = new BukkitWorldManager(this);
        this.soundManager = new BukkitSoundManager(this);
        this.vanillaLootManager = new BukkitVanillaLootManager(this);
        this.fontManager = new BukkitFontManager(this);
        this.advancementManager = new BukkitAdvancementManager(this);
        this.projectileManager = new BukkitProjectileManager(this);
        this.furnitureManager = new BukkitFurnitureManager(this);
        super.onPluginEnable();
        super.compatibilityManager().onEnable();
    }

    @Override
    public void onPluginDisable() {
        super.onPluginDisable();
        if (this.tickTask != null) {
            this.tickTask.cancel();
        }
        if (!Bukkit.getServer().isStopping()) {
            this.logger().severe(" ");
            this.logger().severe(" ");
            this.logger().severe(" ");
            this.logger().severe("Please do not disable plugins at runtime.");
            this.logger().severe(" ");
            this.logger().severe(" ");
            this.logger().severe(" ");
            Bukkit.getServer().shutdown();
        }
    }

    @Override
    public void platformDelayedEnable() {
        if (Config.metrics()) {
            new Metrics((Plugin)this.javaPlugin(), 24333);
        }
        if (!VersionHelper.isFolia()) {
            this.tickTask = this.scheduler().sync().runRepeating(() -> {
                for (BukkitServerPlayer serverPlayer : this.networkManager().onlineUsers()) {
                    serverPlayer.tick();
                }
            }, 1L, 1L);
        }
    }

    @Override
    public InputStream resourceStream(String filePath) {
        return this.getResource(CharacterUtils.replaceBackslashWithSlash(filePath));
    }

    private @Nullable InputStream getResource(String filename) {
        if (filename == null) {
            throw new IllegalArgumentException("filename cannot be null");
        }
        try {
            URL url = this.getClass().getClassLoader().getResource(filename);
            if (url == null) {
                return null;
            }
            URLConnection connection = url.openConnection();
            connection.setUseCaches(false);
            return connection.getInputStream();
        }
        catch (IOException ex) {
            return null;
        }
    }

    @Override
    public File dataFolderFile() {
        return this.dataFolderPath.toFile();
    }

    @Override
    public Path dataFolderPath() {
        return this.dataFolderPath;
    }

    @Override
    public String pluginVersion() {
        return this.javaPlugin().getDescription().getVersion();
    }

    @Override
    public String serverVersion() {
        return VersionHelper.MINECRAFT_VERSION.version();
    }

    public SchedulerAdapter<World> scheduler() {
        return this.scheduler;
    }

    public ItemManager<ItemStack> itemManager() {
        return this.itemManager;
    }

    @Override
    public BukkitBlockManager blockManager() {
        return (BukkitBlockManager)this.blockManager;
    }

    @Override
    public BukkitAdvancementManager advancementManager() {
        return (BukkitAdvancementManager)this.advancementManager;
    }

    @Override
    public BukkitFurnitureManager furnitureManager() {
        return (BukkitFurnitureManager)this.furnitureManager;
    }

    public SenderFactory<CraftEngine, CommandSender> senderFactory() {
        return this.senderFactory;
    }

    public JavaPlugin javaPlugin() {
        return this.javaPlugin;
    }

    public static BukkitCraftEngine instance() {
        return instance;
    }

    @Override
    public BukkitNetworkManager networkManager() {
        return (BukkitNetworkManager)this.networkManager;
    }

    @Override
    public BukkitPackManager packManager() {
        return (BukkitPackManager)this.packManager;
    }

    @Override
    public void saveResource(String resourcePath) {
        if (resourcePath.isEmpty()) {
            throw new IllegalArgumentException("ResourcePath cannot be null or empty");
        }
        File outFile = new File(this.dataFolderFile(), resourcePath);
        if (outFile.exists()) {
            return;
        }
        InputStream in = this.resourceStream(resourcePath = resourcePath.replace('\\', '/'));
        if (in == null) {
            return;
        }
        int lastIndex = resourcePath.lastIndexOf(47);
        File outDir = new File(this.dataFolderFile(), resourcePath.substring(0, Math.max(lastIndex, 0)));
        if (!outDir.exists()) {
            outDir.mkdirs();
        }
        try {
            int len;
            FileOutputStream out = new FileOutputStream(outFile);
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((OutputStream)out).close();
            in.close();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public BukkitServerPlayer adapt(@NotNull Player player) {
        Objects.requireNonNull(player, "player cannot be null");
        return (BukkitServerPlayer)this.networkManager().getOnlineUser(player);
    }

    public AntiGriefLib antiGriefProvider() {
        if (this.antiGrief == null) {
            this.antiGrief = AntiGriefLib.builder(this.javaPlugin).ignoreOP(true).silentLogs(false).build();
        }
        return this.antiGrief;
    }
}

