/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.plugin.command.feature;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.CompletableFuture;
import net.momirealms.craftengine.bukkit.plugin.command.BukkitCommandFeature;
import net.momirealms.craftengine.core.pack.Pack;
import net.momirealms.craftengine.core.plugin.CraftEngine;
import net.momirealms.craftengine.core.plugin.command.CraftEngineCommandManager;
import net.momirealms.craftengine.core.plugin.locale.MessageConstants;
import net.momirealms.craftengine.libraries.adventure.text.Component;
import net.momirealms.craftengine.libraries.boostedyaml.YamlDocument;
import net.momirealms.craftengine.libraries.cloud.Command;
import net.momirealms.craftengine.libraries.cloud.CommandManager;
import net.momirealms.craftengine.libraries.cloud.context.CommandContext;
import net.momirealms.craftengine.libraries.cloud.context.CommandInput;
import net.momirealms.craftengine.libraries.cloud.parser.standard.StringParser;
import net.momirealms.craftengine.libraries.cloud.suggestion.Suggestion;
import net.momirealms.craftengine.libraries.cloud.suggestion.SuggestionProvider;
import org.bukkit.command.CommandSender;
import org.checkerframework.checker.nullness.qual.NonNull;

public class DisableResourceCommand
extends BukkitCommandFeature<CommandSender> {
    public DisableResourceCommand(CraftEngineCommandManager<CommandSender> commandManager, CraftEngine plugin) {
        super(commandManager, plugin);
    }

    @Override
    public Command.Builder<? extends CommandSender> assembleCommand(CommandManager<CommandSender> manager, Command.Builder<CommandSender> builder) {
        return builder.flag(manager.flagBuilder("silent").withAliases(new String[]{"s"})).required("pack", StringParser.stringComponent((StringParser.StringMode)StringParser.StringMode.GREEDY).suggestionProvider((SuggestionProvider)new SuggestionProvider<Object>(){

            public @NonNull CompletableFuture<? extends @NonNull Iterable<? extends @NonNull Suggestion>> suggestionsFuture(@NonNull CommandContext<Object> context, @NonNull CommandInput input) {
                return CompletableFuture.completedFuture(DisableResourceCommand.this.plugin().packManager().loadedPacks().stream().filter(Pack::enabled).map(pack -> Suggestion.suggestion((String)pack.name())).toList());
            }
        })).handler(context -> {
            String packFolder = (String)context.get("pack");
            Path path = this.plugin().dataFolderPath().resolve("resources").resolve(packFolder);
            if (!Files.exists(path, new LinkOption[0])) {
                this.handleFeedback(context, MessageConstants.COMMAND_RESOURCE_DISABLE_FAILURE, new Component[]{Component.text((String)packFolder)});
                return;
            }
            Path packMetaPath = path.resolve("pack.yml");
            if (!Files.exists(packMetaPath, new LinkOption[0])) {
                try {
                    Files.createFile(packMetaPath, new FileAttribute[0]);
                }
                catch (IOException e) {
                    this.plugin().logger().warn("Could not create pack.yml file: " + String.valueOf(packMetaPath));
                    return;
                }
            }
            YamlDocument document = this.plugin().config().loadYamlData(packMetaPath);
            document.set("enable", (Object)false);
            try {
                document.save(packMetaPath.toFile());
            }
            catch (IOException e) {
                this.plugin().logger().warn("Could not save pack.yml file: " + String.valueOf(packMetaPath));
                return;
            }
            this.handleFeedback(context, MessageConstants.COMMAND_RESOURCE_DISABLE_SUCCESS, new Component[]{Component.text((String)packFolder)});
        });
    }

    @Override
    public String getFeatureID() {
        return "disable_resource";
    }
}

