/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.plugin.command.feature;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.momirealms.craftengine.bukkit.plugin.command.BukkitCommandFeature;
import net.momirealms.craftengine.core.pack.Pack;
import net.momirealms.craftengine.core.plugin.CraftEngine;
import net.momirealms.craftengine.core.plugin.command.CraftEngineCommandManager;
import net.momirealms.craftengine.core.plugin.locale.MessageConstants;
import net.momirealms.craftengine.core.util.AdventureHelper;
import net.momirealms.craftengine.libraries.adventure.text.Component;
import net.momirealms.craftengine.libraries.adventure.text.TextComponent;
import net.momirealms.craftengine.libraries.adventure.text.event.HoverEvent;
import net.momirealms.craftengine.libraries.adventure.text.event.HoverEventSource;
import net.momirealms.craftengine.libraries.adventure.text.format.NamedTextColor;
import net.momirealms.craftengine.libraries.adventure.text.format.TextColor;
import net.momirealms.craftengine.libraries.cloud.Command;
import net.momirealms.craftengine.libraries.cloud.CommandManager;
import org.bukkit.command.CommandSender;

public class ListResourceCommand
extends BukkitCommandFeature<CommandSender> {
    public ListResourceCommand(CraftEngineCommandManager<CommandSender> commandManager, CraftEngine plugin) {
        super(commandManager, plugin);
    }

    @Override
    public Command.Builder<? extends CommandSender> assembleCommand(CommandManager<CommandSender> manager, Command.Builder<CommandSender> builder) {
        return builder.handler(context -> {
            Collection<Pack> packs = this.plugin().packManager().loadedPacks();
            ArrayList<Pack> enabled = new ArrayList<Pack>();
            ArrayList<Pack> disabled = new ArrayList<Pack>();
            for (Pack pack : packs) {
                if (pack.enabled()) {
                    enabled.add(pack);
                    continue;
                }
                disabled.add(pack);
            }
            this.handleFeedback(context, MessageConstants.COMMAND_RESOURCE_LIST, new Component[]{Component.text((int)enabled.size()), Component.empty().children(this.getChildComponents(enabled)), Component.text((int)disabled.size()), Component.empty().children(this.getChildComponents(disabled))});
        });
    }

    private List<Component> getChildComponents(List<Pack> disabled) {
        ArrayList<Component> components = new ArrayList<Component>();
        for (int i = 0; i < disabled.size(); ++i) {
            Pack pack = disabled.get(i);
            components.add(this.getPackComponent(pack));
            if (i == disabled.size() - 1) continue;
            components.add((Component)Component.text((String)", "));
        }
        if (components.isEmpty()) {
            return List.of(Component.text((String)"[]"));
        }
        return components;
    }

    private Component getPackComponent(Pack pack) {
        String description = pack.meta().description();
        String version = pack.meta().version();
        String author = pack.meta().author();
        String text = version == null ? pack.name() : pack.name() + " v" + version;
        TextComponent base = Component.text((String)("[" + text + "]"));
        if (author != null || description != null) {
            base = author != null && description != null ? base.hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.empty().children(List.of(Component.text((String)("by: " + author)).color((TextColor)NamedTextColor.YELLOW), Component.newline(), AdventureHelper.miniMessage().deserialize((Object)description))))) : (author != null ? base.hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)("by: " + author)))) : base.hoverEvent((HoverEventSource)HoverEvent.showText((Component)AdventureHelper.miniMessage().deserialize((Object)description))));
        }
        return base;
    }

    @Override
    public String getFeatureID() {
        return "list_resource";
    }
}

