/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.plugin.gui;

import java.util.Iterator;
import net.momirealms.craftengine.bukkit.block.entity.BlockEntityHolder;
import net.momirealms.craftengine.bukkit.block.entity.SimpleStorageBlockEntity;
import net.momirealms.craftengine.bukkit.nms.FastNMS;
import net.momirealms.craftengine.bukkit.plugin.BukkitCraftEngine;
import net.momirealms.craftengine.bukkit.plugin.gui.BukkitClick;
import net.momirealms.craftengine.bukkit.plugin.gui.BukkitInventory;
import net.momirealms.craftengine.bukkit.plugin.gui.CraftEngineGUIHolder;
import net.momirealms.craftengine.bukkit.plugin.reflection.minecraft.CoreReflections;
import net.momirealms.craftengine.bukkit.plugin.reflection.minecraft.NetworkReflections;
import net.momirealms.craftengine.bukkit.util.ComponentUtils;
import net.momirealms.craftengine.bukkit.util.InventoryUtils;
import net.momirealms.craftengine.bukkit.util.LegacyInventoryUtils;
import net.momirealms.craftengine.core.block.entity.BlockEntity;
import net.momirealms.craftengine.core.entity.player.Player;
import net.momirealms.craftengine.core.plugin.CraftEngine;
import net.momirealms.craftengine.core.plugin.gui.AbstractGui;
import net.momirealms.craftengine.core.plugin.gui.Gui;
import net.momirealms.craftengine.core.plugin.gui.GuiManager;
import net.momirealms.craftengine.core.plugin.gui.GuiType;
import net.momirealms.craftengine.core.plugin.gui.Inventory;
import net.momirealms.craftengine.core.util.ReflectionUtils;
import net.momirealms.craftengine.libraries.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.MenuType;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.view.AnvilView;
import org.bukkit.inventory.view.CrafterView;
import org.bukkit.inventory.view.EnchantmentView;
import org.bukkit.inventory.view.LoomView;
import org.bukkit.plugin.Plugin;

public class BukkitGuiManager
implements GuiManager,
Listener {
    private static final boolean useNewOpenInventory = ReflectionUtils.getDeclaredMethod(InventoryView.class, Void.TYPE, new String[]{"open"}, new Class[0]) != null;
    private static BukkitGuiManager instance;
    private final BukkitCraftEngine plugin;

    public BukkitGuiManager(BukkitCraftEngine plugin) {
        this.plugin = plugin;
        instance = this;
    }

    @Override
    public void delayedInit() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin.javaPlugin());
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
    }

    @Override
    public void openInventory(Player player, GuiType guiType) {
        org.bukkit.entity.Player bukkitPlayer = (org.bukkit.entity.Player)player.platformPlayer();
        if (useNewOpenInventory) {
            switch (guiType) {
                case ANVIL: {
                    ((AnvilView)MenuType.ANVIL.create((HumanEntity)bukkitPlayer)).open();
                    break;
                }
                case LOOM: {
                    ((LoomView)MenuType.LOOM.create((HumanEntity)bukkitPlayer)).open();
                    break;
                }
                case ENCHANTMENT: {
                    ((EnchantmentView)MenuType.ENCHANTMENT.create((HumanEntity)bukkitPlayer)).open();
                    break;
                }
                case CRAFTING: {
                    ((CrafterView)MenuType.CRAFTER_3X3.create((HumanEntity)bukkitPlayer)).open();
                    break;
                }
                case CARTOGRAPHY: {
                    MenuType.CARTOGRAPHY_TABLE.create((HumanEntity)bukkitPlayer).open();
                    break;
                }
                case SMITHING: {
                    MenuType.SMITHING.create((HumanEntity)bukkitPlayer).open();
                    break;
                }
                case GRINDSTONE: {
                    MenuType.GRINDSTONE.create((HumanEntity)bukkitPlayer).open();
                }
            }
        } else {
            switch (guiType) {
                case ANVIL: {
                    LegacyInventoryUtils.openAnvil(bukkitPlayer);
                    break;
                }
                case LOOM: {
                    LegacyInventoryUtils.openLoom(bukkitPlayer);
                    break;
                }
                case GRINDSTONE: {
                    LegacyInventoryUtils.openGrindstone(bukkitPlayer);
                    break;
                }
                case SMITHING: {
                    LegacyInventoryUtils.openSmithingTable(bukkitPlayer);
                    break;
                }
                case CRAFTING: {
                    LegacyInventoryUtils.openWorkbench(bukkitPlayer);
                    break;
                }
                case ENCHANTMENT: {
                    LegacyInventoryUtils.openEnchanting(bukkitPlayer);
                    break;
                }
                case CARTOGRAPHY: {
                    LegacyInventoryUtils.openCartographyTable(bukkitPlayer);
                }
            }
        }
    }

    @Override
    public void updateInventoryTitle(Player player, Component component) {
        Object nmsPlayer = player.serverPlayer();
        try {
            Object containerMenu = FastNMS.INSTANCE.field$Player$containerMenu(nmsPlayer);
            int containerId = CoreReflections.field$AbstractContainerMenu$containerId.getInt(containerMenu);
            Object menuType = CoreReflections.field$AbstractContainerMenu$menuType.get(containerMenu);
            Object packet = NetworkReflections.constructor$ClientboundOpenScreenPacket.newInstance(containerId, menuType, ComponentUtils.adventureToMinecraft(component));
            player.sendPacket(packet, false);
        }
        catch (Exception e) {
            CraftEngine.instance().logger().warn("Failed to update inventory title", e);
        }
    }

    @Override
    public Inventory createInventory(Gui gui, int size) {
        CraftEngineGUIHolder holder = new CraftEngineGUIHolder(gui);
        org.bukkit.inventory.Inventory inventory = FastNMS.INSTANCE.createSimpleStorageContainer(holder, size, false, false);
        holder.holder().bindValue(inventory);
        return new BukkitInventory(inventory);
    }

    @EventHandler(ignoreCancelled=true)
    public void onInventoryClick(InventoryClickEvent event) {
        org.bukkit.inventory.Inventory inventory = event.getInventory();
        if (!InventoryUtils.isCustomContainer(inventory)) {
            return;
        }
        InventoryHolder inventoryHolder = inventory.getHolder();
        if (!(inventoryHolder instanceof CraftEngineGUIHolder)) {
            return;
        }
        CraftEngineGUIHolder craftEngineGUIHolder = (CraftEngineGUIHolder)inventoryHolder;
        AbstractGui gui = (AbstractGui)craftEngineGUIHolder.gui();
        org.bukkit.entity.Player player = (org.bukkit.entity.Player)event.getWhoClicked();
        if (event.getClickedInventory() == player.getInventory()) {
            gui.handleInventoryClick(new BukkitClick(event, gui, new BukkitInventory((org.bukkit.inventory.Inventory)player.getInventory())));
        } else if (event.getClickedInventory() == inventory) {
            gui.handleGuiClick(new BukkitClick(event, gui, new BukkitInventory(inventory)));
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOW)
    public void onInventoryDrag(InventoryDragEvent event) {
        org.bukkit.inventory.Inventory inventory = event.getInventory();
        if (!InventoryUtils.isCustomContainer(inventory)) {
            return;
        }
        if (!(inventory.getHolder() instanceof CraftEngineGUIHolder)) {
            return;
        }
        Iterator iterator = event.getRawSlots().iterator();
        while (iterator.hasNext()) {
            int raw = (Integer)iterator.next();
            if (raw >= inventory.getSize()) continue;
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOW)
    public void onInventoryClose(InventoryCloseEvent event) {
        org.bukkit.inventory.Inventory inventory = event.getInventory();
        if (!InventoryUtils.isCustomContainer(inventory)) {
            return;
        }
        InventoryHolder inventoryHolder = inventory.getHolder();
        if (!(inventoryHolder instanceof BlockEntityHolder)) {
            return;
        }
        BlockEntityHolder holder = (BlockEntityHolder)inventoryHolder;
        Object object = event.getPlayer();
        if (object instanceof org.bukkit.entity.Player) {
            org.bukkit.entity.Player player = (org.bukkit.entity.Player)object;
            object = holder.blockEntity();
            if (object instanceof SimpleStorageBlockEntity) {
                SimpleStorageBlockEntity simpleStorageBlockEntity = (SimpleStorageBlockEntity)object;
                simpleStorageBlockEntity.onPlayerClose(this.plugin.adapt(player));
            }
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOW)
    public void onInventoryClose(PlayerQuitEvent event) {
        org.bukkit.entity.Player player = event.getPlayer();
        PlayerInventory inventory = player.getInventory();
        if (!InventoryUtils.isCustomContainer((org.bukkit.inventory.Inventory)inventory)) {
            return;
        }
        InventoryHolder inventoryHolder = inventory.getHolder();
        if (!(inventoryHolder instanceof BlockEntityHolder)) {
            return;
        }
        BlockEntityHolder holder = (BlockEntityHolder)inventoryHolder;
        BlockEntity blockEntity = holder.blockEntity();
        if (blockEntity instanceof SimpleStorageBlockEntity) {
            SimpleStorageBlockEntity simpleStorageBlockEntity = (SimpleStorageBlockEntity)blockEntity;
            simpleStorageBlockEntity.onPlayerClose(this.plugin.adapt(player));
        }
    }

    public static BukkitGuiManager instance() {
        return instance;
    }
}

