/*
 * Decompiled with CFR 0.152.
 */
package net.momirealms.craftengine.bukkit.plugin.network.handler;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.momirealms.craftengine.bukkit.entity.data.BaseEntityData;
import net.momirealms.craftengine.bukkit.entity.data.PrimedTntData;
import net.momirealms.craftengine.bukkit.nms.FastNMS;
import net.momirealms.craftengine.bukkit.plugin.network.PacketConsumers;
import net.momirealms.craftengine.bukkit.util.BlockStateUtils;
import net.momirealms.craftengine.bukkit.util.ComponentUtils;
import net.momirealms.craftengine.core.entity.player.Player;
import net.momirealms.craftengine.core.plugin.CraftEngine;
import net.momirealms.craftengine.core.plugin.config.Config;
import net.momirealms.craftengine.core.plugin.context.NetworkTextReplaceContext;
import net.momirealms.craftengine.core.plugin.network.ByteBufPacketEvent;
import net.momirealms.craftengine.core.plugin.network.EntityPacketHandler;
import net.momirealms.craftengine.core.plugin.text.component.ComponentProvider;
import net.momirealms.craftengine.core.util.AdventureHelper;
import net.momirealms.craftengine.core.util.FriendlyByteBuf;
import net.momirealms.craftengine.libraries.adventure.text.Component;

public class PrimedTNTPacketHandler
implements EntityPacketHandler {
    public static final PrimedTNTPacketHandler INSTANCE = new PrimedTNTPacketHandler();

    @Override
    public void handleSetEntityData(Player user, ByteBufPacketEvent event) {
        FriendlyByteBuf buf = event.getBuffer();
        int id = buf.readVarInt();
        boolean isChanged = false;
        List<Object> packedItems = FastNMS.INSTANCE.method$ClientboundSetEntityDataPacket$unpack((Object)buf);
        for (int i = 0; i < packedItems.size(); ++i) {
            Optional optionalTextComponent;
            Object packedItem = packedItems.get(i);
            int entityDataId = FastNMS.INSTANCE.field$SynchedEntityData$DataValue$id(packedItem);
            if (entityDataId == PrimedTntData.BlockState.id()) {
                Object blockState = FastNMS.INSTANCE.field$SynchedEntityData$DataValue$value(packedItem);
                int stateId = BlockStateUtils.blockStateToId(blockState);
                int newStateId = !user.clientModEnabled() ? PacketConsumers.remap(stateId) : PacketConsumers.remapMOD(stateId);
                if (newStateId == stateId) continue;
                Object serializer = FastNMS.INSTANCE.field$SynchedEntityData$DataValue$serializer(packedItem);
                packedItems.set(i, FastNMS.INSTANCE.constructor$SynchedEntityData$DataValue(entityDataId, serializer, BlockStateUtils.idToBlockState(newStateId)));
                isChanged = true;
                continue;
            }
            if (!Config.interceptEntityName() || entityDataId != BaseEntityData.CustomName.id() || (optionalTextComponent = (Optional)FastNMS.INSTANCE.field$SynchedEntityData$DataValue$value(packedItem)).isEmpty()) continue;
            Object textComponent = optionalTextComponent.get();
            String json = ComponentUtils.minecraftToJson(textComponent);
            Map<String, ComponentProvider> tokens = CraftEngine.instance().fontManager().matchTags(json);
            if (tokens.isEmpty()) continue;
            Component component = AdventureHelper.replaceText(AdventureHelper.jsonToComponent(json), tokens, NetworkTextReplaceContext.of(user));
            Object serializer = FastNMS.INSTANCE.field$SynchedEntityData$DataValue$serializer(packedItem);
            packedItems.set(i, FastNMS.INSTANCE.constructor$SynchedEntityData$DataValue(entityDataId, serializer, Optional.of(ComponentUtils.adventureToMinecraft(component))));
            isChanged = true;
        }
        if (isChanged) {
            event.setChanged(true);
            buf.clear();
            buf.writeVarInt(event.packetID());
            buf.writeVarInt(id);
            FastNMS.INSTANCE.method$ClientboundSetEntityDataPacket$pack(packedItems, (Object)buf);
        }
    }
}

